/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.exception.ProjectException;

public class ResourceFilesContainerImpl
extends ProjectObjectContainerImpl
implements ResourceFilesContainer {
    private Project project;
    private XSLTransformationsContainer xslTransformationsContainer;

    public ResourceFilesContainerImpl(Project project) {
        super(project);
        this.project = project;
    }

    @Override
    public XSLTransformationsContainer getXSLTransformationsContainer() {
        if (this.xslTransformationsContainer == null) {
            try {
                Project container = this.getProject();
                this.xslTransformationsContainer = (XSLTransformationsContainer)this.getProject().getLoader().getObject(container, FolderContainer.class, Path.XSL.getName());
            }
            catch (ProjectException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return this.xslTransformationsContainer;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.project;
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectObjectList<ProjectObject> result = new ProjectObjectList<ProjectObject>();
        result.add(this.getXSLTransformationsContainer());
        return result;
    }
}

