/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import fuego.simulation.ModelSimulationImpl;
import fuego.simulation.ProjectSimulationImpl;
import java.util.Collection;
import java.util.List;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.casemgmt.CaseContainerImpl;
import oracle.bpm.project.casemgmt.ProjectCaseActivityImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.organization.CalendarRuleImpl;
import oracle.bpm.project.organization.GroupImpl;
import oracle.bpm.project.organization.HolidayRuleImpl;
import oracle.bpm.project.organization.OrganizationalChartImpl;
import oracle.bpm.project.organization.ParticipantImpl;

public abstract class ResourceContainerImpl
extends ProjectObjectContainerImpl
implements ResourceContainer {
    private boolean dirty;

    public ResourceContainerImpl(Project project) {
        super(project);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        assert (child instanceof ResourceObject) : "A resource container child must be a ResourceObject";
        super.addChild(child);
    }

    @Override
    public void replaceChild(ProjectObject object, ProjectObject replacement) throws ProjectException {
        assert (replacement instanceof ResourceObject) : "A resource container replacement must be a ResourceObject";
        super.replaceChild(object, replacement);
    }

    @Override
    public final Process createCallableSubprocess(String id) throws ProjectException {
        return this.createProcess(id, true, true, false);
    }

    @Override
    public final Process createEmptyCallableSubprocess(String id) throws ProjectException {
        return this.createProcess(id, false, true, false);
    }

    @Override
    public final Process createModel(String id, boolean isSync) throws ProjectException {
        return this.createProcess(id, true, false, isSync);
    }

    @Override
    public final Process createModel(String id) throws ProjectException {
        return this.createModel(id, false);
    }

    @Override
    public final Process createEmptyModel(String id) throws ProjectException {
        return this.createProcess(id, false, false, false);
    }

    @Override
    public Process createNoneEventModel(String id) throws ProjectException {
        return ProjectResourceObjectFactory.createNoneEventsProcess(this, id);
    }

    @Override
    public Role createRole(String roleId) throws ProjectException {
        return this.getProject().getOrganization().createRole(roleId, roleId);
    }

    @Override
    public CalendarRule createCalendarRule(String calendarRuleId) {
        CalendarRuleImpl calendarRule = new CalendarRuleImpl(this.getProject().getOrganization());
        calendarRule.asMutable().setId(calendarRuleId);
        return calendarRule;
    }

    @Override
    public Group createGroup(String groupId) throws ProjectException {
        GroupImpl group = new GroupImpl(this.getProject().getOrganization());
        group.setId(groupId);
        return group;
    }

    @Override
    public Participant createParticipant(String participantId) throws ProjectException {
        ParticipantImpl participant = new ParticipantImpl(this.getProject().getOrganization());
        participant.setId(participantId);
        participant.setDisplayName(participantId);
        return participant;
    }

    @Override
    public HolidayRule createHolidayRule(String holidayRuleId) throws ProjectException {
        HolidayRuleImpl holidayRule = new HolidayRuleImpl(this.getProject().getOrganization());
        holidayRule.setId(holidayRuleId);
        return holidayRule;
    }

    @Override
    public OrganizationalChart createOrganizationalChart(Organization organization, String organizationalChartId) throws ProjectException {
        return new OrganizationalChartImpl(organization, organizationalChartId);
    }

    @Override
    public ModelSimulation createModelSimulation(String modelId, String simulationId) {
        return ModelSimulationImpl.createModelSimulation(this.getProject(), modelId, simulationId);
    }

    @Override
    public ModelSimulation createEmptyModelSimulation(String modelId, String simulationId) {
        return ModelSimulationImpl.createEmptyModelSimulation(this.getProject(), modelId, simulationId);
    }

    @Override
    public ModelSimulation createEmptyModelSimulation(String simulationId) {
        return ModelSimulationImpl.createEmptyModelSimulation(this.getProject(), simulationId);
    }

    @Override
    public ProjectSimulation createProjectSimulation(String simulationId) throws ProjectException {
        return new ProjectSimulationImpl(this.getProject(), simulationId);
    }

    @Override
    public CaseContainer createCaseContainer() {
        return new CaseContainerImpl();
    }

    @Override
    public ProjectCaseActivity createProjectCaseActivity(CaseActivity caseActivity) {
        return new ProjectCaseActivityImpl(caseActivity);
    }

    @Override
    public ProjectObject copy() {
        return ResourceObjectImpl.copy(this);
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectLoader loader;
        Project project = this.getProject();
        ProjectLoader projectLoader = loader = project != null ? project.getLoader() : null;
        if (loader != null) {
            List<ProjectObject> objects = loader.getChildren(this);
            return new ProjectObjectList<ProjectObject>((Collection<ProjectObject>)objects);
        }
        return new ProjectObjectList<ProjectObject>();
    }

    private Process createProcess(String modelId, boolean createBeginAndEnd, boolean isCallable, boolean isSync) throws ProjectException {
        return ProjectResourceObjectFactory.createProcess(this, modelId, createBeginAndEnd, isCallable, !isCallable && isSync);
    }
}

