/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.InstanceVariable;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.type.TypeFactory;

public class ProjectVariableImpl
extends InstanceVariable
implements ProjectDataObject {
    public static final int[] VALID_KINDS = new int[]{1, 2, 4, 6, 3, 5};
    private static final String KEY_BUSINESS_TYPE = "BUSINESS_TYPE";
    private static final String KEY_BUSINESS_DATA = "BUSINESS_DATA";

    ProjectVariableImpl(NodeContainer content, String name, CatalogType type) {
        super(content, name, type);
    }

    public static boolean isSupportScale(CatalogType type) {
        return ProjectVariableImpl.isSupportSize(type) && type.getKind() == 3;
    }

    public static boolean isSupportSize(CatalogType type) {
        int kind = type.getKind();
        return kind == 5 || kind == 3;
    }

    public static TypeDescription[] getValidTypes() {
        TypeDescription[] values = new TypeDescription[]{TypeFactory.getBool(), TypeFactory.getInt(), TypeFactory.getReal(), TypeFactory.getTime(), TypeFactory.getDecimal(), TypeFactory.getString()};
        return values;
    }

    public static boolean isValidBusinessVariableType(CatalogType typDescription, BusinessVariableType type) {
        return type == BusinessVariableType.DIMENSION || (type == BusinessVariableType.MEASURE || type == BusinessVariableType.COUNTER) && ProjectVariableImpl.isSupportBussinesData(typDescription);
    }

    public static boolean isSupportBussinesData(CatalogType type) {
        int kind = type.getKind();
        return kind == 2 || kind == 3 || kind == 4;
    }

    public static BusinessVariableType getDefaultType(CatalogType type) {
        return ProjectVariableImpl.isSupportBussinesData(type) ? BusinessVariableType.MEASURE : BusinessVariableType.DIMENSION;
    }

    public static int getDefaultLength(CatalogType type) {
        int kind = type.getKind();
        return kind == 5 ? 30 : (kind == 3 ? 18 : -1);
    }

    public static int getDefaultScale(CatalogType type) {
        int kind = type.getKind();
        return kind == 3 ? 3 : -1;
    }

    @Override
    public void setBusinessVariableData(BusinessVariableData data) {
        this.setProperty(KEY_BUSINESS_DATA, data != null ? data.getProperties() : null);
    }

    @Override
    public void setBusinessVariableType(BusinessVariableType type) {
        this.setProperty(KEY_BUSINESS_TYPE, type == null ? null : type.toString());
        this.setReadOnly(type == BusinessVariableType.COUNTER);
    }

    @Override
    public BusinessVariableData getBusinessVariableData() {
        String properties = this.getProperty(KEY_BUSINESS_DATA);
        return properties != null ? BusinessVariableData.create((String)properties) : new BusinessVariableData();
    }

    @Override
    public BusinessVariableType getBusinessVariableType() {
        String properties = this.getProperty(KEY_BUSINESS_TYPE);
        return properties != null ? BusinessVariableType.valueOf((String)properties) : ProjectVariableImpl.getDefaultType(this.getType());
    }

    @Override
    public boolean isBusiness() {
        return this.getProperty(KEY_BUSINESS_TYPE) != null;
    }

    @Override
    public void delete() throws ProjectException {
        this.getProject().removeDeclaration(this);
    }

    @Override
    public Class getRawClass() {
        return ProjectDataObject.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    @Override
    public boolean isProjectDataObject() {
        return true;
    }
}

