/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;

public class ProjectResourceObjectFactory {
    public static Process createProcess(ResourceContainer container, String modelId, boolean createBeginAndEnd) throws ProjectException {
        return ProjectResourceObjectFactory.createProcess(container, modelId, createBeginAndEnd, false, createBeginAndEnd);
    }

    public static Process createProcess(ResourceContainer container, String modelId, boolean createBeginAndEnd, boolean isSync) throws ProjectException {
        return ProjectResourceObjectFactory.createProcess(container, modelId, createBeginAndEnd, false, createBeginAndEnd && isSync);
    }

    public static Process createManualProcess(ResourceContainer container, String modelId) throws ProjectException {
        ProcessContent processContent = new ProcessContent(container, (ComponentCatalog)TypeUtils.getDefaultCatalog());
        processContent.setId(modelId);
        processContent.createBeginAndEnd(true, true, EventTriggerType.NONE);
        return processContent;
    }

    public static Process createNoneEventsProcess(ResourceContainer container, String id) throws ProjectException {
        Process process = ProjectResourceObjectFactory.createProcess(container, id, true, false, false);
        StartEvent startEvent = ModelUtils.getStartEvent(process);
        startEvent.setEventTriggerType(EventTriggerType.NONE);
        EndEvent endEvent = ModelUtils.getAnyEndEvent(process);
        endEvent.setEventTriggerType(EventTriggerType.NONE);
        return process;
    }

    public static Process createProcess(ResourceContainer container, String modelId, boolean createBeginAndEnd, boolean isCallable, boolean isSync) throws ProjectException {
        ProcessContent processContent = new ProcessContent(container, (ComponentCatalog)TypeUtils.getDefaultCatalog());
        processContent.setId(modelId);
        processContent.createBeginAndEnd(createBeginAndEnd, createBeginAndEnd, isCallable, isSync);
        return processContent;
    }

    public static Process createProjectProcess(Project p, String modelId, boolean createBeginAndEnd) throws ProjectException {
        return ProjectResourceObjectFactory.createProcess(p, modelId, createBeginAndEnd, false);
    }
}

