/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.ProjectObjectRefImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;

public class OrganizationalUnitRefImpl
extends ProjectObjectRefImpl<OrganizationalUnit>
implements OrganizationalUnitRef {
    private String hierarchyName;
    private String name;
    private OrganizationalUnit ou;
    private Project project;

    public OrganizationalUnitRefImpl(String id, Project project) {
        super(id);
        this.project = project;
    }

    public OrganizationalUnitRefImpl(String id, String name, Project project) {
        this(id, project);
        this.name = name;
    }

    @Override
    public String getHierarchyName() {
        return this.hierarchyName;
    }

    @Override
    public void setHierarchyName(String hierarchyName) {
        this.hierarchyName = hierarchyName;
    }

    @Override
    public OrganizationalUnit getObject() {
        if (this.ou == null) {
            this.ou = this.project.getOrganization().findOrganizationalUnit(this.getId());
        }
        return this.ou;
    }

    @Override
    public String getName() {
        OrganizationalUnit unit = this.getObject();
        if (unit != null) {
            return unit.getName();
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationalUnitRefImpl that = (OrganizationalUnitRefImpl)o;
        return !(this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }
}

