/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.BPMNTypes;
import oracle.bpm.project.CounterImpl;
import oracle.bpm.project.InstanceVariable;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.SubprocessImpl;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.model.util.SimpleModelUtils;
import oracle.bpm.project.msg.ProjectMsg;

class NodeContainerManager {
    private NodeContainer delegateContainer;
    private Process process;
    private static final Predicate<FlowNode> IS_ACTIVITY = new Predicate<FlowNode>(){

        public boolean check(FlowNode node) {
            return node.isActivity();
        }
    };
    private static final Function<FlowNode, Activity> TO_ACTIVITY = new Function<FlowNode, Activity>(){

        public Activity eval(FlowNode node) {
            return BPMNTypes.getBPMNActivityFrom(node);
        }
    };
    private static final Function<FlowNode, Event> TO_EVENT = new Function<FlowNode, Event>(){

        public Event eval(FlowNode node) {
            return BPMNTypes.getBPMNEventFrom(node);
        }
    };
    private static final Predicate<FlowNode> IS_EVENT = new Predicate<FlowNode>(){

        public boolean check(FlowNode node) {
            return node.isEvent();
        }
    };
    private static final Predicate<FlowNode> IS_NOT_BOUNDARY = new Predicate<FlowNode>(){

        public boolean check(FlowNode node) {
            return !ModelUtils.isBoundaryEvent(node);
        }
    };
    private static final Predicate<FlowNode> IS_GATEWAY = new Predicate<FlowNode>(){

        public boolean check(FlowNode node) {
            return node.isGateway();
        }
    };
    private static final Function<FlowNode, Gateway> TO_GATEWAY = new Function<FlowNode, Gateway>(){

        public Gateway eval(FlowNode node) {
            return node.asAnyNode(Gateway.class);
        }
    };

    public NodeContainerManager(Process process) {
        this(process, null);
    }

    public NodeContainerManager(Process process, SubprocessImpl subprocess) {
        this.process = process;
        this.delegateContainer = subprocess == null ? process : subprocess;
    }

    public void validateAddChild(ProjectObject child) throws ProjectException {
        if (child instanceof SequenceFlow) {
            SequenceFlow seqFlow = (SequenceFlow)child;
            if (seqFlow.getSource() == null) {
                throw new IllegalArgumentException(ProjectMsg.TRANSITION_SOURCE_UNDEFINED.toString());
            }
            if (seqFlow.getTarget() == null) {
                throw new IllegalArgumentException(ProjectMsg.TRANSITION_TARGET_UNDEFINED.toString());
            }
        } else if (child instanceof DataObject) {
            DataObject dataObject = (DataObject)child;
            DataObject variableAlreadyExists = this.findDataObject(dataObject.getId());
            if (variableAlreadyExists != null) {
                throw new ProjectException(dataObject, ProjectMsg.VARIABLE_ALREADY_EXISTS(dataObject.getId()));
            }
            if (dataObject.getType().isArray()) {
                throw new ProjectException(this.getDelegateContainer(), ProjectMsg.INVALID_DATA_OBJECT_TYPE(dataObject.getType().getText()));
            }
        } else if (child instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)child;
            flowNode.setId(ModelUtils.nextIdFor(flowNode.getBpmnType(), flowNode));
        }
    }

    public Sequence<FlowNode> getFlowNodes() {
        return CollectionUtils.concat((Iterable[])new Iterable[]{this.getActivities(), this.getEvents(), this.getGateways()});
    }

    public <T extends FlowNode> Sequence<T> getFlowNodes(Class<T> clazz) {
        return ModelUtils.selectBpmnClass(this.getFlowNodes(), clazz);
    }

    public <T extends Activity> Sequence<T> getActivities(Class<T> clazz) {
        return ModelUtils.selectBpmnClass(this.getActivities(), clazz);
    }

    public Sequence<Activity> getActivities() {
        return this.getDelegateContainer().getChildrenByType(FlowNode.class).select(IS_ACTIVITY).map(TO_ACTIVITY);
    }

    public <T extends Event> Sequence<T> getEvents(Class<T> clazz) {
        return ModelUtils.selectBpmnClass(this.getEvents(), clazz);
    }

    public <T extends Event> Sequence<T> getEvents(Class<T> clazz, final EventTriggerType trigger) {
        return this.getEvents(clazz).select(new Predicate<T>(){

            public boolean check(T event) {
                return event.getEventTriggerType() == trigger;
            }
        });
    }

    public Sequence<Event> getEvents() {
        return this.getDelegateContainer().getChildrenByType(FlowNode.class).select(PredicateUtils.and(IS_EVENT, IS_NOT_BOUNDARY)).map(TO_EVENT);
    }

    public <T extends Gateway> Sequence<T> getGateways(Class<T> clazz) {
        return ModelUtils.selectBpmnClass(this.getGateways(), clazz);
    }

    public Sequence<Gateway> getGateways() {
        return this.getDelegateContainer().getChildrenByType(FlowNode.class).select(IS_GATEWAY).map(TO_GATEWAY);
    }

    public FlowNode findNode(String flowNodeName) {
        FlowNode result = null;
        if (flowNodeName != null) {
            for (FlowNode node : this.getFlowNodes()) {
                if (!node.getId().equalsIgnoreCase(flowNodeName)) continue;
                result = node;
            }
            if (result == null) {
                result = this.findBoundaryEvent(flowNodeName);
            }
        }
        return result;
    }

    public FlowNode findNodeByLabel(String nodeLabel) {
        if (nodeLabel != null) {
            for (FlowNode node : this.getDelegateContainer().getDescendants(FlowNode.class)) {
                if (!node.getDefaultLabel().equalsIgnoreCase(nodeLabel)) continue;
                return node;
            }
        }
        return null;
    }

    public Gateway findGateway(final String gatewayId) {
        if (gatewayId == null) {
            return null;
        }
        return (Gateway)CollectionUtils.findFirst(this.getGateways(), (Predicate)new Predicate<Gateway>(){

            public boolean check(Gateway gateway) {
                return gateway.getId().equalsIgnoreCase(gatewayId);
            }
        });
    }

    public Event findEvent(final String eventId) {
        if (eventId == null) {
            return null;
        }
        return (Event)CollectionUtils.findFirst(this.getEvents(), (Predicate)new Predicate<Event>(){

            public boolean check(Event event) {
                return event.getId().equalsIgnoreCase(eventId);
            }
        });
    }

    public BoundaryEvent findBoundaryEvent(final String eventId) {
        if (eventId == null) {
            return null;
        }
        return (BoundaryEvent)CollectionUtils.findFirst(this.getBoundaryEvents(), (Predicate)new Predicate<BoundaryEvent>(){

            public boolean check(BoundaryEvent event) {
                return event.getId().equalsIgnoreCase(eventId);
            }
        });
    }

    public Activity findActivity(String activityId) {
        if (activityId == null) {
            return null;
        }
        return this.getDelegateContainer().findDescendant(Activity.class, activityId);
    }

    public TextAnnotation createTextAnnotation(String id) {
        String textId = id != null ? id : SimpleModelUtils.nextIdForTextAnnotation(this.getProcess());
        TextAnnotationImpl annotation = new TextAnnotationImpl((ProcessContent)this.getProcess());
        annotation.setId(textId);
        return annotation;
    }

    public Sequence<Measurement> getMeasurements() {
        return this.getDelegateContainer().getChildrenByType(Measurement.class);
    }

    public Activity createActivity() {
        return this.createActivity(true);
    }

    public Activity createActivity(boolean needLabel) {
        return this.createActivity(BpmnType.ABSTRACT_ACTIVITY, null, needLabel);
    }

    public Subprocess createSubprocess() {
        return this.createSubprocess(false);
    }

    public Subprocess createSubprocess(boolean isTriggeredByEvent) {
        return new SubprocessImpl((ProcessContent)this.getProcess(), this.getDelegateContainer(), isTriggeredByEvent);
    }

    public ThrowEvent createIntermediateThrowEvent(EventTriggerType triggerType) {
        return this.createActivity(BpmnType.THROW_INTERMEDIATE_EVENT, triggerType);
    }

    public CatchEvent createIntermediateCatchEvent(EventTriggerType triggerType) {
        return this.createActivity(BpmnType.CATCH_INTERMEDIATE_EVENT, triggerType);
    }

    public BoundaryEvent createBoundaryEvent(EventTriggerType triggerType, Activity boundaryTarget) {
        ActivityImpl result = this.createActivity(BpmnType.BOUNDARY_EVENT, triggerType);
        return result.toBoundary(triggerType, boundaryTarget);
    }

    public StartEvent createStartEvent(EventTriggerType triggerType) {
        return this.createActivity(BpmnType.START_EVENT, triggerType);
    }

    public Measurement createMeasurement(String measurementId) {
        MeasurementImpl measurement = new MeasurementImpl(this.getProcess(), this.getDelegateContainer(), measurementId);
        measurement.setMeasurementType(MeasurementType.START_STOP);
        return measurement;
    }

    public EndEvent createEndEvent(EventTriggerType triggerType) {
        return this.createActivity(BpmnType.END_EVENT, triggerType);
    }

    public SequenceFlow createSequenceFlow() {
        return this.createTransition(TransitionType.UNCONDITIONAL);
    }

    public SequenceFlow createSequenceFlow(FlowNode source, FlowNode target) {
        SequenceFlow transition = this.createSequenceFlow();
        transition.setSource(source);
        transition.setTarget(target);
        return transition;
    }

    public Sequence<SequenceFlow> getSequenceFlows() {
        return this.getDelegateContainer().getChildrenByType(SequenceFlow.class);
    }

    public Sequence<TextAnnotation> getTextAnnotations() {
        return this.getDelegateContainer().getChildrenByType(TextAnnotation.class);
    }

    public SequenceFlow findSequenceFlow(String sequenceFlowId) {
        for (SequenceFlow sf : this.getSequenceFlows()) {
            if (!sf.getId().equals(sequenceFlowId)) continue;
            return sf;
        }
        return null;
    }

    public Measurement findMeasurement(String measurementId) {
        if (measurementId != null) {
            for (Measurement measurement : this.getDelegateContainer().getDescendants(Measurement.class)) {
                if (!measurement.getId().equalsIgnoreCase(measurementId)) continue;
                return measurement;
            }
        }
        return null;
    }

    public TextAnnotation findTextAnnotation(String noteId) {
        if (noteId != null) {
            for (TextAnnotation textAnnotation : this.getTextAnnotations()) {
                if (!textAnnotation.getId().equals(noteId)) continue;
                return textAnnotation;
            }
        }
        return null;
    }

    public ParallelGateway createParallelGateway() {
        return this.createActivity(BpmnType.PARALLEL_GATEWAY, null);
    }

    public ExclusiveGateway createExclusiveGateway() {
        return this.createActivity(BpmnType.EXCLUSIVE_GATEWAY, null);
    }

    public InclusiveGateway createInclusiveGateway() {
        return this.createActivity(BpmnType.INCLUSIVE_GATEWAY, null);
    }

    public EventBasedGateway createEventBasedGateway() {
        return this.createActivity(BpmnType.EVENT_BASED_GATEWAY, null);
    }

    public ComplexGateway createComplexGateway() {
        return this.createActivity(BpmnType.COMPLEX_GATEWAY, null);
    }

    public Sequence<BoundaryEvent> getBoundaryEvents() {
        return ModelUtils.selectBpmnClass(this.getDelegateContainer().getChildrenByType(FlowNode.class), BoundaryEvent.class);
    }

    public Counter createCounter(String counterId) {
        return new CounterImpl(counterId, this.getProcess());
    }

    public Counter findCounter(String counterId) {
        return this.getDelegateContainer().findChild(Counter.class, counterId);
    }

    public Sequence<Counter> getCounters() {
        return this.getDelegateContainer().getChildrenByType(Counter.class);
    }

    public DataObject createDataObject(String dataObjectId, CatalogType type) {
        NodeContainer nodeContainer = this.getDelegateContainer();
        boolean isProcessModel = nodeContainer instanceof Process && ModelUtils.isDefaultProcess((Process)nodeContainer);
        return isProcessModel ? new ProjectVariableImpl(nodeContainer, dataObjectId, type) : new InstanceVariable(nodeContainer, dataObjectId, type);
    }

    public DataObject findDataObject(String dataObjectId) {
        return this.getDelegateContainer().findChild(DataObject.class, dataObjectId);
    }

    public Sequence<DataObject> getDataObjects() {
        return this.getDelegateContainer().getChildrenByType(DataObject.class);
    }

    private SequenceFlow createTransition(TransitionType type) {
        SequenceFlowImpl transition = new SequenceFlowImpl(this.getProcess(), this.getDelegateContainer(), type);
        transition.setId(ModelUtils.nextIdForSequenceFlow(this.getProcess()));
        return transition;
    }

    private Process getProcess() {
        return this.process;
    }

    private NodeContainer getDelegateContainer() {
        return this.delegateContainer;
    }

    private ActivityImpl createActivity(BpmnType type, EventTriggerType triggerType) {
        ActivityImpl activity = new ActivityImpl(this.getProcess(), this.getDelegateContainer(), type, triggerType);
        activity.setDefaultLabel(ModelUtils.nextLabelForActivity(this.getProcess(), type.getString()));
        return activity;
    }

    private ActivityImpl createActivity(BpmnType type, EventTriggerType triggerType, boolean needLabel) {
        ActivityImpl activity = new ActivityImpl(this.getProcess(), this.getDelegateContainer(), type, triggerType);
        if (needLabel) {
            activity.setDefaultLabel(ModelUtils.nextLabelForActivity(this.getProcess(), type.getString()));
        }
        return activity;
    }
}

