/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.JaxbAbstractCompositeAccessor;
import oracle.bpm.project.catalog.composite.jaxb.Composite;
import oracle.bpm.project.catalog.composite.jaxb.CompositeUtils;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public final class JaxbCompositeAccessor
extends JaxbAbstractCompositeAccessor {
    public JaxbCompositeAccessor(@NotNull Project project) {
        super(project);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadComposite() throws CompositeAccessorException {
        ProjectLoader loader = this.getProject().getLoader();
        assert (loader != null) : "There is not a loader for the project";
        ProjectFileSystem fileSystem = loader.getProjectFileSystem();
        VFileSystem fs = fileSystem.getDataFileSystem();
        VFile compositeFile = fs.createFile("composite.xml");
        VFileInputStream vFileInputStream = null;
        try {
            if (!compositeFile.exists()) throw new CompositeAccessorException((Msg)ProjectCatalogMsg.INVALID_COMPOSITE_DATA);
            vFileInputStream = new VFileInputStream(compositeFile);
            JAXBElement element = CompositeUtils.loadScaElement((InputStream)vFileInputStream, Composite.class);
            this.setJaxbModel((Composite)element.getValue());
        }
        catch (JAXBException e) {
            try {
                throw new CompositeAccessorException((Throwable)e);
                catch (IOException e2) {
                    throw new CompositeAccessorException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
    }
}

