/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectUtils;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StorageType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NotNull;

public class InstanceVariable
extends DataDeclarationImpl
implements Comparable,
DataObject {
    private AttributeTypeDescription attribute;
    private LocaleStringMap descriptionMap;
    private LocaleStringMap documentationStringMap;
    private boolean ignoreEvents = false;
    private boolean isInitialize = true;
    private boolean modified;
    private NodeContainer nodeContainer;
    private boolean notify = true;
    private Path path;
    private boolean readOnly;
    private int size = 0;
    private LocaleStringMap useCaseDocumentationStringMap;
    private static final long DEFAULT_MODIFIERS = 8589967372L;
    public static final Msg[] CATEGORIES = new Msg[]{ProjectMsg.NORMAL, ProjectMsg.SEPARATED, ProjectMsg.EXTERNAL};
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int INTERVAL = 2;
    public static final int TIME = 3;
    public static final int INT = 4;
    public static final int DECIMAL = 5;
    public static final int REAL = 6;
    public static int MAX_VAR_NAME_SIZE = 15;
    public static int MAX_VAR_DESC_SIZE = 30;

    InstanceVariable(final NodeContainer nodeContainer, String name, CatalogType type) {
        super(nodeContainer.getProject());
        this.nodeContainer = nodeContainer;
        this.attribute = new AttributeTypeDescription(name, type.getDynamicRef());
        this.attribute.setModifiers(8589967372L);
        this.attribute.addPropertyObserver("type", new ObjectPropertyListener(){

            public void propertyChanged(Object object, String propertyName) {
                if (object == InstanceVariable.this.attribute && !InstanceVariable.this.ignoreEvents) {
                    TypeDescription value = InstanceVariable.this.attribute.getResultType();
                    InstanceVariable.this.fireChange(propertyName, value, nodeContainer);
                }
            }
        });
        this.attribute.addPropertyObserver("name", new ObjectPropertyListener(){

            public void propertyChanged(Object object, String propertyName) {
                if (object == InstanceVariable.this.attribute && !InstanceVariable.this.ignoreEvents) {
                    InstanceVariable.this.fireChange(propertyName, InstanceVariable.this.getName(), nodeContainer);
                }
            }
        });
    }

    public static Msg getMsg(int category) {
        return category >= 0 && category < CATEGORIES.length ? CATEGORIES[category] : null;
    }

    public static boolean isValidName(String name) {
        return Identifier.isValid((String)name);
    }

    public boolean isCompatibleTo(InstanceVariable newVar) {
        boolean kindCompatible;
        if (!this.getName().equals(newVar.getName())) {
            return false;
        }
        boolean bl = kindCompatible = this.getType().getKind() != newVar.getType().getKind();
        if (!kindCompatible) {
            boolean textCompatible = this.getType().getText().equals(newVar.getType().getText());
            if (!textCompatible) {
                return false;
            }
        } else {
            if (this.getType().getLength() != -1 && this.getType().getScale() != -1 && (this.getType().getLength() != newVar.getType().getLength() || this.getType().getScale() != newVar.getType().getScale())) {
                return false;
            }
            if (!this.getType().isTime() && this.getType().getScale() != -1 && this.getType().getScale() != newVar.getType().getScale()) {
                return false;
            }
            if (this.getType().getLength() != -1 && (this.getType().isString() || this.getType().isInt() && this.getType().getLength() != 32 || this.getType().isReal() && this.getType().getLength() != 64) && this.getType().getLength() > newVar.getType().getLength()) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.nodeContainer.getProject();
    }

    @Override
    public String getName() {
        return this.attribute.getName();
    }

    @Override
    public String getDescription() {
        return this.attribute.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.attribute.setDescription(description);
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.create(this.getNodeContainer().getPath(), this.getId());
        }
        return this.path;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getNodeContainer();
    }

    @Override
    public ResourceObject findResourceObject() {
        return this.getNodeContainer().getProcess();
    }

    @Override
    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.equals(projectObject) || this.getParentObject().isDescendantOf(projectObject);
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
    }

    public boolean isModified() {
        return this.modified;
    }

    public NodeContainer getNodeContainer() {
        return this.nodeContainer;
    }

    public boolean isUsedInMeasurementMarks() {
        return false;
    }

    public void setStorageType(StorageType storageType) {
        long newMod = this.getModifiers();
        if (StorageType.SEPARATED.equals((Object)storageType)) {
            newMod |= 0x200000000L;
            newMod &= 0xFFFFFFFBFFFFFFFFL;
        } else if (StorageType.COLUMN.equals((Object)storageType)) {
            newMod |= 0x400000000L;
            newMod &= 0xFFFFFFFDFFFFFFFFL;
        } else {
            newMod &= 0xFFFFFFFDFFFFFFFFL;
            newMod &= 0xFFFFFFFBFFFFFFFFL;
        }
        this.attribute.setModifiers(newMod);
    }

    public StorageType getStorageType() {
        StorageType result = StorageType.NORMAL;
        long modifier = this.getModifiers();
        if (Modifier.isDetached((long)modifier)) {
            result = StorageType.SEPARATED;
        } else if (Modifier.isColumn((long)modifier)) {
            result = StorageType.COLUMN;
        }
        return result;
    }

    public long getModifiers() {
        long mods = this.attribute.getModifiers();
        return mods;
    }

    @Override
    public void setTypeDescription(CatalogType typeDescription) {
        this.setType(typeDescription);
    }

    public void setProperties(Properties props) {
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        Class<?> cl = this.getClass();
        while (it.hasNext()) {
            Map.Entry<Object, Object> key = it.next();
            String value = (String)key.getValue();
            try {
                Method m = cl.getMethod("set" + Identifier.capitalize((String)((String)key.getKey())), String.class);
                m.invoke((Object)this, value);
            }
            catch (NoSuchMethodException e) {
                Log.logWarning((Throwable)e);
                System.out.println("No method " + e.getMessage() + " in " + this.getClass() + ": " + this.getName());
            }
            catch (SecurityException e) {
                Log.logWarning((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.logWarning((Throwable)e);
                System.out.println(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Log.logWarning((Throwable)e);
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public void setType(CatalogType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        this.attribute.setType(type.getDynamicRef());
    }

    @Override
    public boolean isInitialize() {
        return this.isInitialize;
    }

    @Override
    public void setInitialize(boolean isInitialize) {
        this.isInitialize = isInitialize;
    }

    @Override
    public DataDeclarationContainer getDeclarationContainer() {
        if (this.getParentObject() == this.getProject().getProjectModel()) {
            return this.getProject();
        }
        return (DataDeclarationContainer)this.getParentObject();
    }

    public void setType(String type) {
        TypeRef typeref = TypeFactory.forNameLazy((String)type, (ComponentCatalog)this.nodeContainer.getProject().getComponentCatalog());
        if (typeref == null) {
            typeref = UnknownType.create((String)type, (ComponentCatalog)this.nodeContainer.getProject().getComponentCatalog());
        }
        this.setType(CatalogTypeImpl.get((TypeRef)typeref.get()));
    }

    public int compareTo(Object object) {
        if (!(object instanceof InstanceVariable)) {
            return 0;
        }
        return this.getName().compareTo(((InstanceVariable)object).getName());
    }

    public void dumpMetaData(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("      Name:   " + this.getName());
        bufferedWriter.newLine();
        bufferedWriter.write("      Type:   " + this.attribute.getTypeRef().getText());
        bufferedWriter.newLine();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public CatalogType getType() {
        return CatalogTypeImpl.get((TypeRef)this.attribute.getType());
    }

    @Override
    public boolean isIn() {
        return this.attribute.hasSetter();
    }

    @Override
    public boolean isOut() {
        return this.attribute.hasGetter();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public DataDeclarationType getDeclarationType() {
        return DataDeclarationType.DATA_OBJECT;
    }

    @Override
    public AttributeTypeDescription asAttributeTypeDescription() {
        return this.attribute;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.INSTANCE_VARIABLE;
    }

    @Override
    public Process getProcess() {
        return this.nodeContainer.getProcess();
    }

    @Override
    public LocaleStringMap getLabelMap() {
        return this.attribute.getDisplayNames();
    }

    public void setLabelMap(LocaleStringMap localeStringMap) {
    }

    @Override
    public String getDefaultLabel() {
        String label = ProjectObjectImpl.getString((I18nProvider)this.getLabelMap(), this.getDefaultLocale());
        return label != null && label.trim().length() > 0 ? label : this.getId();
    }

    @Override
    public String getDefaultDescription() {
        String label = ProjectObjectImpl.getString((I18nProvider)this.getDescriptionMap(), this.getDefaultLocale());
        return label != null && label.trim().length() > 0 ? label : "";
    }

    @Override
    public String getLabel(Locale locale) {
        return this.attribute.getDisplayName(locale);
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        if (this.descriptionMap == null) {
            this.descriptionMap = new LocaleStringMap(){

                protected String get(Locale locale) {
                    return InstanceVariable.this.getDescription();
                }
            };
        }
        return this.descriptionMap;
    }

    @Override
    public LocaleStringMap getDocumentationMap() {
        if (this.documentationStringMap == null) {
            this.documentationStringMap = new LocaleStringMap(){

                protected String get(Locale locale) {
                    return InstanceVariable.this.attribute.getDocumentation(DocumentationType.DOCUMENTATION, locale);
                }
            };
        }
        return this.documentationStringMap;
    }

    @Override
    public LocaleStringMap getUseCaseDocumentationMap() {
        if (this.useCaseDocumentationStringMap == null) {
            this.useCaseDocumentationStringMap = LocaleStringMap.create();
        }
        return this.useCaseDocumentationStringMap;
    }

    @Override
    public Localizable.Mutable asMutableLocalizable() {
        return null;
    }

    @Override
    public void setId(String id) {
        if (!this.getId().equals(id)) {
            this.setName(id);
        }
    }

    public void setModified(boolean value) {
        this.modified = value;
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public boolean isNotificationsEnabled() {
        return this.notify;
    }

    public void setNotificationsEnabled(boolean b) {
        this.notify = true;
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        return CollectionUtils.emptySequence();
    }

    @Override
    public boolean isActive() {
        return ProjectUtils.isActive(this);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setName(String name) {
        this.attribute.setName(name);
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void setDefault(boolean isDefault) {
    }

    @Override
    public Class getRawClass() {
        return DataObject.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    @Override
    public boolean isProjectDataObject() {
        return false;
    }

    public void update(String name, CatalogType type, boolean creation) {
        this.ignoreEvents = true;
        this.setName(name);
        this.setType(type);
        this.ignoreEvents = false;
        if (!creation) {
            this.fireChange("", null, this.nodeContainer);
        }
    }

    private void fireChange(String propertyName, Object value, NodeContainer nodeContainer) {
        ProjectEvent<ProjectObject> event = ProjectEvent.CHANGE(this, propertyName, null, value);
        ((FuegoProject)this.getProject()).fireObjectChanged(this, event);
        ((ProjectObjectContainerImpl)((Object)nodeContainer)).events().objectChanged();
    }

    public static class VarComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = ((InstanceVariable)o1).getName();
            String s2 = ((InstanceVariable)o2).getName();
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VarComparator;
        }

        public int hashCode() {
            return 0;
        }
    }
}

