/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Cast;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataDeclarationImpl
extends ProjectObjectContainerImpl
implements DataDeclaration {
    protected DataDeclarationImpl(Project project) {
        super(project);
    }

    public static Sequence<DataDeclaration> findDeclarationPath(DataDeclarationContainer rootDeclaration, String query) {
        String[] parts;
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        DataDeclarationContainer current = rootDeclaration;
        for (String part : parts = query.split("\\.")) {
            DataDeclaration next = current.findDeclaration(part);
            if (next == null) {
                throw new IllegalArgumentException("Invalid expression: '" + current.getId() + "' does not contain a member '" + part + '\'');
            }
            result.add(next);
            current = next;
        }
        return CollectionUtils.asSequence(result);
    }

    public static Sequence<DataDeclaration> getAllDeclarations(DataDeclarationContainer root) {
        HashSet<String> added = new HashSet<String>();
        ArrayList<DataDeclaration> list = new ArrayList<DataDeclaration>();
        while (root != null) {
            for (DataDeclaration dataDeclaration : root.getLocalDeclarations()) {
                if (!added.add(dataDeclaration.getName())) continue;
                list.add(dataDeclaration);
            }
            root = root.getParentScope();
        }
        return CollectionUtils.asSequence(list);
    }

    public static Sequence<DataDeclaration> getInnerDeclarations(DataDeclaration root) {
        Sequence<DataDeclaration> result;
        CatalogType type = root.getType();
        if (type instanceof DataDeclarationContainer) {
            DataDeclarationContainer container = (DataDeclarationContainer)((Object)type);
            result = container.getDeclarations();
        } else if (type.isArray()) {
            CatalogType elementType = type.getElementType();
            CatalogType catalogElement = CatalogObjectImpl.get(elementType.getDynamicRef());
            result = catalogElement.getChildrenByType(DataDeclaration.class);
        } else {
            result = type.getChildrenByType(DataDeclaration.class);
        }
        return result;
    }

    public static DataDeclaration findLocalDeclaration(DataDeclarationContainer root, String name) {
        return DataDeclarationImpl.findDeclaration(root.getLocalDeclarations(), name);
    }

    public static DataDeclaration findDeclaration(DataDeclarationContainer root, String name) {
        return DataDeclarationImpl.findDeclaration(root.getDeclarations(), name);
    }

    public static AccessType getAccessType(@NotNull DataDeclaration dataDeclaration) {
        AccessType result = dataDeclaration.isIn() && dataDeclaration.isOut() ? AccessType.IN_OUT : (dataDeclaration.isOut() ? AccessType.OUT : AccessType.IN);
        return result;
    }

    public static <T extends DataDeclaration> T findDeclaration(@NotNull DataDeclarationContainer container, @NotNull Class<T> type, @NotNull String name) {
        return DataDeclarationImpl.findDeclaration(DataDeclarationImpl.getDeclarations(container, type), name);
    }

    public static <T extends DataDeclaration> T findLocalDeclaration(@NotNull DataDeclarationContainer container, @NotNull Class<T> type, @NotNull String name) {
        return DataDeclarationImpl.findDeclaration(DataDeclarationImpl.getLocalDeclarations(container, type), name);
    }

    public static <T extends DataDeclaration> Sequence<T> getDeclarations(@NotNull DataDeclarationContainer container, @NotNull Class<T> type) {
        return DataDeclarationImpl.filterByType(container.getDeclarations(), type);
    }

    public static <T extends DataDeclaration> Sequence<T> getLocalDeclarations(@NotNull DataDeclarationContainer container, @NotNull Class<T> type) {
        return DataDeclarationImpl.filterByType(container.getLocalDeclarations(), type);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        return DataDeclarationImpl.getInnerDeclarations(this);
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(@NotNull Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(@NotNull Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        for (DataDeclaration declaration : this.getLocalDeclarations()) {
            this.removeDeclaration(declaration);
        }
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNativeName() {
        return this.getName();
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public DataDeclarationType getDeclarationType() {
        return DataDeclarationType.DATA_DECLARATION;
    }

    @Override
    public boolean isPredefinedDeclaration() {
        return false;
    }

    @Override
    public boolean isShadowed(@NotNull DataDeclarationContainer context) {
        for (DataDeclarationContainer root = context; !(root == null || root == this.getDeclarationContainer() || root.getId() != null && root.getId().equals(this.getDeclarationContainer().getId())); root = root.getParentScope()) {
            if (root.findLocalDeclaration(this.getName()) == null) continue;
            return true;
        }
        return false;
    }

    private static <T extends DataDeclaration> Sequence<T> filterByType(@NotNull Sequence<DataDeclaration> declarations, final @NotNull Class<T> type) {
        Sequence filteredDeclarations = declarations.select((Predicate)new Predicate<DataDeclaration>(){

            public boolean check(@Nullable DataDeclaration value) {
                return value != null && type.isAssignableFrom(value.getRawClass());
            }
        });
        return (Sequence)Cast.force((Object)filteredDeclarations);
    }

    private static <T extends DataDeclaration> T findDeclaration(Sequence<T> declarations, String name) {
        DataDeclaration result = null;
        for (DataDeclaration declaration : declarations) {
            if (!declaration.getName().equals(name)) continue;
            result = declaration;
            break;
        }
        return (T)result;
    }
}

