/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.HashMap;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationComposite
extends ProjectObjectImpl
implements DataDeclarationContainer {
    private List<DataDeclarationContainer> containers;

    public DataDeclarationComposite(@NotNull Project project, @NotNull List<DataDeclarationContainer> containers) {
        super(project);
        this.containers = containers;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return this.getLocalDeclarations();
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        HashMap<String, DataDeclaration> result = new HashMap<String, DataDeclaration>();
        for (DataDeclarationContainer container : this.containers) {
            for (DataDeclaration declaration : container.getDeclarations()) {
                if (result.containsKey(declaration.getName())) continue;
                result.put(declaration.getName(), declaration);
            }
        }
        return CollectionUtils.asSequence(result.values());
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String query) {
        return DataDeclarationImpl.findDeclarationPath(this, query);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        throw new UnsupportedOperationException();
    }
}

