/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.CorrelationKeyImpl;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationKeyContainerManager {
    @NotNull
    public static CorrelationKey createCorrelationKey(@NotNull CorrelationKeyContainer root, @NotNull String correlationKeyId) {
        return new CorrelationKeyImpl(root, correlationKeyId);
    }

    @NotNull
    public static Sequence<CorrelationKey> getCorrelationKeys(@NotNull CorrelationKeyContainer root) {
        return root.getChildrenByType(CorrelationKey.class);
    }

    @Nullable
    public static CorrelationKey findCorrelationKey(@NotNull CorrelationKeyContainer root, final @NotNull String correlationKeyId) {
        Sequence correlationKeySequence = root.getChildrenByType(CorrelationKey.class).select((Predicate)new Predicate<CorrelationKey>(){

            public boolean check(@Nullable CorrelationKey correlationKey) {
                return correlationKey != null && correlationKey.getName().equals(correlationKeyId);
            }
        });
        return !correlationKeySequence.isEmpty() ? (CorrelationKey)correlationKeySequence.iterator().next() : null;
    }

    public static void addCorrelationKey(@NotNull CorrelationKeyContainer root, @NotNull CorrelationKey correlationKey) throws ProjectException {
        root.addChild(correlationKey);
    }

    public static void removeCorrelationKey(@NotNull CorrelationKeyContainer root, @NotNull CorrelationKey correlationKey) throws ProjectException {
        root.removeChild(correlationKey);
    }

    public static void removeCorrelationKey(@NotNull CorrelationKeyContainer root, @NotNull String correlationKeyId) throws ProjectException {
        CorrelationKey correlationKey = CorrelationKeyContainerManager.findCorrelationKeyById(root, correlationKeyId);
        if (correlationKey != null) {
            root.removeChild(correlationKey);
        }
    }

    @NotNull
    public static Sequence<CorrelationKey> getScopedCorrelationKeys(@NotNull CorrelationKeyContainer root) {
        HashSet<String> added = new HashSet<String>();
        ArrayList<CorrelationKey> list = new ArrayList<CorrelationKey>();
        for (ProjectObject parent = root; parent != null; parent = parent.getParentObject()) {
            if (!CorrelationKeyContainer.class.isAssignableFrom(parent.getRawClass())) continue;
            CorrelationKeyContainer keyContainer = parent;
            for (CorrelationKey correlationKey : keyContainer.getCorrelationKeys()) {
                if (!added.add(correlationKey.getName())) continue;
                list.add(correlationKey);
            }
        }
        return CollectionUtils.asSequence(list);
    }

    public static CorrelationKey findInScopedCorrelationKeys(@NotNull CorrelationKeyContainer root, final @NotNull String correlationKeyId) {
        Sequence sequence = root.getScopedCorrelationKeys().select((Predicate)new Predicate<CorrelationKey>(){

            public boolean check(@Nullable CorrelationKey value) {
                return value != null && value.getId().equals(correlationKeyId);
            }
        });
        return !sequence.isEmpty() ? (CorrelationKey)CollectionUtils.first((Iterable)sequence) : null;
    }

    @Nullable
    private static CorrelationKey findCorrelationKeyById(@NotNull CorrelationKeyContainer root, @NotNull String correlationKeyId) {
        CorrelationKey key = null;
        for (CorrelationKey correlationKey : root.getChildrenByType(CorrelationKey.class)) {
            if (!correlationKey.getId().equalsIgnoreCase(correlationKeyId)) continue;
            key = correlationKey;
            break;
        }
        return key;
    }
}

