/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.SortedSet;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CatalogServiceUtil {
    private CatalogServiceUtil() {
    }

    @NotNull
    public static CatalogObject findByTarget(@NotNull String target, @NotNull Project project) {
        if (target == null) {
            throw new IllegalArgumentException("Service Name can not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        final MutableComponentCatalog catalog = (MutableComponentCatalog)project.getComponentCatalog();
        ProjectFileSystem projectFileSystem = project.getLoader().getProjectFileSystem();
        projectFileSystem.getDataFileSystem().runWithEventsDelayed(new Runnable(){

            @Override
            public void run() {
                catalog.sync();
            }
        });
        TypeRef typeRef = CatalogServiceUtil.findTypeRefByTarget(target, project);
        if (typeRef == null) {
            throw new IllegalStateException("Service '" + target + "' could not be found.");
        }
        try {
            return project.findCatalogObject(typeRef.getText());
        }
        catch (AmbiguousTypeNameException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static CatalogObject getCatalogObjectCallback(@NotNull CatalogObject catalogObject) {
        TypeDescription delegatedType;
        ServiceObject serviceObject;
        CatalogObject result = null;
        if (catalogObject.isService() && !(serviceObject = (delegatedType = catalogObject.getDelegate()).asServiceObject()).isSynchronous()) {
            ObjectTypeDescription callback = delegatedType.asObject().getInnerType(0);
            result = CatalogObjectImpl.create(catalogObject.getProject(), (TypeRef)callback);
        }
        return result;
    }

    @Nullable
    private static TypeRef findTypeRefByTarget(@NotNull String target, @NotNull Project project) {
        ComponentCatalog catalog = project.getComponentCatalog();
        SortedSet typeNames = catalog.findByPropertyValue("target", target);
        if (typeNames.isEmpty()) {
            typeNames = catalog.findByPropertyValue("target", target);
        }
        TypeRef result = null;
        try {
            for (String typeName : typeNames) {
                TypeRef typeRef = catalog.find(typeName);
                ObjectTypeDescription typeDesc = typeRef.get().asObject();
                if (Boolean.valueOf(typeDesc.getProperty("is.callback")).booleanValue()) continue;
                result = typeRef;
                break;
            }
        }
        catch (AmbiguousTypeNameException e) {
            // empty catch block
        }
        return result;
    }
}

