/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.bpmobject.design.ConstructionException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.log.Log;
import oracle.bpm.project.BusinessRuleImpl;
import oracle.bpm.project.CatalogMemberImpl;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.HumanTaskImpl;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.SOASchemaInfo;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DefaultCatalogObject;
import oracle.bpm.project.model.catalog.ExternalRef;
import oracle.bpm.project.model.catalog.FaultObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.catalog.SystemFaultObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeObserver;
import oracle.bpm.type.TypeObserverImpl;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.CatalogListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogObjectImpl
extends CatalogTypeImpl
implements CatalogObject.Mutable,
ResourceObject {
    protected boolean fromDefaultCatalog;
    protected boolean membersUpdatedFromCatalog;
    private boolean addedFromCatalog;
    private String componentType;
    private Boolean delegateReadOnly;
    private boolean dirty;
    private final boolean hidden;
    private boolean ignoreDirty;
    private final Map<MethodTypeDescription, CatalogMember> memberCache = new HashMap<MethodTypeDescription, CatalogMember>();
    private final String name;
    private Path path;
    private Project project;
    private boolean removedFromCatalog;
    private String text;
    private final TypeObserverImpl typeObserver;
    private static final String PUNIT_PARTICIPANT = "punit";
    private static final String DIRTY = "dirty";
    private static final Comparator<ProjectObject> DEFAULT_COMPARATOR = new DefaultComparator();

    protected CatalogObjectImpl(Project project, TypeRef delegate) {
        super(project, delegate);
        this.text = delegate.getText();
        this.name = delegate.getName();
        this.hidden = delegate.get().isHidden();
        this.project = project;
        this.fromDefaultCatalog = TypeUtils.belongsToDefaultCatalog((TypeRef)delegate);
        this.typeObserver = new TypeObserverImpl(){

            public void typeChanged(TypeRef thisType) {
                if (!TypeUtils.belongsToDefaultCatalog((TypeRef)thisType)) {
                    CatalogObjectImpl.this.events().objectChanged();
                }
            }

            public void typeMemberAdded(TypeRef ref) {
                try {
                    CatalogObjectImpl.this.ensureMemberIsAdded(ref.get().asMethod());
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }

            public void typeMemberRemoved(TypeRef ref) {
                MethodTypeDescription member = ref.get().asMethod();
                CatalogObjectImpl.this.ensureMemberIsRemoved(member);
            }
        };
        delegate.addObserver((TypeObserver)this.typeObserver);
        TypeRef ref = this.getDelegate().get().getParentRef();
        Project parent = ref == null ? project : CatalogObjectImpl.create(project, ref);
        this.setParentObject(parent);
        this.addAdapter(delegate);
        this.addListener(new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

            @Override
            public void processPostEvents(ProjectEventSet events) {
                if (!CatalogObjectImpl.this.ignoreDirty) {
                    CatalogObjectImpl.this.dirty = true;
                }
            }
        });
        this.componentType = delegate.getComponentType();
    }

    public static CatalogObject create(TypeRef typeRef) {
        FuegoProject project = FuegoProject.getFrom(typeRef);
        if (project == null && typeRef.getCatalog() == null) {
            throw new IllegalArgumentException("ObjectType without a catalog: " + typeRef);
        }
        return CatalogObjectImpl.create(project, typeRef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CatalogObject create(@Nullable Project project, @NotNull TypeRef typeRef) {
        assert (!typeRef.get().isMethod()) : "Trying to create catalog object from a method: " + typeRef.get();
        if (project != null) return ((FuegoProject)project).createCatalogObjectInternal(typeRef);
        if (!TypeUtils.belongsToDefaultCatalog((TypeRef)typeRef)) throw new IllegalArgumentException("Project should not be null for type: " + typeRef);
        return ((FuegoProject)RepositoryService.getInstance().getActiveRepository().getDefaultProject()).createCatalogObjectInternal(typeRef);
    }

    @Override
    public void dispose() {
        this.delegate.removeObserver((TypeObserver)this.typeObserver);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatalogObjectImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogObjectImpl that = (CatalogObjectImpl)o;
        if (this.addedFromCatalog != that.addedFromCatalog) {
            return false;
        }
        if (this.membersUpdatedFromCatalog != that.membersUpdatedFromCatalog) {
            return false;
        }
        if (this.removedFromCatalog != that.removedFromCatalog) {
            return false;
        }
        return this.text.equals(that.text);
    }

    public int hashCode() {
        int result = this.membersUpdatedFromCatalog ? 1 : 0;
        result = 31 * result + (this.addedFromCatalog ? 1 : 0);
        result = 31 * result + (this.removedFromCatalog ? 1 : 0);
        result = 31 * result + this.text.hashCode();
        return result;
    }

    @Override
    public boolean isDeletable() {
        return !this.isReadOnly();
    }

    @Override
    public Comparator<ProjectObject> getChildComparator() {
        return DEFAULT_COMPARATOR;
    }

    public boolean isAddedFromCatalog() {
        return this.addedFromCatalog;
    }

    public boolean isRemovedFromCatalog() {
        return this.removedFromCatalog;
    }

    @Override
    public void beginTransaction() {
        CatalogObjectImpl root = this.getCatalogRoot();
        if (this != root) {
            root.beginTransaction();
        } else {
            super.beginTransaction();
        }
    }

    @Override
    public void endTransaction() {
        CatalogObjectImpl root = this.getCatalogRoot();
        if (this != root) {
            root.endTransaction();
        } else {
            super.endTransaction();
        }
    }

    @Override
    public void abortTransaction() {
        CatalogObjectImpl root = this.getCatalogRoot();
        if (this != root) {
            root.abortTransaction();
        } else {
            super.abortTransaction();
        }
    }

    @Override
    public boolean isSynthesized() {
        return this.getDelegate().isSynthesized();
    }

    @Override
    public boolean isReadOnly() {
        if (this.delegateReadOnly == null) {
            try {
                TypeDescription typeDescription = this.getDelegate().get();
                boolean ret = false;
                if (typeDescription.isObject()) {
                    ObjectTypeDescription objectTypeDescription = typeDescription.asObject();
                    String isReadOnly = objectTypeDescription.getProperty("isReadOnly");
                    ret = Boolean.valueOf(isReadOnly);
                }
                this.delegateReadOnly = ret || typeDescription.isSynthesized();
            }
            catch (Exception unexpected) {
                this.delegateReadOnly = false;
            }
        }
        return this.delegateReadOnly;
    }

    @Override
    @NotNull
    public CatalogObject.Mutable asMutable() {
        return this;
    }

    @Override
    public <T extends CatalogObject> T asChild(Class<T> clazz) {
        return (T)((CatalogObject)clazz.cast(this));
    }

    @Override
    public BpmObject asBpmObject() {
        return (BpmObject)((Object)this);
    }

    @Override
    public HumanTask asHumanTask() {
        return (HumanTask)((Object)this);
    }

    @Override
    public CatalogModule asModule() {
        return (CatalogModule)((Object)this);
    }

    @Override
    public BusinessRule asBusinessRule() {
        return (BusinessRule)((Object)this);
    }

    @Override
    public ServiceObject asServiceObject() {
        return (ServiceObject)((Object)this);
    }

    @Override
    public InterfaceObject asInterfaceObject() {
        return (InterfaceObject)((Object)this);
    }

    public CatalogModule newModule(String name) throws ProjectException {
        CatalogObject child = this.findChild(CatalogObject.class, name);
        if (child == null) {
            ObjectTypeDescription newModule = new ObjectTypeDescription(name);
            newModule.setParent((TypeRef)this.getDelegate());
            newModule.setCatalog(this.getDelegate().getCatalog());
            child = CatalogObjectImpl.create(this.project, (TypeRef)newModule);
            assert (child.getParentObject() == this);
        }
        return child.asModule();
    }

    public BpmObject newExceptionFromSchema(String name, CatalogObject schema) throws ProjectException {
        BpmObject exception = this.newBpmObjectFromSchema(name, schema);
        exception.getObjectType().addModifier(262144L);
        return exception.asBpmObject();
    }

    public BpmObject newBpmObject(String name) throws ProjectException {
        return this.newBpmObject(name, false);
    }

    public BpmObject newBpmObjectFromExternalSchema(String name, SOASchemaInfo soaSchemaInfo) {
        XmlUUID xmlUUID = UUIDFactory.createXmlId((XmlElementType)soaSchemaInfo.getXmlElementType(), (String)soaSchemaInfo.getqName().getNamespaceURI(), (String)soaSchemaInfo.getqName().getLocalPart());
        ComponentCatalog catalog = this.project.getComponentCatalog();
        XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr((String)name, (ComponentCatalog)catalog, (XmlUUID)xmlUUID);
        bpmObject.setParent((TypeRef)this.getDelegate());
        bpmObject.setCatalog(catalog);
        if (catalog.findById(ComponentType.XML.getText(), xmlUUID.getId()) == null) {
            bpmObject.setTransientProperty("external.schema.url", (Object)soaSchemaInfo.getLocation());
        }
        bpmObject.setTransientProperty("wsdl.inline.object", (Object)soaSchemaInfo.isWsdl());
        return CatalogObjectImpl.create(this.project, (TypeRef)bpmObject).asBpmObject();
    }

    public BpmObject newBpmObjectFromSchema(String name, CatalogObject schema) throws ProjectException {
        XmlTypeDescription external = (XmlTypeDescription)schema.getObjectType();
        ComponentCatalog catalog = schema.getProject().getComponentCatalog();
        XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr((String)name, (ComponentCatalog)catalog, (XmlTypeDescription)external);
        bpmObject.setParent((TypeRef)this.getDelegate());
        bpmObject.setCatalog(catalog);
        return CatalogObjectImpl.create(this.project, (TypeRef)bpmObject).asBpmObject();
    }

    public BpmObject newException(String name) throws ProjectException {
        BpmObject exception = this.newBpmObject(name, true);
        return exception.asBpmObject();
    }

    @Override
    public CatalogMember findMember(String name) {
        MethodTypeDescription method = this.getObjectType().findMember(name);
        return this.asCatalogMember(method);
    }

    @Override
    public Sequence<CatalogMember> getAttributes() {
        ArrayList<CatalogMember> result = new ArrayList<CatalogMember>();
        for (CatalogMember member : this.getChildrenByType(CatalogMember.class)) {
            if (!member.isAttribute()) continue;
            result.add(member);
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public Sequence<CatalogMember> getMethods() {
        ArrayList<CatalogMember> result = new ArrayList<CatalogMember>();
        for (CatalogMember member : this.getChildrenByType(CatalogMember.class)) {
            if (!member.isMethod()) continue;
            result.add(member);
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public Sequence<CatalogObject> getInnerTypes() {
        ArrayList<CatalogObject> result = new ArrayList<CatalogObject>();
        for (CatalogObject object : this.getChildrenByType(CatalogObject.class)) {
            result.add(object);
        }
        return CollectionUtils.asSequence(result);
    }

    public CatalogMember createAttribute(String name, CatalogType type) throws ProjectException {
        try {
            AttributeTypeDescription attribute = BpmObjectTypeDescriptionHelper.createAttribute((String)name, (TypeRef)type.getDynamicRef());
            return this.asCatalogMember((MethodTypeDescription)attribute);
        }
        catch (ConstructionException e) {
            throw new ProjectException(this, e.getKey(), e);
        }
    }

    public void addAttribute(CatalogMember attribute) throws ProjectException {
        try {
            if (!this.membersUpdatedFromCatalog) {
                BpmObjectTypeDescriptionHelper.addAttribute((XObjectTypeDescription)this.getObjectType().asBpmObject(), (AttributeTypeDescription)attribute.getDelegate().asAttribute());
            }
        }
        catch (ConstructionException e) {
            throw new ProjectException(this, e.getKey(), e);
        }
    }

    public CatalogMember newMethod(String name, CatalogType type) throws ProjectException {
        try {
            MethodTypeDescription method = BpmObjectTypeDescriptionHelper.addMethod((ObjectTypeDescription)this.getObjectType(), (String)name, (TypeDescription)type.getDelegate(), (Argument[])null);
            return this.ensureMemberIsAdded(method);
        }
        catch (ConstructionException e) {
            throw new ProjectException(this, e.getKey(), e);
        }
    }

    @Override
    public CatalogObject findInnerType(String name) {
        return this.findChild(CatalogObject.class, name);
    }

    @Override
    public String getId() {
        return this.delegate.getText();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.BPM_OBJECT;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.create(this.getParentObject().getPath(), this.getName());
        }
        return this.path;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isPredefined() {
        return this.getDelegate().isPredefined();
    }

    @Override
    public boolean isException() {
        return Modifier.isException((long)this.getDelegate().getModifiers());
    }

    @Override
    public boolean isNumber() {
        return this.getDelegate().isNumber();
    }

    @Override
    public boolean equivalent(CatalogType type) {
        return this.getDelegate().equivalent(type.getDelegate());
    }

    public void refresh() {
        this.delegate = this.getDelegate().getCatalog().reload((TypeRef)this.getDelegate());
    }

    @Override
    public <T> T as(Class<T> targetType) {
        T result;
        if (targetType.equals(VFile.class)) {
            VFile[] files = (VFile[])this.getObjectType().getTransientProperty("files");
            result = files != null ? targetType.cast(files[0]) : super.as(targetType);
        } else if (targetType.isAssignableFrom(this.getObjectType().getClass())) {
            result = targetType.cast(this.getObjectType());
        } else if (targetType.isAssignableFrom(URL.class)) {
            URL url = null;
            VFile[] files = (VFile[])this.getObjectType().getTransientProperty("files");
            if (files != null && files[0].getFileSystem() instanceof JavaFileSystem) {
                try {
                    JavaFileSystem fs = (JavaFileSystem)files[0].getFileSystem();
                    File file = fs.toJavaFile(files[0]);
                    Object transientProperty = this.getObjectType().getTransientProperty("node.url.suffix");
                    String suffix = transientProperty != null ? transientProperty.toString() : "";
                    String path = file.getPath().replace("\\", "/") + suffix;
                    if (path.charAt(0) != '/') {
                        path = "/" + path;
                    }
                    url = new URL("file", "", path);
                }
                catch (MalformedURLException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            result = targetType.cast(url);
        } else {
            result = super.as(targetType);
        }
        return result;
    }

    public String toString() {
        return "CatalogObjectImpl(" + this.getText() + ")";
    }

    @Override
    public ObjectTypeDescription getObjectType() {
        return this.getDelegate().get().asObject();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isHumanTask() {
        return false;
    }

    @Override
    public boolean isBusinessRule() {
        return false;
    }

    @Override
    public boolean isBpmObject() {
        return false;
    }

    @Override
    public boolean isService() {
        return TypeUtils.isService((TypeRef)this.getDelegate());
    }

    @Override
    public boolean isSpringService() {
        return TypeUtils.isSpringService((TypeRef)this.getDelegate());
    }

    @Override
    public boolean isModule() {
        return this.getDelegate().get().isModule();
    }

    @Override
    public boolean isRootModule() {
        return this.isModule() && this.getDelegate().getParentRef() == null;
    }

    @Override
    public boolean isInnerType() {
        return this.getDelegate().isInnerType();
    }

    public boolean isExternal() {
        return this.getDelegate().getText().equals("Ext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        try {
            this.beginTransaction();
            assert (child.getParentObject() == this);
            if (child instanceof CatalogMember) {
                CatalogMember member = (CatalogMember)child;
                if (member.isAttribute()) {
                    this.addAttribute(member);
                }
                this.ensureMemberIsAdded(member.getMemberType());
            } else {
                super.addChild(child);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void addChild(ProjectObject child, int position) throws ProjectException {
        CatalogMember member;
        if (child instanceof CatalogMember && (member = (CatalogMember)child).isAttribute()) {
            this.addAttribute(member);
        }
        super.addChild(child, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(ProjectObject object) throws ProjectException {
        block8: {
            assert (object.getParentObject() == this);
            try {
                this.beginTransaction();
                if (object instanceof CatalogMember) {
                    CatalogMember member = (CatalogMember)object;
                    try {
                        if (!this.membersUpdatedFromCatalog) {
                            BpmObjectTypeDescriptionHelper.removeMember((ObjectTypeDescription)this.getObjectType(), (String)member.getName());
                        }
                        this.ensureMemberIsRemoved(member.getDelegate().asMethod());
                        break block8;
                    }
                    catch (ConstructionException e) {
                        throw ProjectException.wrap((ProjectObject)this, e);
                    }
                }
                super.removeChild(object);
            }
            finally {
                this.endTransaction();
            }
        }
    }

    public void childUpdatedFromCatalog(TypeRef updatedType) throws ProjectException {
        CatalogObjectImpl child = (CatalogObjectImpl)this.findChild(CatalogObject.class, updatedType.getText());
        if (child == null) {
            child = (CatalogObjectImpl)CatalogObjectImpl.create(this.project, updatedType);
            super.addChild(child);
        } else {
            child.updateDelegate(updatedType);
            child.events().objectChanged();
        }
    }

    public void childAddedFromCatalog(TypeRef updatedType) throws ProjectException {
        CatalogObjectImpl child = (CatalogObjectImpl)this.findChild(CatalogObject.class, updatedType.getText());
        if (child == null) {
            child = (CatalogObjectImpl)CatalogObjectImpl.create(this.project, updatedType);
            child.addedFromCatalog = true;
            super.addChild(child);
        } else {
            child.updateDelegate(updatedType);
        }
    }

    public void childRemovedFromCatalog(String name) throws ProjectException {
        CatalogObjectImpl child = (CatalogObjectImpl)this.findChild(CatalogObject.class, name);
        if (child != null) {
            child.removedFromCatalog = true;
            super.removeChild(child);
        }
    }

    @Override
    public Class getRawClass() {
        return CatalogObjectImpl.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String query) {
        return DataDeclarationImpl.findDeclarationPath(this, query);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createAttribute(name, type);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.createDeclaration(name, type);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof CatalogMember) : "DataDeclaration must be a CatalogMember";
        this.addAttribute((CatalogMember)dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        dataDeclaration.delete();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        for (DataDeclaration declaration : this.getLocalDeclarations()) {
            this.removeDeclaration(declaration);
        }
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        ArrayList<CatalogMember> result = new ArrayList<CatalogMember>();
        if (!TypeUtils.isEnumType((TypeDescription)this.getDelegate())) {
            for (CatalogMember member : this.getChildrenByType(CatalogMember.class)) {
                if (!member.isAttribute() || !member.isIn()) continue;
                result.add(member);
            }
        }
        return (Sequence)Cast.force((Object)CollectionUtils.asSequence(result));
    }

    @Override
    public boolean isMutable() {
        return !this.isFromExternalSchema() && !this.isSynthesized() && !this.isReadOnly();
    }

    public boolean isFromExternalSchema() {
        return this.getDelegate().isSchemaObject() && !this.getDelegate().asSchemaObject().isBpmObjectNamespace();
    }

    public boolean isFromWsdl() {
        return this.getDelegate().isSchemaObject() && this.getDelegate().asSchemaObject().isFromWsdl();
    }

    public boolean canAddMethods() {
        return !this.isException() && !this.isSynthesized();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            try {
                this.ignoreDirty = true;
                this.events().objectChanged(DIRTY, !dirty, dirty);
            }
            finally {
                this.ignoreDirty = false;
            }
        }
    }

    @Override
    public ProjectObject copy() {
        return ResourceObjectImpl.copy(this);
    }

    public String getComponentType() {
        if (this.componentType == null) {
            this.componentType = this.getDelegate().getComponentType();
        }
        return this.componentType;
    }

    public boolean isAssociatedToResource() {
        String componentType = this.getComponentType();
        return ComponentType.XOBJECT.getText().equals(componentType) || ComponentType.OBJECT.getText().equals(componentType);
    }

    @Override
    protected void updateDelegate(TypeRef updatedType) {
        super.updateDelegate(updatedType);
        this.memberCache.clear();
        this.text = this.delegate.getText();
        this.fromDefaultCatalog = TypeUtils.belongsToDefaultCatalog((TypeRef)this.delegate);
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        MethodTypeDescription[] members;
        ProjectObjectList<ProjectObject> result = new ProjectObjectList<ProjectObject>();
        ArrayList refs = new ArrayList(this.getObjectType().getInnerTypeRefs());
        for (TypeRef ref : refs) {
            CatalogObject child = CatalogObjectImpl.create(this.project, ref);
            result.add(child);
        }
        MethodTypeDescription[] arr$ = members = this.getObjectType().asObject().getMembers(14);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (MethodTypeDescription member = arr$[i$]; member != null; member = member.getNextMethod()) {
                if (member.isHidden()) continue;
                result.add(this.asCatalogMember(member));
            }
        }
        ObjectTypeDescription otd = this.getObjectType();
        if (otd.isBpmObject()) {
            for (MethodTypeDescription member : BpmObjectTypeDescriptionHelper.getAttributes((ObjectTypeDescription)otd)) {
                if (member.isHidden()) continue;
                result.add(this.asCatalogMember(member));
            }
        } else {
            MethodTypeDescription[] attributes;
            long excluded = 0x2000000L;
            for (MethodTypeDescription attr : attributes = this.getObjectType().asObject().getMembers(18, 0L, excluded, TypeFinder.Scope.ALL, true)) {
                result.add(this.asCatalogMember(attr));
            }
        }
        return result;
    }

    protected boolean isValid() {
        TypeDescription delegate = this.getDelegate();
        return !delegate.isBpmObject() || BpmObjectTypeDescriptionHelper.hasAttributesObject((XObjectTypeDescription)delegate.asBpmObject());
    }

    protected CatalogMember ensureMemberIsAdded(MethodTypeDescription member) throws ProjectException {
        CatalogMember catalogMember = this.asCatalogMember(member);
        if (this.findChild(CatalogMember.class, member.getName()) == null) {
            super.addChild(catalogMember);
        }
        return catalogMember;
    }

    static CatalogObjectImpl newInstance(TypeRef typeRef, Project project) {
        CatalogObjectImpl result;
        if (typeRef.isFromCatalog((ComponentCatalog)TypeUtils.getDefaultCatalog())) {
            result = new DefaultImpl(project, typeRef);
        } else {
            TypeDescription td = typeRef.get();
            String componentType = typeRef instanceof DynamicRef ? td.getComponentType() : typeRef.getComponentType();
            if (componentType.equals(ComponentType.EVENT_DEFINITION.getText())) {
                result = new SignalObjectImpl(project, typeRef);
            } else if (componentType.equals(ComponentType.XOBJECT.getText())) {
                String interfaceObject = td.asObject().getProperty("interface.object");
                boolean serviceObject = "service.object".equals(interfaceObject);
                boolean referenceObject = "reference.object".equals(interfaceObject);
                String callbackProperty = td.asObject().getProperty("is.callback");
                boolean isCallback = !Str.isEmpty((String)callbackProperty) && callbackProperty.equals(Boolean.TRUE.toString());
                boolean isSync = td.asServiceObject().isSynchronous();
                result = serviceObject ? new ServiceObjectImpl(project, typeRef, isSync, isCallback) : (Modifier.isException((long)td.getModifiers()) ? new FaultObjectImpl(project, typeRef) : (referenceObject ? new ReferenceObjectImpl(project, typeRef, isSync, isCallback) : new BpmObjectImpl(project, typeRef)));
            } else {
                result = componentType.equals(ComponentType.BUSINESS_RULE.getText()) ? new BusinessRuleImpl(project, typeRef) : (componentType.equals(ComponentType.SYSTEM_FAULTS.getText()) ? new SystemFaultObjectImpl(project, typeRef) : (componentType.equals(ComponentType.HUMAN_TASK.getText()) ? new HumanTaskImpl(project, typeRef) : (typeRef.getText().equals("Ext") ? new ExternalRefImpl(project, typeRef) : (td.isModule() ? new CatalogModuleImpl(project, typeRef) : (componentType.equals(ComponentType.CORRUPTED_RESOURCE.getText()) ? new CorruptedResourceImpl(project, typeRef) : new CatalogObjectImpl(project, typeRef))))));
            }
        }
        return result;
    }

    CatalogObjectImpl getCatalogRoot() {
        return this.project == null ? null : (CatalogObjectImpl)((Object)this.project.getCatalogRoot());
    }

    private BpmObject newBpmObject(String name, boolean isException) throws ProjectException {
        ComponentCatalog catalog = this.getDelegate().getCatalog();
        XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescription((String)name, (String)this.getDelegate().getText(), (ComponentCatalog)catalog);
        bpmObject.setParent((TypeRef)this.getDelegate());
        bpmObject.setCatalog(catalog);
        if (isException) {
            bpmObject.addModifier(262144L);
        }
        return CatalogObjectImpl.create(this.project, (TypeRef)bpmObject).asBpmObject();
    }

    private void ensureMemberIsRemoved(MethodTypeDescription member) {
        this.memberCache.remove(member);
        Sequence<CatalogMember> members = this.getChildrenByType(CatalogMember.class);
        for (CatalogMember child : members) {
            if (!child.getDelegate().getText().equals(member.getText())) continue;
            try {
                ((CatalogMemberImpl)child).dispose();
                super.removeChild(child);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private CatalogMember asCatalogMember(MethodTypeDescription member) {
        CatalogMember catalogMember = null;
        if (member != null && (catalogMember = this.memberCache.get(member)) == null) {
            catalogMember = new CatalogMemberImpl(this, member);
            this.memberCache.put(member, catalogMember);
        }
        return catalogMember;
    }

    private MethodTypeDescription createSetUp() {
        MethodTypeDescription method = new MethodTypeDescription("setUp");
        String code = "session = createSession(\"punit\")";
        method.setCode(code, "Fuego");
        return method;
    }

    private MethodTypeDescription createTearDown() {
        MethodTypeDescription method = new MethodTypeDescription("tearDown");
        String code = "close session";
        method.setCode(code, "Fuego");
        return method;
    }

    static class ExternalRefImpl
    extends CatalogObjectImpl
    implements ExternalRef {
        private ExternalRefImpl(Project project, TypeRef model) {
            super(project, model);
            this.setDefault(false);
        }

        @Override
        public Class getRawClass() {
            return ExternalRef.class;
        }
    }

    static class DefaultComparator
    implements Comparator<ProjectObject> {
        DefaultComparator() {
        }

        @Override
        public int compare(ProjectObject catalogObject1, ProjectObject catalogObject2) {
            return catalogObject1.getName().compareTo(catalogObject2.getName());
        }
    }

    public static class SystemFaultObjectImpl
    extends CatalogObjectImpl
    implements SystemFaultObject {
        private final boolean catcheable;
        private final QName errorCode;
        private final QName messageQName;
        private final boolean throwable;

        protected SystemFaultObjectImpl(Project project, TypeRef delegate) {
            super(project, delegate);
            ObjectTypeDescription otd = delegate.get().asObject();
            this.catcheable = Boolean.parseBoolean(otd.getProperty("catcheable"));
            this.throwable = Boolean.parseBoolean(otd.getProperty("throwable"));
            this.errorCode = QName.valueOf(otd.getId());
            String qNameString = otd.getProperty("fault.message.qname");
            this.messageQName = qNameString != null ? QName.valueOf(qNameString) : null;
        }

        @Override
        @NotNull
        public QName getErrorCode() {
            return this.errorCode;
        }

        @Override
        @Nullable
        public QName getMessageQName() {
            return this.messageQName;
        }

        @Override
        @NotNull
        public Map<String, CatalogType> getErrorInfoAttributes() {
            HashMap<String, CatalogType> result = new HashMap<String, CatalogType>();
            for (CatalogMember member : this.getAttributes()) {
                result.put(member.getName(), member.getResultType());
            }
            return result;
        }

        @Override
        public Class getRawClass() {
            return SystemFaultObject.class;
        }

        @Override
        public boolean isErrorDefinedExternally() {
            return true;
        }

        @Override
        public boolean isCatcheable() {
            return this.catcheable;
        }

        @Override
        public boolean isThrowable() {
            return this.throwable;
        }
    }

    public static class SignalObjectImpl
    extends CatalogObjectImpl
    implements SignalObject {
        protected SignalObjectImpl(Project project, TypeRef delegate) {
            super(project, delegate);
        }

        @Override
        public Class getRawClass() {
            return SignalObject.class;
        }

        @Override
        public URI getEdlResourceLocation() {
            String transientProperty = null;
            TypeDescription delegate = this.getDelegate();
            if (delegate != null && delegate.isObject() && (transientProperty = (String)delegate.asObject().getTransientProperty("resource_location")) == null) {
                throw new IllegalStateException("Transient property 'resource_location' is null");
            }
            return URI.create(transientProperty);
        }

        @Override
        public QName getContentQName() {
            TypeDescription signalType;
            AttributeTypeDescription payload;
            TypeDescription delegate = this.getDelegate();
            if (delegate != null && (payload = delegate.findAttribute("payload")) != null && (signalType = payload.getType()) != null) {
                SchemaObject schemaObject = signalType.asSchemaObject();
                return new QName(schemaObject.getNamespace(), schemaObject.getName());
            }
            return null;
        }

        @Override
        public QName getEventQName() {
            TypeDescription td = this.getDelegate();
            if (td != null) {
                ObjectTypeDescription otd = td.asObject();
                String namespace = otd.getProperty("namespace");
                String nativeName = otd.getNativeName();
                return new QName(namespace, nativeName);
            }
            return null;
        }

        @Override
        public CatalogType getEventPayloadType() {
            CatalogMember member = this.findMember("payload");
            CatalogType result = null;
            if (member != null) {
                assert (member.isAttribute());
                result = member.getType();
            }
            return result;
        }
    }

    public static class ServiceObjectImpl
    extends InterfaceObjectImpl
    implements ServiceObject {
        private ServiceObjectImpl(Project project, TypeRef model, boolean isSync, boolean isCallback) {
            super(project, model, isSync, isCallback);
        }

        @Override
        public Class getRawClass() {
            return ServiceObject.class;
        }
    }

    public static class ReferenceObjectImpl
    extends InterfaceObjectImpl
    implements ReferenceObject {
        private ReferenceObjectImpl(Project project, TypeRef model, boolean isSync, boolean isCallback) {
            super(project, model, isSync, isCallback);
        }

        @Override
        public Class getRawClass() {
            return ReferenceObject.class;
        }
    }

    public static class InterfaceObjectImpl
    extends CatalogObjectImpl
    implements InterfaceObject {
        private final boolean isCallback;
        private final boolean isSync;

        private InterfaceObjectImpl(Project project, TypeRef model, boolean isSync, boolean isCallback) {
            super(project, model);
            this.isSync = isSync;
            this.isCallback = isCallback;
        }

        @Override
        public Class getRawClass() {
            return InterfaceObject.class;
        }

        @Override
        public boolean isSync() {
            return this.isSync;
        }

        @Override
        public boolean isCallback() {
            return this.isCallback;
        }

        @Override
        public String getName() {
            ProjectObject parent;
            String result = super.getName();
            if (this.isCallback() && (parent = this.getParentObject()) != null && parent instanceof CatalogObject) {
                CatalogObject catalogParent = (CatalogObject)parent;
                result = catalogParent.getName() + "." + result;
            }
            return result;
        }
    }

    public static class FaultObjectImpl
    extends BpmObjectImpl
    implements FaultObject {
        private FaultObjectImpl(Project project, TypeRef model) {
            super(project, model);
        }

        @Override
        public Class getRawClass() {
            return FaultObject.class;
        }

        @Override
        public boolean isFaultObject() {
            return true;
        }

        @Override
        @NotNull
        public QName getErrorCode() {
            TypeDescription td = this.getDelegate();
            if (td != null) {
                SchemaObject so = td.asSchemaObject();
                return new QName(so.getNamespace(), so.getName());
            }
            return new QName("");
        }

        @Override
        public QName getMessageQName() {
            TypeDescription td = this.getDelegate();
            QName result = null;
            if (td != null && td.isBpmObject()) {
                result = BpmObjectTypeDescriptionHelper.getMessageQName((ObjectTypeDescription)td.asBpmObject());
            }
            return result;
        }

        @Override
        @NotNull
        public Map<String, CatalogType> getErrorInfoAttributes() {
            HashMap<String, CatalogType> result = new HashMap<String, CatalogType>();
            for (CatalogMember member : this.getAttributes()) {
                result.put(member.getName(), member.getResultType());
            }
            return result;
        }

        @Override
        public boolean isErrorDefinedExternally() {
            return this.getMessageQName() != null && this.getDelegate().asSchemaObject().getXmlElementType() == XmlElementType.FAULT;
        }
    }

    public static class DefaultImpl
    extends CatalogObjectImpl
    implements DefaultCatalogObject {
        private DefaultImpl(Project project, TypeRef model) {
            super(project, model);
        }

        @Override
        public Class getRawClass() {
            return DefaultCatalogObject.class;
        }
    }

    public static class CorruptedResourceImpl
    extends CatalogObjectImpl {
        private CorruptedResourceImpl(Project project, TypeRef model) {
            super(project, model);
        }

        @Override
        public Class getRawClass() {
            return this.getClass();
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public String getName() {
            TypeDescription typeDesc = this.getDelegate();
            ObjectTypeDescription td = typeDesc.get().asObject();
            String result = (String)td.getTransientProperty("resource_location");
            if (result == null) {
                result = typeDesc.getName();
            }
            return result;
        }
    }

    public static class CatalogModuleImpl
    extends CatalogObjectImpl
    implements CatalogModule {
        private CatalogModuleImpl(Project project, TypeRef model) {
            super(project, model);
        }

        @Override
        public Class getRawClass() {
            return CatalogModule.class;
        }

        @Override
        public boolean isHidden() {
            return "SystemFaults".equals(this.getName());
        }

        @Override
        public boolean isDeletable() {
            return !this.isReadOnly() && !this.isRootModule();
        }
    }

    public static class BpmObjectImpl
    extends CatalogObjectImpl
    implements BpmObject {
        BpmObjectDynamicRef dynamicRef;

        private BpmObjectImpl(Project project, TypeRef model) {
            super(project, model);
            XObjectTypeDescription bpmo = model.get().asBpmObject();
            ComponentCatalog catalog = model.getCatalog();
            String attributesObjectId = TypeUtils.getAttributesObjectId((ObjectTypeDescription)bpmo);
            this.dynamicRef = new BpmObjectDynamicRef(attributesObjectId, bpmo.getName(), catalog);
            if (!this.dynamicRef.get().isUnknown()) {
                try {
                    final String attObjectName = BpmObjectTypeDescriptionHelper.getAttributesObject((ObjectTypeDescription)bpmo).getText();
                    catalog.addListener(new CatalogListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void typeAdded(String typeName) {
                            if (typeName.equals(attObjectName)) {
                                try {
                                    List attributes = BpmObjectImpl.this.getDelegate().getCatalog().find(typeName).get().asObject().getAttributes();
                                    for (MethodTypeDescription attribute : attributes) {
                                        BpmObjectImpl.this.membersUpdatedFromCatalog = true;
                                        BpmObjectImpl.this.ensureMemberIsAdded(attribute);
                                    }
                                }
                                catch (ProjectException e) {
                                    Log.logDebug((Throwable)((Object)e));
                                }
                                catch (AmbiguousTypeNameException e) {
                                    Log.logDebug((Throwable)e);
                                }
                                finally {
                                    BpmObjectImpl.this.membersUpdatedFromCatalog = false;
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void typeRemoved(String typeName) {
                            if (typeName.equals(attObjectName)) {
                                Sequence<CatalogMember> attributes = BpmObjectImpl.this.getAttributes();
                                for (CatalogMember attribute : attributes) {
                                    try {
                                        BpmObjectImpl.this.membersUpdatedFromCatalog = true;
                                        BpmObjectImpl.this.removeChild(attribute);
                                    }
                                    catch (ProjectException e) {
                                        Log.logDebug((Throwable)((Object)e));
                                    }
                                    finally {
                                        BpmObjectImpl.this.membersUpdatedFromCatalog = false;
                                    }
                                }
                            }
                        }

                        public void postSync() {
                        }

                        public void preSync() {
                        }
                    });
                }
                catch (BpmObjectTypeDescriptionHelper.CannotFindAttributesObjectException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public boolean isBpmObject() {
            return true;
        }

        @Override
        public Class getRawClass() {
            return BpmObject.class;
        }

        @Override
        public TypeRef getDynamicRef() {
            return this.dynamicRef;
        }

        @Override
        public boolean isFaultObject() {
            return false;
        }

        @Override
        public FaultObject asFaultObject() {
            return (FaultObject)((Object)this);
        }

        @Override
        public boolean canAddAttributes() {
            return super.isValid() && !this.isFromExternalSchema() && !this.isException() && !this.isSynthesized();
        }
    }
}

