/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.CatalogArgumentImpl;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.ImmutableDataDeclarationContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class CatalogMemberImpl
extends CatalogTypeImpl
implements CatalogMember,
ObjectPropertyListener {
    private DataDeclarationContainer inputArgumentsContainer;
    private DataDeclarationContainer outputArgumentsContainer;
    private CatalogObject parent;
    private static final String POSITION = "position";

    public CatalogMemberImpl(CatalogObject catalogObject, MethodTypeDescription method) {
        super(catalogObject.getProject(), (TypeRef)method);
        this.parent = catalogObject;
        method.addPropertyObserver("__all__", (ObjectPropertyListener)this);
    }

    @Override
    public CatalogObject getParentObject() {
        return this.parent;
    }

    @NotNull
    public ProjectObject.Mutable asMutable() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getParentObject().equals(((ProjectObject)other).getParentObject());
    }

    @Override
    public MethodTypeDescription getMemberType() {
        return this.getDelegate().get().asMethod();
    }

    @Override
    public boolean isMutable() {
        return this.getParentObject().isMutable();
    }

    @Override
    public boolean isHidden() {
        return this.getDelegate().get().isHidden();
    }

    @Override
    public boolean isShadowed(DataDeclarationContainer context) {
        return false;
    }

    @Override
    public String getDefaultValue() {
        return this.getMemberType().asAttribute().getDefaultValue();
    }

    @Override
    public boolean isRequired() {
        return this.getMemberType().asAttribute().isRequired();
    }

    @Override
    public CatalogType getResultType() {
        return CatalogMemberImpl.get(this.getMemberType().getResultTypeRef());
    }

    @Override
    public int getPosition() {
        return this.getMemberType().getPosition();
    }

    @Override
    public void moveUp() {
        int old = this.getPosition();
        int newPosition = old - 1;
        AttributeTypeDescription attribute = this.getMemberType().asAttribute();
        attribute.changePosition(newPosition);
        attribute.getParent().asObject().packAttributePositions();
        CatalogObject parent = this.getParentObject();
        try {
            parent.moveChild(this, newPosition - 1);
            assert (attribute.getParent() != null) : "Null parent";
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void moveDown() {
        int old = this.getPosition();
        int newPosition = old + 1;
        AttributeTypeDescription attribute = this.getMemberType().asAttribute();
        attribute.changePosition(newPosition);
        attribute.getParent().asObject().packAttributePositions();
        CatalogObject parent = this.getParentObject();
        try {
            parent.moveChild(this, newPosition - 1);
            assert (attribute.getParent() != null) : "Null parent";
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CatalogArgument getResultArgument() {
        return new CatalogArgumentImpl(this, this.getMemberType().getResultArgument());
    }

    @Override
    public CatalogType getType() {
        return this.getResultType();
    }

    @Override
    public boolean isIn() {
        return this.getMemberType().hasSetter();
    }

    @Override
    public boolean isDeletable() {
        CatalogObject parentObject = this.getParentObject();
        return parentObject.isBpmObject() && (this.isMethod() || parentObject.asBpmObject().isMutable() && parentObject.asBpmObject().canAddAttributes());
    }

    @Override
    public boolean isOut() {
        return this.getMemberType().hasGetter();
    }

    @Override
    public void setName(String name) {
        this.getMemberType().setName(name);
    }

    @Override
    public void setType(CatalogType type) {
        this.getMemberType().setResultType(type.getDynamicRef());
    }

    @Override
    public Sequence<CatalogArgument> getArguments() {
        return this.createArgumentsList(null);
    }

    @Override
    public Sequence<CatalogArgument> getArguments(@NotNull AccessType accessType) {
        return this.createArgumentsList(accessType);
    }

    @Override
    public CatalogArgument findArgument(String name) {
        Argument arg = this.getMemberType().findArgument(name);
        return arg != null ? new CatalogArgumentImpl(this, arg) : null;
    }

    @Override
    public CatalogArgument addArgument(String name, CatalogType type) {
        return this.createAndAddArgument(name, type, 1L);
    }

    @Override
    public boolean isMethod() {
        return this.getMemberType().isMethod();
    }

    @Override
    public boolean isAttribute() {
        return this.getMemberType().isAttribute();
    }

    @Override
    public Class getRawClass() {
        return CatalogMember.class;
    }

    @Override
    public String getId() {
        return this.getMemberType().getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getNativeName() {
        return this.getName();
    }

    @Override
    public boolean isPredefinedDeclaration() {
        return false;
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence result;
        if (this.isAttribute()) {
            result = DataDeclarationImpl.getInnerDeclarations(this);
        } else {
            Sequence<CatalogArgument> args = this.getArguments();
            if (!this.getResultType().isVoid()) {
                ArrayList<CatalogArgument> all = new ArrayList<CatalogArgument>();
                args.addAllTo(all);
                all.add(this.getResultArgument());
                result = CollectionUtils.asSequence(all);
            } else {
                result = (Sequence)Cast.force(this.getArguments());
            }
        }
        return result;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, AccessType.IN);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        long access = 1L;
        switch (accessType) {
            case IN: {
                access = 1L;
                break;
            }
            case OUT: {
                access = 2L;
                break;
            }
            case IN_OUT: {
                access = 3L;
            }
        }
        return this.createArgument(name, type, access);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof CatalogArgument) : "DataDeclaration must be a CatalogArgument";
        this.addArgument((CatalogArgument)dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        dataDeclaration.delete();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        for (DataDeclaration declaration : this.getLocalDeclarations()) {
            this.removeDeclaration(declaration);
        }
    }

    @Override
    public DataDeclarationType getDeclarationType() {
        return DataDeclarationType.DATA_DECLARATION;
    }

    @Override
    public DataDeclarationContainer getDeclarationContainer() {
        return this.getParentObject();
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        if (this.inputArgumentsContainer == null) {
            this.inputArgumentsContainer = new ImmutableDataDeclarationContainer(this.getProject()){

                @Override
                public Sequence<DataDeclaration> getLocalDeclarations() {
                    return (Sequence)Cast.force((Object)CatalogMemberImpl.this.getInputArguments());
                }

                @Override
                public ProjectObject getRenderableObject() {
                    return CatalogMemberImpl.this;
                }
            };
        }
        return this.inputArgumentsContainer;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        if (this.outputArgumentsContainer == null) {
            this.outputArgumentsContainer = new ImmutableDataDeclarationContainer(this.getProject()){

                @Override
                public Sequence<DataDeclaration> getLocalDeclarations() {
                    return (Sequence)Cast.force((Object)CatalogMemberImpl.this.getOutputArguments());
                }

                @Override
                public ProjectObject getRenderableObject() {
                    return CatalogMemberImpl.this;
                }
            };
        }
        return this.outputArgumentsContainer;
    }

    @Override
    public boolean isInputArgumentsEnabled() {
        return true;
    }

    @Override
    public boolean isOutputArgumentsEnabled() {
        return true;
    }

    @Override
    public DataDeclarationContainer createArgumentsContainer() {
        throw new UnsupportedOperationException();
    }

    public void propertyChanged(Object object, String propertyName) {
        this.events().objectChanged();
    }

    public void dispose() {
        this.getMemberType().removePropertyObserver("__all__", (ObjectPropertyListener)this);
    }

    @Override
    public Sequence<ErrorObject> getExceptions() {
        ArrayList<ErrorObject> result = new ArrayList<ErrorObject>();
        List exceptionRefs = this.getMemberType().getExceptions();
        for (TypeRef exceptionRef : exceptionRefs) {
            ErrorObject error = (ErrorObject)CatalogMemberImpl.get(exceptionRef);
            result.add(error);
        }
        return CollectionUtils.asSequence(result);
    }

    private CatalogArgument createArgument(String name, CatalogType type, long accessType) {
        Argument arg = new Argument(name, type.getDynamicRef(), accessType);
        return new CatalogArgumentImpl(this, arg);
    }

    private void addArgument(@NotNull CatalogArgument argument) {
        this.getMemberType().addArgument(argument.getDelegateArgument());
    }

    private CatalogArgument createAndAddArgument(String name, CatalogType type, long accessType) {
        CatalogArgument arg = this.createArgument(name, type, accessType);
        this.addArgument(arg);
        return arg;
    }

    private Sequence<CatalogArgument> createArgumentsList(AccessType accessType) {
        Argument[] args = this.getMemberType().getArguments();
        ArrayList<CatalogArgumentImpl> result = new ArrayList<CatalogArgumentImpl>();
        for (Argument arg : args) {
            if (!(accessType == null || accessType.equals((Object)AccessType.IN) && arg.isIn() && !arg.isOut() || accessType.equals((Object)AccessType.OUT) && arg.isOut() && !arg.isIn()) && (!accessType.equals((Object)AccessType.IN_OUT) || !arg.isIn() || !arg.isOut())) continue;
            CatalogArgumentImpl catalogArg = new CatalogArgumentImpl(this, arg);
            result.add(catalogArg);
        }
        return CollectionUtils.asSequence(result);
    }

    private Sequence<CatalogArgument> getInputArguments() {
        return CollectionUtils.concat(this.getArguments(AccessType.IN), this.getArguments(AccessType.IN_OUT));
    }

    private Sequence<CatalogArgument> getOutputArguments() {
        return CollectionUtils.concat(this.getArguments(AccessType.OUT), this.getArguments(AccessType.IN_OUT));
    }
}

