/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.ExternalDocument;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.I18nProvider;

public class ApplicationInfoImpl
extends ProjectObjectImpl
implements ApplicationInfo {
    private LocaleStringMap categories;
    private LocaleStringMap descriptions;
    private List<ExternalDocument> externalDocuments;
    private LocaleStringMap labels;
    private List<String> tags;

    public ApplicationInfoImpl() {
        this.setId("ApplicationInfo");
    }

    @Override
    public String getLinkName() {
        return this.getString((I18nProvider)this.getLinkNames(), this.getParentObject().getDefaultLabel());
    }

    @Override
    public Process getParentObject() {
        return (Process)super.getParentObject();
    }

    @Override
    public String getLinkName(Locale locale) {
        return this.getLinkNames().getString(locale);
    }

    @Override
    public LocaleStringMap getLinkNames() {
        if (this.labels == null) {
            this.labels = this.createLocaleStringMap("process.appinfo.linkName");
        }
        return this.labels;
    }

    @Override
    public void setLinkName(String value) {
        this.getLinkNames().put(this.getDefaultLocale(), value);
    }

    @Override
    public String getDescription() {
        return this.getString((I18nProvider)this.getDescriptions(), "");
    }

    @Override
    public String getDescription(Locale locale) {
        return this.getDescriptions().getString(locale);
    }

    @Override
    public LocaleStringMap getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = this.createLocaleStringMap("process.appinfo.description");
        }
        return this.descriptions;
    }

    @Override
    public void setDescription(String value) {
        this.getDescriptions().put(this.getDefaultLocale(), value);
    }

    @Override
    public String getCategory() {
        return this.getString((I18nProvider)this.getCategories(), "");
    }

    @Override
    public String getCategory(Locale locale) {
        return this.getCategories().getString(locale);
    }

    @Override
    public LocaleStringMap getCategories() {
        if (this.categories == null) {
            this.categories = this.createLocaleStringMap("process.appinfo.category");
        }
        return this.categories;
    }

    @Override
    public void setCategory(String category) {
        this.getCategories().put(this.getDefaultLocale(), category);
    }

    @Override
    public void addTag(String tag) {
        if (!this.getTagsList().contains(tag)) {
            this.getTagsList().add(tag);
            this.events().objectChanged("process.appinfo.tags", null, null);
        }
    }

    @Override
    public void removeTag(String tag) {
        if (this.getTagsList().contains(tag)) {
            this.getTagsList().remove(tag);
            this.events().objectChanged("process.appinfo.tags", null, null);
        }
    }

    @Override
    public void clearTags() {
        if (!this.getTagsList().isEmpty()) {
            this.getTagsList().clear();
            this.events().objectChanged("process.appinfo.tags", null, null);
        }
    }

    @Override
    public Sequence<String> getTags() {
        return CollectionUtils.asSequence(this.getTagsList());
    }

    @Override
    public String getColumnTags() {
        StringBuilder result = new StringBuilder();
        Sequence<String> tags = this.getTags();
        if (!tags.isEmpty()) {
            for (String tag : tags) {
                if (result.length() > 0) {
                    result.append(";");
                }
                result.append(tag);
            }
        }
        return result.toString();
    }

    @Override
    public void addExternalDocument(ExternalDocument doc) {
        if (!this.getExternalDocumentList().contains(doc)) {
            this.getExternalDocumentList().add(doc);
            this.events().objectChanged("process.appinfo.documentation", null, null);
        }
    }

    @Override
    public void removeExternalDocument(ExternalDocument doc) {
        if (this.getExternalDocumentList().contains(doc)) {
            this.getExternalDocumentList().remove(doc);
            this.events().objectChanged("process.appinfo.documentation", null, null);
        }
    }

    @Override
    public void clearExternalDocuments() {
        if (!this.getExternalDocumentList().isEmpty()) {
            this.getExternalDocumentList().clear();
            this.events().objectChanged("process.appinfo.documentation", null, null);
        }
    }

    @Override
    public Sequence<ExternalDocument> getExternalDocuments() {
        return CollectionUtils.asSequence(this.getExternalDocumentList());
    }

    private List<String> getTagsList() {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        return this.tags;
    }

    private List<ExternalDocument> getExternalDocumentList() {
        if (this.externalDocuments == null) {
            this.externalDocuments = new ArrayList<ExternalDocument>();
        }
        return this.externalDocuments;
    }
}

