/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bamdata;

import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.bamdata.BAMActivityInfo;
import oracle.bpm.bamdata.BAMResourceInfo;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.ResourceInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.xml.XmlWriter;

public class ActivityInfo
implements BAMActivityInfo {
    private String[] categories;
    private SortedMap<String, ActivityInfo> children = new TreeMap<String, ActivityInfo>();
    private RunningInfo[] dataByCategory;
    private String name;
    private Map<String, ResourceInfo> resourcesInfo = new TreeMap<String, ResourceInfo>();
    private RunningInfo runningInfo;
    private static final long serialVersionUID = -9078462602678257354L;
    static final long serialCheck = 3016220274896938860L;

    protected ActivityInfo(ActivityInfo parent, String name) {
        this(parent.getRun(), name, parent.categories);
        parent.addActivity(this);
    }

    protected ActivityInfo(Run run, String name, String[] categories) {
        this.name = name;
        this.setCategories(categories);
        this.runningInfo = new RunningInfo(run);
        this.dataByCategory = new RunningInfo[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            this.dataByCategory[i] = new RunningInfo(run);
        }
    }

    public static ActivityInfo create(Run run, String name, String[] categories) {
        return new ActivityInfo(run, name, categories);
    }

    public static ActivityInfo create(ActivityInfo parent, String activityName) {
        return new ActivityInfo(parent, activityName);
    }

    @Override
    public BAMActivityInfo consolidate(BAMActivityInfo activityInfo) {
        if (activityInfo == null) {
            activityInfo = ActivityInfo.create(this.getRun(), this.getName(), this.getCategories());
        }
        this.getRunningInfo().consolidate(activityInfo.getRunningInfo());
        for (int i = 0; i < this.categories.length; ++i) {
            String category = this.categories[i];
            for (int k = 0; k < activityInfo.getCategories().length; ++k) {
                if (!activityInfo.getCategoryName(k).equals(category)) continue;
                this.dataByCategory[i].consolidate(activityInfo.getDataByCategory()[k]);
            }
        }
        for (ActivityInfo activityInfo1 : this.getChildren().values()) {
            Map<String, ActivityInfo> consolidatedChildren = activityInfo.getChildren();
            if (consolidatedChildren == null || consolidatedChildren.size() <= 0) continue;
            ActivityInfo consolidatedactivityInfo = consolidatedChildren.get(activityInfo1.getName());
            if (consolidatedactivityInfo != null) {
                activityInfo1.consolidate(consolidatedactivityInfo);
                continue;
            }
            consolidatedChildren.put(activityInfo1.getName(), activityInfo1);
        }
        return activityInfo;
    }

    @Override
    public BAMActivityInfo getActivity(String activityName) {
        return (BAMActivityInfo)this.children.get(activityName);
    }

    @Override
    public String[] getCategories() {
        return this.categories;
    }

    @Override
    public String getCategoryName(int i) {
        return this.categories[i];
    }

    @Override
    public Map<String, ActivityInfo> getChildren() {
        return this.children;
    }

    @Override
    public BAMRunningInfo[] getDataByCategory() {
        return this.dataByCategory;
    }

    @Override
    public long getFinishTime() {
        return this.getRun().getFinishTime();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BAMResourceInfo getResourceInfo(String name) {
        return this.resourcesInfo.get(name);
    }

    @Override
    public Map<String, ResourceInfo> getResources() {
        return this.resourcesInfo;
    }

    @Override
    public Run getRun() {
        return this.runningInfo.getRun();
    }

    public void setRunningInfo(RunningInfo runningInfo) {
        this.runningInfo = runningInfo;
    }

    @Override
    public BAMRunningInfo getRunningInfo() {
        return this.runningInfo;
    }

    public RunningInfo getRunningInfoImpl() {
        return this.runningInfo;
    }

    public void activate(int category, long currTimeMicros, long arrivalTime) {
        long waitTime = currTimeMicros - arrivalTime;
        this.getRunningInfoImpl().activateInstance(currTimeMicros, waitTime);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(category);
        if (categoryInfo != null) {
            categoryInfo.activateInstance(currTimeMicros, waitTime);
        }
    }

    public void addActivity(ActivityInfo activityInfo) {
        this.children.put(activityInfo.getName(), activityInfo);
    }

    public void addResourceInfo(String name, fuego.simulation.ResourceInfo info) {
        this.resourcesInfo.put(name, info);
    }

    public void clear() {
        this.runningInfo.clear();
        for (RunningInfo info : this.dataByCategory) {
            info.clear();
        }
    }

    public void clearResources() {
        this.resourcesInfo.clear();
    }

    @Override
    public boolean containsResourceInfo(String name) {
        return this.resourcesInfo.containsKey(name);
    }

    public void createInstance(long currentTime) {
        this.getRunningInfoImpl().addInstance(currentTime, false);
    }

    public void createInstance(int category, long currentTime) {
        this.getRunningInfoImpl().addInstance(currentTime, false);
        this.dataByCategory[category].addInstance(currentTime, false);
    }

    public void queue(int category, long currTimeMicros) {
        this.getRunningInfoImpl().addInstance(currTimeMicros, true);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(category);
        if (categoryInfo != null) {
            categoryInfo.addInstance(currTimeMicros, true);
        }
    }

    public void remove(int category, long currTimeMicros, long arrivalTime, long activationTime) {
        long cycleTime = currTimeMicros - arrivalTime;
        long workTime = currTimeMicros - activationTime;
        this.getRunningInfoImpl().removeInstance(currTimeMicros, workTime, cycleTime);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(category);
        if (categoryInfo != null) {
            categoryInfo.removeInstance(currTimeMicros, workTime, cycleTime);
        }
    }

    public void reset() {
        this.runningInfo.reset();
        for (RunningInfo info : this.dataByCategory) {
            info.reset();
        }
        for (ActivityInfo activityInfo1 : this.children.values()) {
            activityInfo1.reset();
        }
        for (ResourceInfo simulationResource : this.resourcesInfo.values()) {
            simulationResource.reset();
        }
    }

    public void terminateInstance(long creationTime, int category) {
        long currTime = this.getRun().getCurrentTime();
        long totalWorkTime = currTime - creationTime;
        this.getRunningInfoImpl().removeInstance(currTime, totalWorkTime, totalWorkTime);
        this.dataByCategory[category].removeInstance(currTime, totalWorkTime, totalWorkTime);
    }

    public void terminateInstance(long currTimeMicros, long creationTime) {
        long totalWorkTime = currTimeMicros - creationTime;
        this.getRunningInfoImpl().removeInstance(currTimeMicros, totalWorkTime, totalWorkTime);
    }

    public void toXml(XmlWriter writer) throws IOException {
        writer.startElement("ActivityInfo");
        writer.printAttribute("name", this.name);
        this.runningInfo.toXml(writer);
        for (int i = 0; i < this.categories.length; ++i) {
            writer.startElement("category");
            writer.printAttribute("name", this.categories[i]);
            this.dataByCategory[i].toXml(writer);
            writer.endElement();
        }
        for (ActivityInfo activityInfo : this.children.values()) {
            activityInfo.toXml(writer);
        }
        writer.endElement();
    }

    protected RunningInfo getCategoryRunningInfo(int category) {
        return this.dataByCategory[category];
    }

    protected void setUnitCost(double unitCost) {
        this.runningInfo.setUnitCost(unitCost);
        for (RunningInfo info : this.dataByCategory) {
            info.setUnitCost(unitCost);
        }
    }

    private void setCategories(String[] categories) {
        this.categories = categories;
    }
}

