/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.Event;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.Random;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.project.model.features.RelatedBPMNProcessFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;

public class SubflowSimulationActivityImpl
extends SimulationFlowNodeImpl {
    protected SubflowSimulationActivityImpl(FlowNode node) {
        super(node);
    }

    @Override
    public void scheduleMove(long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        Process relatedProcess = this.getFlowNode().getFeature(RelatedBPMNProcessFeature.class).getRelatedProcess(this.getFlowNode().getProject());
        if (this.getInnerSimulation() && relatedProcess != null) {
            token.setCurrentActivity(this);
            Simulation simulation = this.getSimulation(token);
            Event event = Event.createGenerateIPCEvent(currentTime, simulation.getNextCategory(simulation.getProjectSimulation()), token, simulation.getProjectSimulation(), this.getRelatedModel(simulation), this.createChildProcessInfo(simulation, relatedProcess.getId()));
            eventQueue.offer((Object)event);
            int totalInstances = simulation.getProcessInstanceCount(relatedProcess);
            int i = ++totalInstances;
            simulation.getProcessInstanceCountMap().put(relatedProcess, i);
        } else {
            super.scheduleMove(eventTime, currentTime, token, eventQueue, random);
        }
    }

    Simulation getSimulation(Token token) {
        return (Simulation)token.getProcessInfo().getRun();
    }

    private ModelSimulation getRelatedModel(Simulation simulation) {
        return this.getRelatedSimulationModel(simulation);
    }

    private ActivityInfo createChildProcessInfo(Simulation simulation, String processName) {
        ActivityInfo childProcessInfo = (ActivityInfo)simulation.getProcessRuntimeInfo(processName);
        if (childProcessInfo == null) {
            childProcessInfo = ActivityInfo.create(simulation, simulation.getProjectSimulation(), this.getRelatedModel(simulation), processName, simulation.getProjectSimulation().getCategoryLabels());
            simulation.setProcessRuntimeInfo(processName, childProcessInfo);
        }
        return childProcessInfo;
    }
}

