/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimulationUtils {
    private SimulationUtils() {
    }

    public static List<BoundaryEvent> findTimerBoundaries(FlowNode node, boolean interrupting) {
        List<BoundaryEvent> boundaries = new ArrayList<BoundaryEvent>();
        if (node.isActivity()) {
            Activity activity = node.asAnyNode(Activity.class);
            boundaries = SimulationUtils.getValidBoundaryTimerEvents(activity, interrupting);
        }
        return boundaries;
    }

    public static List<SequenceFlow> findSimulationOutputTransitions(FlowNode flowNode) {
        ArrayList<SequenceFlow> outputTransitions = new ArrayList<SequenceFlow>();
        for (SequenceFlow t : flowNode.getOutgoingSequenceFlows()) {
            outputTransitions.add(t);
        }
        return outputTransitions;
    }

    public static List<SequenceFlow> findValidForSimulationOutputTransitions(FlowNode node) {
        List<SequenceFlow> outputTransitions = SimulationUtils.findSimulationOutputTransitions(node);
        return outputTransitions;
    }

    public static List<SequenceFlow> findValidBoundaryEventsSeqFlows(Activity activity, boolean interrupting) {
        ArrayList<SequenceFlow> outputTransitions = new ArrayList<SequenceFlow>();
        for (BoundaryEvent be : activity.getActivityBoundaryEvents()) {
            Sequence<SequenceFlow> flowSequence;
            boolean filter = interrupting ? be.cancelActivity() : !be.cancelActivity();
            if (!filter || be.getEventTriggerType() == EventTriggerType.TIMER || (flowSequence = be.getOutgoingSequenceFlows()).isEmpty()) continue;
            outputTransitions.add((SequenceFlow)CollectionUtils.first(flowSequence));
        }
        return outputTransitions;
    }

    public static List<BoundaryEvent> getValidBoundaryTimerEvents(Activity activity, boolean interrupting) {
        ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
        for (BoundaryEvent be : activity.getActivityBoundaryEvents()) {
            boolean filter = interrupting ? be.cancelActivity() : !be.cancelActivity();
            if (!filter || be.getEventTriggerType() != EventTriggerType.TIMER || CollectionUtils.size(be.getOutgoingSequenceFlows()) != 1) continue;
            boundaryEvents.add(be);
        }
        return boundaryEvents;
    }

    @Nullable
    public static SimulationSequenceFlow getSimulationSequenceFlowFor(@NotNull ModelSimulation modelSimulation, @NotNull BoundaryEvent boundaryEvent) {
        SimulationSequenceFlow simulationSequenceFlow = null;
        Sequence<SequenceFlow> boundarySequencesFlow = boundaryEvent.getOutgoingSequenceFlows();
        for (SimulationSequenceFlow sf : modelSimulation.getSimulationSequenceFlows()) {
            for (SequenceFlow sfboundary : boundarySequencesFlow) {
                if (!sfboundary.equals(sf.getTransition())) continue;
                return sf;
            }
        }
        return simulationSequenceFlow;
    }
}

