/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import oracle.bpm.lang.Interval;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import org.jetbrains.annotations.NotNull;

public class SimulationSequenceFlowImpl
extends ProjectObjectImpl
implements SimulationSequenceFlow {
    private Interval dueInterval;
    private ModelSimulation modelSimulation;
    private String name;
    private double probability = 1.0;
    private String relatedBoundaryId;
    private boolean usesInterval;

    public SimulationSequenceFlowImpl(Project project, String name) {
        super(project);
        this.name = name;
    }

    @Override
    public void setId(String name) {
        this.name = name;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.SIMULATION_TRANSITION;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.modelSimulation;
    }

    @Override
    public void setProbability(double probability) {
        if (this.probability != probability) {
            this.probability = probability;
            this.events().objectChanged("probability", this.probability, probability);
        }
    }

    @Override
    public Interval getDueInterval() {
        return this.dueInterval;
    }

    @Override
    public void setDueInterval(Interval interval) {
        this.dueInterval = interval;
    }

    @Override
    public boolean usesInterval() {
        return this.usesInterval;
    }

    @Override
    public void setUsesInterval(boolean usesInterval) {
        this.usesInterval = usesInterval;
    }

    @Override
    public String getRelatedBoundaryId() {
        return this.relatedBoundaryId;
    }

    @Override
    public void setRelatedBoundaryId(String boundaryId) {
        this.relatedBoundaryId = boundaryId;
    }

    @Override
    public SequenceFlow getTransition() {
        return null;
    }

    @Override
    public double getProbability() {
        return this.probability;
    }

    public void setModelSimulation(ModelSimulation modelSimulation) {
        this.modelSimulation = modelSimulation;
    }
}

