/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.Token;
import java.util.Random;
import oracle.bpm.bamdata.BAMResourceRunningInfo;
import oracle.bpm.bamdata.ResourceRunningInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;

public class ResourceInfo
extends oracle.bpm.bamdata.ResourceInfo
implements Comparable {
    protected ProjectSimulation model;
    static final long serialVersionUID = -7891708809346326155L;
    static final long serialCheck = 4213256877576137085L;

    public ResourceInfo(Run run, ProjectSimulation model, String name, int capacity, double cost) {
        super(run, name, capacity, model.getCategoryLabels(), cost);
        this.model = model;
    }

    public boolean isAvailable() {
        SimulationResource resourceModel = this.getResourceModel();
        boolean selected = resourceModel.getSelected();
        boolean isAvailable = new Random().nextInt(100) < resourceModel.getAvailability();
        boolean hasCapacity = this.getCurrentAcquiredCount() < this.getCapacity();
        return selected && isAvailable && hasCapacity;
    }

    public void setCapacity(int capacity) {
        BAMResourceRunningInfo[] dataByCategory;
        this.getRunningInfoImpl().setResourceCount(capacity);
        for (BAMResourceRunningInfo aDataByCategory : dataByCategory = this.getDataByCategory()) {
            ResourceRunningInfo resourceRunningInfo = (ResourceRunningInfo)aDataByCategory;
            resourceRunningInfo.setResourceCount(capacity);
        }
    }

    public int compareTo(Object o) {
        return 0;
    }

    public void startWorking(Token token) {
        this.getRunningInfoImpl().acquire();
        this.getCategoryRunningInfo(token.getCategory()).acquire();
    }

    public void stopWorking(Token token) {
        long currTime = this.getRun().getCurrentTime();
        long workTime = currTime - token.getActivationTime();
        long waitTime = token.getActivationTime() - token.getArrivalTime();
        this.getRunningInfoImpl().release(workTime, waitTime);
        this.getCategoryRunningInfo(token.getCategory()).release(workTime, waitTime);
    }

    protected int getCapacity() {
        return this.getRunningInfo().getCount();
    }

    protected int getCurrentAcquiredCount() {
        return this.getRunningInfo().getCurrentAcquiredCount();
    }

    SimulationResource getResourceModel() {
        return this.model.findResource(this.getName());
    }

    private int getSimulationPercentage() {
        return (int)(((double)this.getRun().getCurrentTime() - (double)this.getRun().getStartTime()) / (double)this.model.getDurationMicroseconds() * 100.0);
    }
}

