/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ResourceInfo;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.Random;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.simulation.SimulationResource;

public class InteractiveSimulationActivityImpl
extends SimulationFlowNodeImpl {
    protected InteractiveSimulationActivityImpl(UserTask node) {
        super(node);
    }

    @Override
    protected long getNextIPT(Token token, long currentTime, Random random) {
        long nextIPT = super.getNextIPT(token, currentTime, random);
        ResourceInfo assignedResource = token.getCurrentResource();
        return assignedResource != null ? this.addEfficiency(this.getResourceModel(assignedResource.getName()), currentTime, nextIPT) : nextIPT;
    }

    private SimulationResource getResourceModel(String name) {
        for (SimulationResource simulationResource : this.getAvailableResources()) {
            if (!simulationResource.getId().equals(name)) continue;
            return simulationResource;
        }
        return null;
    }

    private long addEfficiency(SimulationResource simulationResource, long currentTime, long nextIPT) {
        double delay = (double)(nextIPT - currentTime) * (1.0 - simulationResource.getEfficiency() / 100.0);
        return nextIPT + (long)delay;
    }
}

