/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ConstantDistribution;
import fuego.simulation.ExponentialDistribution;
import fuego.simulation.NormalDistribution;
import fuego.simulation.RealDistribution;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.UniformDistribution;
import java.util.Random;
import oracle.bpm.project.GenericContent;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.util.Identifier;

public abstract class AbstractDistribution
extends GenericContent
implements Distribution {
    DistributionType type;
    private SimulationFlowNodeImpl node;

    protected AbstractDistribution(DistributionType type) {
        this.type = type;
    }

    public static AbstractDistribution create(DistributionType distributionType) {
        AbstractDistribution result = null;
        if (distributionType.equals((Object)DistributionType.CONSTANT)) {
            result = ConstantDistribution.create();
        } else if (distributionType.equals((Object)DistributionType.EXPONENTIAL)) {
            result = ExponentialDistribution.create();
        } else if (distributionType.equals((Object)DistributionType.NORMAL)) {
            result = NormalDistribution.create();
        } else if (distributionType.equals((Object)DistributionType.UNIFORM)) {
            result = UniformDistribution.create();
        } else if (distributionType.equals((Object)DistributionType.REAL)) {
            result = RealDistribution.create();
        }
        return result;
    }

    public void fireDistributionChanged() {
        if (this.node != null) {
            this.node.fireDistributionChanged();
        }
    }

    @Override
    public String getClassName() {
        return Identifier.capitalize((String)this.getType().toString().toLowerCase()) + "Distribution";
    }

    @Override
    public DistributionType getType() {
        return this.type;
    }

    @Override
    public long getDeviation() {
        return 0L;
    }

    @Override
    public void setDeviation(long deviation) {
    }

    @Override
    public long next(Random random, long currentTime) {
        return this.next(random);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDistribution other = (AbstractDistribution)obj;
        return !(this.type == null ? other.type != null : this.type != other.type);
    }

    protected void setNode(SimulationFlowNodeImpl node) {
        this.node = node;
    }
}

