/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static void main(String[] args) {
        String schemaFile = null;
        if (args.length > 1) {
            schemaFile = args[1];
        }
        Document doc = XMLUtil.parse(args[0], schemaFile);
    }

    public static Document parse(String xmlFile, String schemaFile) {
        return XMLUtil.parse(xmlFile, schemaFile, false);
    }

    public static Document parse(String xml, String schemaFile, boolean isStringXML) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            boolean validating = true;
            if (schemaFile != null) {
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "Creating Schema object from schemaFile=" + schemaFile);
                File FileSchema = new File(schemaFile);
                InputStream is = null;
                Schema schema = null;
                if (FileSchema.exists()) {
                    schema = sf.newSchema(new File(schemaFile));
                    CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "schema file " + schemaFile + " exists!");
                } else {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaFile);
                    StreamSource ss = new StreamSource(is);
                    if (is == null || ss == null) {
                        System.err.println(schemaFile + " doesn't exist in classpath!!");
                        return null;
                    }
                    CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "schema file " + schemaFile + " found in classpath");
                    schema = sf.newSchema(ss);
                }
                CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "Schema : " + schema);
                factory.setSchema(schema);
                validating = true;
            }
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            if (!isStringXML) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "Parsing xmlFile=" + xml);
                doc = factory.newDocumentBuilder().parse(new File(xml));
                CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "Done parsing xmlFile=" + xml);
            } else {
                doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
            }
        }
        catch (SAXException e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, XMLUtil.class.getName(), "parse", e);
        }
        catch (ParserConfigurationException e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, XMLUtil.class.getName(), "parse", e);
        }
        catch (IOException e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, XMLUtil.class.getName(), "parse", e);
        }
        CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "Validated " + xml);
        return doc;
    }

    public static void validate(String xml, String schemaFile) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File schemaLocation = new File(schemaFile);
            Schema schema = factory.newSchema(schemaLocation);
            Validator validator = schema.newValidator();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            StreamSource source = new StreamSource(is);
            validator.validate(source);
        }
        catch (Exception ex) {
            String errMsg = ex.getMessage();
            throw new Exception(errMsg);
        }
    }
}

