/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.Case.model.TDataTypeEnum;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TElementDataTypeEnum;
import oracle.bpm.casemgmt.metadata.activity.model.TInputParameter;
import oracle.bpm.casemgmt.metadata.activity.model.TPayloadInput;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.BaseSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.ComplexTypeSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.ElementSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.ImportSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.IncludeSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.SchemaSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.SequenceSchemaElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CaseActivityMultipleInputWrapper {
    public static final String ACTIVITY_INPUT_ROOT_TYPE = "ActivityInputsType";
    private static final String OPEN_BRACES = "{";
    private static final String CLOSE_BRACES = "}";
    private static final String PREFIX = "ns";
    private static final String REF = "ref";
    private static final String TYPE = "type";
    private static final String COLON = ":";
    private static final String TASK_NS = "http://xmlns.oracle.com/bpel/workflow/task";
    private static final String CASE_SCHEMA_DIR = "caseschema";
    private static final String XSD_FILE_PREFIX = "transient";
    private static final String XSD = ".xsd";
    private static final String TNS_PREFIX = "tns";
    private static final String ACTIVITY_CONTEXT_PATH = "oracle.bpm.casemgmt.metadata.activity.model";
    private static final String CASE_CONTEXT_PATH = "oracle.bpm.casemgmt.metadata.Case.model";

    public Map<String, String> generateSchemaForCaseActivityInputs(String caseActivityFileLocation, String projectDir) throws Exception {
        String targetNameSpace = null;
        TCaseActivity caseActivity = null;
        ArrayList<TInputParameter> inputList = new ArrayList();
        String key = null;
        this.debugLog("generateSchemaForCaseActivityInputs", "Start projectDir " + projectDir);
        caseActivity = this.unmarshallCaseActivity(caseActivityFileLocation);
        if (caseActivity.getActivityType().equals((Object)TActivity.BPMN)) {
            inputList = caseActivity.getBpmnActivity().getParameters().getInputs().getParameter();
        } else if (caseActivity.getActivityType().equals((Object)TActivity.HWF)) {
            inputList = caseActivity.getWorkflowActivity().getParameters().getInputs().getParameter();
        }
        if (caseActivity.getBpmnActivity() != null) {
            targetNameSpace = caseActivity.getBpmnActivity().getComponentInfo().getNamespace();
            key = caseActivity.getBpmnActivity().getComponentInfo().getReferenceName();
            key = key.substring(0, key.indexOf("."));
        } else if (caseActivity.getWorkflowActivity() != null) {
            targetNameSpace = TASK_NS;
            key = "htSvc";
        }
        Document transientXSD = this.generateSchema(inputList, targetNameSpace, projectDir);
        projectDir = this.writeToFile(transientXSD, projectDir, caseActivity.getName());
        this.debugLog("generateSchemaForCaseActivityInputs", "Completed - wrote generated xsd to " + projectDir);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, projectDir);
        return map;
    }

    public String generateSchemaForCaseDataObject(String caseDataName, String caseFileLocation, String projectDir) throws Exception {
        TCaseMetadata caseMetadata = null;
        Document transientXSD = null;
        this.debugLog("generateSchemaForCaseDataObject", "Start projectDir " + projectDir);
        caseMetadata = this.unmarshalCaseMetadata(caseFileLocation);
        List<TCaseData> caseDataList = caseMetadata.getCaseData();
        TData dataObj = this.getDataObjFromTCaseData(caseDataList, caseDataName);
        if (dataObj != null) {
            if (dataObj.getDataType().equals((Object)TDataTypeEnum.COMPLEX_TYPE)) {
                transientXSD = this.generateCaseDataObjectSchema(dataObj, projectDir);
                projectDir = this.writeToFile(transientXSD, projectDir, caseDataName);
            } else if (dataObj.getDataType().equals((Object)TDataTypeEnum.ELEMENT)) {
                projectDir = new File(projectDir, dataObj.getSchema()).toString();
                this.debugLog("generateSchemaForCaseDataObject", " caseDataName : projectDir ==> " + caseDataName + " : " + projectDir);
            }
        }
        this.debugLog("generateCaseDataSchema", "Completed - wrote generated xsd to " + projectDir);
        return projectDir;
    }

    private Document generateSchema(List<TInputParameter> inputList, String targetNameSpace, String projectDir) throws Exception {
        String METHODNAME = "generateSchema";
        Document wrappedSchema = null;
        SchemaSchemaElement iputSchema = new SchemaSchemaElement("http://www.w3.org/2001/XMLSchema");
        this.setDefaultSchemaAttributes(iputSchema, targetNameSpace);
        ElementSchemaElement elemSchema = new ElementSchemaElement(iputSchema, (BaseSchemaElement)iputSchema);
        elemSchema.setName("ActivityInputs");
        elemSchema.setType("tns:ActivityInputsType");
        ComplexTypeSchemaElement ct = new ComplexTypeSchemaElement(iputSchema, (BaseSchemaElement)iputSchema);
        SequenceSchemaElement sse = new SequenceSchemaElement(iputSchema, (BaseSchemaElement)ct);
        ct.setName(ACTIVITY_INPUT_ROOT_TYPE);
        TPayloadInput payLoadIp = null;
        String typeNS = null;
        int i = 1;
        Map<Object, Object> attribMap = new HashMap();
        String prefix = null;
        String type = null;
        HashMap<String, String> processedTypes = new HashMap<String, String>();
        if (inputList != null && !inputList.isEmpty()) {
            for (TInputParameter ip : inputList) {
                if (ip.isSetCaseDataInput()) continue;
                payLoadIp = ip.getPayloadInput();
                typeNS = payLoadIp.getElementType();
                this.debugLog("generateSchema", "Namespace Type of input " + typeNS);
                type = typeNS.substring(typeNS.indexOf(CLOSE_BRACES) + 1);
                typeNS = typeNS.substring(typeNS.indexOf(OPEN_BRACES) + 1, typeNS.indexOf(CLOSE_BRACES));
                this.debugLog("generateSchema", "Namespace Type of input without braces " + typeNS);
                this.debugLog("generateSchema", "Type of input " + type);
                if (!processedTypes.containsKey(typeNS) && !payLoadIp.getElementDataType().equals((Object)TElementDataTypeEnum.SIMPLE_TYPE)) {
                    prefix = PREFIX + i;
                    processedTypes.put(typeNS, prefix);
                    this.importNamespace(iputSchema, prefix, typeNS);
                    String schemaLocation = ".." + File.separator + payLoadIp.getElementSchemaLocation();
                    this.importSchema(iputSchema, typeNS, schemaLocation);
                    ++i;
                }
                if (payLoadIp.getElementDataType().equals((Object)TElementDataTypeEnum.ELEMENT)) {
                    attribMap = this.getAttributeMap();
                    type = (String)processedTypes.get(typeNS) + COLON + type;
                    attribMap.put(REF, type);
                    this.createElementDefinitionInSequence(iputSchema, sse, null, null, attribMap);
                    continue;
                }
                attribMap = this.getAttributeMap();
                if (payLoadIp.getElementDataType().equals((Object)TElementDataTypeEnum.SIMPLE_TYPE)) {
                    attribMap.put(TYPE, type);
                }
                if (payLoadIp.getElementDataType().equals((Object)TElementDataTypeEnum.COMPLEX_TYPE)) {
                    type = (String)processedTypes.get(typeNS) + COLON + type;
                    attribMap.put(TYPE, type);
                }
                this.createElementDefinitionInSequence(iputSchema, sse, payLoadIp.getActivityParamName(), type, attribMap);
            }
        }
        wrappedSchema = iputSchema.getDoc();
        this.debugLog("generateSchema", "Generated xsd = \n" + XMLUtil.toString((Node)wrappedSchema));
        return wrappedSchema;
    }

    private TData getDataObjFromTCaseData(List<TCaseData> caseDataList, String caseDataName) {
        if (caseDataList != null && !caseDataList.isEmpty()) {
            for (TCaseData cd : caseDataList) {
                List<TData> dataList = cd.getData();
                for (TData dataObj : dataList) {
                    if (!dataObj.getName().equals(caseDataName)) continue;
                    return dataObj;
                }
            }
        }
        return null;
    }

    private Document generateCaseDataObjectSchema(TData dataObj, String projectDir) throws Exception {
        String METHODNAME = "generateCaseDataObjectSchema";
        Document wrappedSchema = null;
        HashMap<String, String> attribMap = new HashMap<String, String>();
        String prefix = TNS_PREFIX;
        String type = null;
        String elementName = dataObj.getName();
        String typeNS = dataObj.getType();
        String schemaLocation = ".." + File.separator + dataObj.getSchema();
        SchemaSchemaElement inputSchema = new SchemaSchemaElement("http://www.w3.org/2001/XMLSchema");
        this.debugLog("generateCaseDataObjectSchema", "Namespace Type of input " + typeNS);
        type = typeNS.substring(typeNS.indexOf(CLOSE_BRACES) + 1);
        typeNS = typeNS.substring(typeNS.indexOf(OPEN_BRACES) + 1, typeNS.indexOf(CLOSE_BRACES));
        this.setDefaultSchemaAttributes(inputSchema, typeNS);
        this.includeSchema(inputSchema, schemaLocation);
        this.debugLog("generateCaseDataObjectSchema", "Namespace Type of input without braces " + typeNS);
        this.debugLog("generateCaseDataObjectSchema", "Type of input " + type);
        ElementSchemaElement elemSchema = new ElementSchemaElement(inputSchema, (BaseSchemaElement)inputSchema);
        type = prefix + COLON + type;
        attribMap.put(TYPE, type);
        this.debugLog("generateCaseDataObjectSchema", "TDataTypeEnum " + (Object)((Object)dataObj.getDataType()));
        if (elementName != null && elementName.trim().length() > 0) {
            elemSchema.setName(elementName);
        }
        if (attribMap != null && !attribMap.isEmpty()) {
            Set keySet = attribMap.keySet();
            for (String key : keySet) {
                elemSchema.setAttributeValue(key, (String)attribMap.get(key));
            }
        }
        wrappedSchema = inputSchema.getDoc();
        this.debugLog("generateCaseDataObjectSchema", "Generated xsd = \n" + XMLUtil.toString((Node)wrappedSchema));
        return wrappedSchema;
    }

    private void createElementDefinitionInSequence(SchemaSchemaElement rootSchema, SequenceSchemaElement seqElem, String elementName, String elementType, Map<String, String> attribMap) {
        ElementSchemaElement elemSchema = new ElementSchemaElement(rootSchema, (BaseSchemaElement)seqElem);
        if (elementName != null && elementName.trim().length() > 0) {
            elemSchema.setName(elementName);
        }
        if (elementType != null && elementType.trim().length() > 0) {
            elemSchema.setType(elementType);
        }
        if (attribMap != null && !attribMap.isEmpty()) {
            Set<String> keySet = attribMap.keySet();
            for (String key : keySet) {
                elemSchema.setAttributeValue(key, attribMap.get(key));
            }
        }
    }

    private void importNamespace(SchemaSchemaElement rootSchema, String prefix, String targetNS) {
        if (targetNS != null && targetNS.trim().length() > 0) {
            rootSchema.setAttributeValue("xmlns:" + prefix, targetNS);
        }
    }

    private void importSchema(SchemaSchemaElement rootSchema, String xmlSchemaTargetNS, String schemaLocation) {
        ImportSchemaElement importSchemaElement = new ImportSchemaElement(rootSchema, (BaseSchemaElement)rootSchema);
        importSchemaElement.setNamespace(xmlSchemaTargetNS);
        importSchemaElement.setSchemaLocation(schemaLocation);
    }

    private void includeSchema(SchemaSchemaElement rootSchema, String schemaLocation) {
        IncludeSchemaElement importSchemaElement = new IncludeSchemaElement(rootSchema, (BaseSchemaElement)rootSchema);
        importSchemaElement.setSchemaLocation(schemaLocation);
    }

    private void setDefaultSchemaAttributes(SchemaSchemaElement dsSchema, String targetNamespace) {
        dsSchema.setAttributeValue("targetNamespace", targetNamespace);
        dsSchema.setAttributeValue("attributeFormDefault", "unqualified");
        dsSchema.setAttributeValue("elementFormDefault", "qualified");
        dsSchema.setAttributeValue("xmlns:tns", targetNamespace);
        dsSchema.setAttributeValue("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
    }

    private Object unmarshall(String fileLocation, String jaxbContext) throws Exception {
        File file = new File(fileLocation);
        if (!file.exists()) {
            throw new FileNotFoundException(fileLocation);
        }
        JAXBContext jaxbContextInstance = null;
        Object c = null;
        try {
            jaxbContextInstance = JAXBContext.newInstance((String)jaxbContext);
            c = jaxbContextInstance.createUnmarshaller().unmarshal(file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw e;
        }
        return c;
    }

    private TCaseActivity unmarshallCaseActivity(String caseActivityFileLocation) throws Exception {
        CaseActivity c = (CaseActivity)((Object)this.unmarshall(caseActivityFileLocation, ACTIVITY_CONTEXT_PATH));
        return (TCaseActivity)c.getValue();
    }

    private TCaseMetadata unmarshalCaseMetadata(String caseFileLocation) throws Exception {
        CaseMetadata caseMetadata = (CaseMetadata)((Object)this.unmarshall(caseFileLocation, CASE_CONTEXT_PATH));
        return (TCaseMetadata)caseMetadata.getValue();
    }

    private void debugLog(String methodName, String message) {
        System.out.println("CaseActivityMultipleInputWrapper." + methodName + " : " + message);
    }

    private Map<String, String> getAttributeMap() {
        HashMap<String, String> attribMap = new HashMap<String, String>();
        attribMap.put("minOccurs", "0");
        attribMap.put("maxOccurs", "1");
        return attribMap;
    }

    private String writeToFile(Document xsdDoc, String projectDir, String activityName) throws Exception {
        boolean isSuccess = true;
        File caseActivitySchemaDir = new File(projectDir = projectDir.concat(File.separator).concat(CASE_SCHEMA_DIR));
        if (!caseActivitySchemaDir.exists()) {
            isSuccess = caseActivitySchemaDir.mkdir();
        }
        if (isSuccess) {
            projectDir = projectDir.concat(File.separator).concat(XSD_FILE_PREFIX + activityName + XSD);
            this.debugLog("writeToFile", "Writing to file " + projectDir);
            XMLUtil.printDocument((Document)xsdDoc, (String)projectDir);
        }
        return projectDir;
    }
}

