/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.SimpleTypesEnum;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.persistence.model.ActionsPermittedForCaseObject;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseFabricHeaderProperty;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseObjectPermission;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.CompletedCaseActivity;
import oracle.bpm.casemgmt.persistence.model.CompletedCaseActivityList;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.UserActions;
import oracle.bpm.casemgmt.persistence.model.UserPermissions;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseObjectUtil {
    protected static final List<CaseMilestone> EMPTY_MILESTONE_LIST = new ArrayList<CaseMilestone>();
    protected static final List<CaseStakeHolder> EMPTY_STAKEHOLDER_LIST = new ArrayList<CaseStakeHolder>();
    protected static final List<Comment> EMPTY_COMMENT_LIST = new ArrayList<Comment>();
    protected static final List<CaseData> EMPTY_CASEDATA_LIST = new ArrayList<CaseData>();
    protected static final CaseFabricHeaderProperty EMPTY_FABRIC_HEADER_PROPERTY = new CaseFabricHeaderProperty();
    private static final Map<String, SimpleTypesEnum> typeToEnumMap = new HashMap<String, SimpleTypesEnum>();

    public static final void populateCaseMilestones(Case caseInstance) {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** populateCaseMilestones");
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseMilestones:" + caseInstance.caseMilestones);
        caseInstance.caseMilestones.size();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseMilestones:" + caseInstance.caseMilestones);
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseMilestones:" + caseInstance.caseMilestones.size());
    }

    public static final void populateCaseStakeHolders(Case caseInstance) {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** populateCaseStakeHolders");
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseStakeHolders:" + caseInstance.caseStakeHolders);
        caseInstance.caseStakeHolders.size();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseStakeHolders:" + caseInstance.caseStakeHolders);
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseStakeHolders:" + caseInstance.caseStakeHolders.size());
    }

    public static final void populateComments(Case caseInstance) {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** populateComments");
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** comments:" + caseInstance.comments);
        caseInstance.comments.size();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** comments:" + caseInstance.comments);
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** comments:" + caseInstance.comments.size());
    }

    public static final void populateCaseData(Case caseInstance) {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** populateCaseData");
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseData:" + caseInstance.caseDataList);
        caseInstance.caseDataList.size();
        for (CaseData caseData : caseInstance.caseDataList) {
            if (caseData == null) continue;
            if (!CaseObjectUtil.isNullOrEmpty(caseData.getData())) {
                caseData.setExternal(false);
                caseData.setState(ICaseConstants.CaseDataState.FETCHED);
                continue;
            }
            caseData.setExternal(true);
            caseData.setState(ICaseConstants.CaseDataState.NOT_FETCHED);
        }
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseData:" + caseInstance.caseDataList);
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseData:" + caseInstance.caseDataList.size());
    }

    public static final void removeNullChildrens(Case caseInstance) {
        CaseObjectUtil.removeNullChildrens(caseInstance.getCaseData());
        CaseObjectUtil.removeNullChildrens(caseInstance.getCaseMilestones());
        CaseObjectUtil.removeNullChildrens(caseInstance.getCaseStakeHolders());
        CaseObjectUtil.removeNullChildrens(caseInstance.getComments());
    }

    public static final void populateCaseFabricHeaderProperty(Case caseInstance) {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** CaseFabricHeaderProperty");
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseFabricHeaderProperty:" + caseInstance.caseFabricHeaderProperty);
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "*** caseFabricHeaderProperty:" + caseInstance.caseFabricHeaderProperty);
        if (caseInstance.getCaseFabricHeaderProperty() != null) {
            caseInstance.caseFabricHeaderProperty.getCompositeCreatedTime();
            caseInstance.caseFabricHeaderProperty.getProperties();
        }
    }

    public static final void populateAll(IBPMContext context, Case caseInstance) {
        if (caseInstance == null) {
            return;
        }
        CaseObjectUtil.populateCaseMilestones(caseInstance);
        CaseObjectUtil.populateCaseStakeHolders(caseInstance);
        CaseObjectUtil.populateComments(caseInstance);
        CaseObjectUtil.populateCaseData(caseInstance);
        CaseObjectUtil.populateCaseFabricHeaderProperty(caseInstance);
    }

    public static final void clearCaseMilestones(Case caseInstance) {
        caseInstance.caseMilestones = EMPTY_MILESTONE_LIST;
    }

    public static final void clearCaseStakeHolders(Case caseInstance) {
        caseInstance.caseStakeHolders = EMPTY_STAKEHOLDER_LIST;
    }

    public static final void clearComments(Case caseInstance) {
        caseInstance.comments = EMPTY_COMMENT_LIST;
    }

    public static final void clearCaseData(Case caseInstance) {
        caseInstance.caseDataList = EMPTY_CASEDATA_LIST;
    }

    public static final void clearCaseFabricHeaderProperty(Case caseInstance) {
        caseInstance.caseFabricHeaderProperty = EMPTY_FABRIC_HEADER_PROPERTY;
    }

    public static final void clearAll(Case caseInstance) {
        if (caseInstance == null) {
            return;
        }
        CaseObjectUtil.clearCaseMilestones(caseInstance);
        CaseObjectUtil.clearCaseStakeHolders(caseInstance);
        CaseObjectUtil.clearComments(caseInstance);
        CaseObjectUtil.clearCaseData(caseInstance);
        CaseObjectUtil.clearCaseFabricHeaderProperty(caseInstance);
    }

    public static final SimpleTypesEnum getCaseDataType(String type) {
        if (type != null && type.trim().length() > 0) {
            return typeToEnumMap.get(type);
        }
        return null;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static final Case getCaseClone(Case caseInstance) throws CaseServiceException {
        Case caseClone = new Case();
        try {
            caseClone.setCaseId(caseInstance.getCaseId());
            caseClone.setCaseHeader(CaseObjectUtil.getCaseHeaderClone(caseClone, caseInstance.getCaseHeader()));
            caseClone.setCaseFabricHeaderProperty(CaseObjectUtil.getCaseFabricHeaderPropertyClone(caseClone, caseInstance.getCaseFabricHeaderProperty()));
            ArrayList<CaseMilestone> caseMilestonesClone = new ArrayList<CaseMilestone>();
            caseClone.setCaseMilestones(caseMilestonesClone);
            if (caseInstance.getCaseMilestones() != null && caseInstance.getCaseMilestones().size() > 0) {
                for (CaseMilestone caseMilestone : caseInstance.getCaseMilestones()) {
                    caseMilestonesClone.add(CaseObjectUtil.getCaseMilestoneClone(caseClone, caseMilestone));
                }
            }
            ArrayList<CaseStakeHolder> caseStakeHoldersClone = new ArrayList<CaseStakeHolder>();
            caseClone.setCaseStakeHolders(caseStakeHoldersClone);
            if (caseInstance.getCaseStakeHolders() != null && caseInstance.getCaseStakeHolders().size() > 0) {
                for (CaseStakeHolder caseStakeHolder : caseInstance.getCaseStakeHolders()) {
                    caseStakeHoldersClone.add(CaseObjectUtil.getCaseStakeHolderClone(caseClone, caseStakeHolder));
                }
            }
            ArrayList<Comment> commentsClone = new ArrayList<Comment>();
            caseClone.setComments(commentsClone);
            if (caseInstance.getComments() != null && caseInstance.getComments().size() > 0) {
                for (Comment comment : caseInstance.getComments()) {
                    commentsClone.add(CaseObjectUtil.getCommentClone(caseClone, comment));
                }
            }
            ArrayList<CaseData> dataListClone = new ArrayList<CaseData>();
            caseClone.setCaseData(dataListClone);
            if (caseInstance.getCaseData() != null && caseInstance.getCaseData().size() > 0) {
                for (CaseData caseData : caseInstance.getCaseData()) {
                    dataListClone.add(CaseObjectUtil.getCaseDataClone(caseClone, caseData));
                }
            }
        }
        catch (CaseServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73437, new Object[0], e);
            CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.ERRORS, "CaseObjectUtil", "getClone", cse);
            throw cse;
        }
        return caseClone;
    }

    public static CaseHeader getCaseHeaderClone(Case caseClone, CaseHeader caseHeader) throws CaseServiceException {
        CaseHeader caseHeaderClone = new CaseHeader();
        CaseObjectUtil.copy(caseClone, caseHeader, caseHeaderClone);
        caseHeaderClone.setApplicationName(caseHeader.getApplicationName());
        caseHeaderClone.setCaseDefinitionId(caseHeader.getCaseDefinitionId());
        caseHeaderClone.setCaseDefinitionName(caseHeader.getCaseDefinitionName());
        caseHeaderClone.setCaseNamespace(caseHeader.getCaseNamespace());
        caseHeaderClone.setCaseNumber(caseHeader.getCaseNumber());
        caseHeaderClone.setCaseSummaryFormURI(caseHeader.getCaseSummaryFormURI());
        caseHeaderClone.setCategory(caseHeader.getCategory());
        caseHeaderClone.setCategoryDisplayName(caseHeader.getCategoryDisplayName());
        caseHeaderClone.setCompletedCaseActivityList(CaseObjectUtil.getCompletedCaseActivityListClone(caseHeader.getCompletedCaseActivityList()));
        caseHeaderClone.setComponentName(caseHeader.getComponentName());
        caseHeaderClone.setCompositeCreatedTime(caseHeader.getCompositeCreatedTime());
        caseHeaderClone.setCompositeDn(caseHeader.getCompositeDn());
        caseHeaderClone.setCompositeInstanceId(caseHeader.getCompositeInstanceId());
        caseHeaderClone.setCompositeName(caseHeader.getCompositeName());
        caseHeaderClone.setCompositeVersion(caseHeader.getCompositeVersion());
        caseHeaderClone.setConversationId(caseHeader.getConversationId());
        caseHeaderClone.setCreatedBy(caseHeader.getCreatedBy());
        caseHeaderClone.setCreatedByDisplayName(caseHeader.getCreatedByDisplayName());
        caseHeaderClone.setCreatedDate(caseHeader.getCreatedDate());
        caseHeaderClone.setDueDate(caseHeader.getDueDate());
        caseHeaderClone.setEcid(caseHeader.getEcid());
        caseHeaderClone.setEcmFolder(caseHeader.getEcmFolder());
        caseHeaderClone.setEndDate(caseHeader.getEndDate());
        caseHeaderClone.setExpirationDate(caseHeader.getExpirationDate());
        caseHeaderClone.setIdentificationKey(caseHeader.getIdentificationKey());
        caseHeaderClone.setInvokedComponent(caseHeader.getInvokedComponent());
        caseHeaderClone.setOutcome(caseHeader.getOutcome());
        caseHeaderClone.setOutcomeDisplayName(caseHeader.getOutcomeDisplayName());
        caseHeaderClone.setParentComponentInstanceId(caseHeader.getParentComponentInstanceId());
        caseHeaderClone.setParentComponentInstRefId(caseHeader.getParentComponentInstRefId());
        caseHeaderClone.setPriority(caseHeader.getPriority());
        caseHeaderClone.setState(caseHeader.getState());
        caseHeaderClone.setStateDisplayName(caseHeader.getStateDisplayName());
        caseHeaderClone.setTenantId(caseHeader.getTenantId());
        caseHeaderClone.setTitle(caseHeader.getTitle());
        caseHeaderClone.setUserActions(CaseObjectUtil.getUserActionsClone(caseHeader.getUserActions()));
        caseHeaderClone.setUserPermissions(CaseObjectUtil.getUserPermissionsClone(caseHeader.getUserPermissions()));
        return caseHeaderClone;
    }

    public static CompletedCaseActivityList getCompletedCaseActivityListClone(CompletedCaseActivityList completedCaseActivityList) {
        CompletedCaseActivityList completedCaseActivityListClone = new CompletedCaseActivityList();
        ArrayList<CompletedCaseActivity> completedCaseActivitiesClone = new ArrayList<CompletedCaseActivity>();
        completedCaseActivityListClone.setCompletedCaseActivity(completedCaseActivitiesClone);
        if (completedCaseActivityList != null && completedCaseActivityList.getCompletedCaseActivity() != null && completedCaseActivityList.getCompletedCaseActivity().size() > 0) {
            for (CompletedCaseActivity completedCaseActivity : completedCaseActivityList.getCompletedCaseActivity()) {
                CompletedCaseActivity completedCaseActivityClone = new CompletedCaseActivity();
                completedCaseActivityClone.setName(completedCaseActivity.getName());
                completedCaseActivitiesClone.add(completedCaseActivityClone);
            }
        }
        return completedCaseActivityListClone;
    }

    public static UserActions getUserActionsClone(UserActions userActions) {
        UserActions userActionsClone = new UserActions();
        HashSet<ActionsPermittedForCaseObject> actionsPermittedForCaseObjectClone = new HashSet<ActionsPermittedForCaseObject>();
        userActionsClone.setActionsPermittedForCaseObject(actionsPermittedForCaseObjectClone);
        if (userActions != null && userActions.getActionsPermittedForCaseObject() != null && userActions.getActionsPermittedForCaseObject().size() > 0) {
            Iterator<ActionsPermittedForCaseObject> iterator = userActions.getActionsPermittedForCaseObject().iterator();
            while (iterator.hasNext()) {
                actionsPermittedForCaseObjectClone.add(iterator.next());
            }
        }
        return userActionsClone;
    }

    public static UserPermissions getUserPermissionsClone(UserPermissions userPermissions) {
        UserPermissions userPermissionsClone = new UserPermissions();
        HashSet<CaseObjectPermission> caseObjectPermissionClone = new HashSet<CaseObjectPermission>();
        userPermissionsClone.setCaseObjectPermission(caseObjectPermissionClone);
        if (userPermissions != null && userPermissions.getCaseObjectPermission() != null && userPermissions.getCaseObjectPermission().size() > 0) {
            Iterator<CaseObjectPermission> iterator = userPermissions.getCaseObjectPermission().iterator();
            while (iterator.hasNext()) {
                caseObjectPermissionClone.add(iterator.next());
            }
        }
        return userPermissionsClone;
    }

    public static CaseStakeHolder getCaseStakeHolderClone(Case caseClone, CaseStakeHolder caseStakeHolder) throws CaseServiceException {
        CaseStakeHolder caseStakeHolderClone = new CaseStakeHolder();
        CaseObjectUtil.copy(caseClone, caseStakeHolder, caseStakeHolderClone);
        caseStakeHolderClone.setApplicationContext(caseStakeHolder.getApplicationContext());
        caseStakeHolderClone.setIsContextUserInRole(caseStakeHolder.getIsContextUserInRole());
        caseStakeHolderClone.setPermissionMemberRole(caseStakeHolderClone.getPermissionMemberRole());
        caseStakeHolderClone.setComment(CaseObjectUtil.getCommentClone(caseClone, caseStakeHolder.getComment()));
        ArrayList<CaseStakeHolderMember> caseStakeHolderMembersClone = new ArrayList<CaseStakeHolderMember>();
        caseStakeHolderClone.setCaseStakeHolderMembers(caseStakeHolderMembersClone);
        if (caseStakeHolder.getCaseStakeHolderMembers() != null && caseStakeHolder.getCaseStakeHolderMembers().size() > 0) {
            for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolder.getCaseStakeHolderMembers()) {
                caseStakeHolderMembersClone.add(CaseObjectUtil.getCaseStakeHolderMemberClone(caseStakeHolderMember, caseStakeHolderClone));
            }
        }
        return caseStakeHolderClone;
    }

    public static CaseFabricHeaderProperty getCaseFabricHeaderPropertyClone(Case caseClone, CaseFabricHeaderProperty caseFabricHeaderProperty) {
        CaseFabricHeaderProperty caseFabricHeaderPropertyClone = new CaseFabricHeaderProperty();
        caseFabricHeaderPropertyClone.setCase(caseClone);
        if (caseFabricHeaderProperty != null) {
            caseFabricHeaderPropertyClone.setCompositeCreatedTime(caseFabricHeaderProperty.getCompositeCreatedTime());
            caseFabricHeaderPropertyClone.setProperties(caseFabricHeaderProperty.getProperties());
        }
        return caseFabricHeaderPropertyClone;
    }

    public static CaseStakeHolderMember getCaseStakeHolderMemberClone(CaseStakeHolderMember caseStakeHolderMember, CaseStakeHolder caseStakeHolderClone) throws CaseServiceException {
        CaseStakeHolderMember caseStakeHolderMemberClone = new CaseStakeHolderMember();
        caseStakeHolderMemberClone.setApplicationContext(caseStakeHolderMember.getApplicationContext());
        caseStakeHolderMemberClone.setIsContextUserInRole(caseStakeHolderMember.getIsContextUserInRole());
        caseStakeHolderMemberClone.setId(caseStakeHolderMember.getId());
        caseStakeHolderMemberClone.setStakeHolder(caseStakeHolderMember.getStakeHolder());
        caseStakeHolderMemberClone.setStakeHolderDisplayName(caseStakeHolderMember.getStakeHolderDisplayName());
        caseStakeHolderMemberClone.setCaseStakeHolder(caseStakeHolderClone);
        caseStakeHolderMemberClone.setStakeHolderType(caseStakeHolderMember.getStakeHolderType());
        return caseStakeHolderMemberClone;
    }

    public static CaseData getCaseDataClone(Case caseClone, CaseData caseData) throws CaseServiceException {
        if (caseData == null) {
            return null;
        }
        CaseData caseDataClone = new CaseData();
        CaseObjectUtil.copy(caseClone, caseData, caseDataClone);
        caseDataClone.setCaseDataFormUrl(caseData.getCaseDataFormUrl());
        caseDataClone.setCaseDataType(caseData.getCaseDataType());
        caseDataClone.setData(caseData.getData());
        caseDataClone.setExternal(caseData.getExternal());
        caseDataClone.setSimpleType(caseData.isSimpleType());
        caseDataClone.setState(caseData.getState());
        caseDataClone.setComment(CaseObjectUtil.getCommentClone(caseClone, caseData.getComment()));
        return caseDataClone;
    }

    public static CaseMilestone getCaseMilestoneClone(Case caseClone, CaseMilestone caseMilestone) throws CaseServiceException {
        CaseMilestone caseMilestoneClone = new CaseMilestone();
        CaseObjectUtil.copy(caseClone, caseMilestone, caseMilestoneClone);
        caseMilestoneClone.setState(caseMilestone.getState());
        caseMilestoneClone.setComment(CaseObjectUtil.getCommentClone(caseClone, caseMilestone.getComment()));
        return caseMilestoneClone;
    }

    public static Comment getCommentClone(Case caseClone, Comment comment) throws CaseServiceException {
        Comment commentClone = null;
        if (comment != null) {
            commentClone = new Comment();
            commentClone.setCase(caseClone);
            CaseObjectUtil.copy(caseClone, comment, commentClone);
            commentClone.setCaseObjectComment(comment.getCaseObjectComment());
            commentClone.setCaseObjectId(comment.getCaseObjectId());
            commentClone.setCaseObjectType(comment.getCaseObjectType());
            commentClone.setIsSystemComment(comment.getIsSystemComment());
        }
        return commentClone;
    }

    private static void removeNullChildrens(List list) {
        if (list != null && list.size() > 0) {
            while (CaseObjectUtil.removeFirstNullChildren(list)) {
            }
        }
    }

    private static boolean removeFirstNullChildren(List list) {
        for (int index = 0; index < list.size(); ++index) {
            Object item = list.get(index);
            if (item != null) continue;
            list.remove(index);
            return true;
        }
        return false;
    }

    private static void copy(Case caseClone, CaseObject fromCaseObject, CaseObject toCaseObject) throws CaseServiceException {
        if (fromCaseObject == null || toCaseObject == null) {
            return;
        }
        toCaseObject.setCase(caseClone);
        toCaseObject.setId(fromCaseObject.getId());
        toCaseObject.setObjectName(fromCaseObject.getObjectName());
        toCaseObject.setObjectDisplayName(fromCaseObject.getObjectDisplayName());
        toCaseObject.setObjectType(fromCaseObject.getObjectType());
        toCaseObject.setPermissionTag(fromCaseObject.getPermissionTag());
        toCaseObject.setPermissionTagDisplayName(fromCaseObject.getPermissionTagDisplayName());
        toCaseObject.setUpdatedBy(fromCaseObject.getUpdatedBy());
        toCaseObject.setUpdatedByDisplayName(fromCaseObject.getUpdatedByDisplayName());
        toCaseObject.setUpdatedDate(fromCaseObject.getUpdatedDate());
        ArrayList<String> actionsClone = new ArrayList<String>();
        toCaseObject.setActions(actionsClone);
        if (fromCaseObject.getActions() != null && fromCaseObject.getActions().size() > 0) {
            for (String action : fromCaseObject.getActions()) {
                actionsClone.add(action);
            }
        }
    }

    static {
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}string", SimpleTypesEnum.STRING);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}int", SimpleTypesEnum.INT);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}long", SimpleTypesEnum.LONG);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}boolean", SimpleTypesEnum.BOOLEAN);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}decimal", SimpleTypesEnum.DECIMAL);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}double", SimpleTypesEnum.DOUBLE);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}dateTime", SimpleTypesEnum.DATETIME);
        typeToEnumMap.put("{http://www.w3.org/2001/XMLSchema}duration", SimpleTypesEnum.DURATION);
    }
}

