/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.persistence.model.BaseCaseObject;
import oracle.bpm.casemgmt.persistence.model.Case;

@DiscriminatorColumn(name="OBJECT_TYPE", discriminatorType=DiscriminatorType.STRING)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@NamedQueries(value={@NamedQuery(name="CaseObject.findAll", query="select o from CaseObject o"), @NamedQuery(name="CaseObject.findById", query="select o from CaseObject o where o.id= :id"), @NamedQuery(name="CaseObject.deleteAll", query="delete from CaseObject")})
@Table(name="CM_CASE_OBJECT")
public abstract class CaseObject
extends BaseCaseObject
implements Serializable {
    @Column(name="CASE_ID", insertable=false, updatable=false)
    protected String case_id;
    @Transient
    private List<String> actions;
    @JoinColumn(name="CASE_ID")
    @ManyToOne
    private Case caseInstance;
    @Id
    private String id;
    private String object_display_name;
    private String object_name;
    private String object_type;
    private String permission_tag;
    @Transient
    private String permission_tag_display_name;
    private String updated_by;
    private String updated_by_display_name;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar updated_date;
    public static final String ID = "id";
    public static final String CASE_ID = "case_id";
    public static final String OBJECT_NAME = "object_name";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObjectName() {
        return this.object_name;
    }

    public void setObjectName(String object_name) {
        this.object_name = object_name;
    }

    public String getCaseId() {
        return this.case_id;
    }

    public void setCaseId(String case_id) {
        this.case_id = case_id;
    }

    public String getObjectType() {
        return this.object_type;
    }

    public void setObjectType(String object_type) {
        this.object_type = object_type;
    }

    public String getObjectDisplayName() {
        return this.object_display_name;
    }

    public void setObjectDisplayName(String object_display_name) {
        this.object_display_name = object_display_name;
    }

    public String getUpdatedBy() {
        return this.updated_by;
    }

    public void setUpdatedBy(String updated_by) {
        this.updated_by = updated_by;
    }

    public String getUpdatedByDisplayName() {
        return this.updated_by_display_name;
    }

    public void setUpdatedByDisplayName(String updated_by_display_name) {
        this.updated_by_display_name = updated_by_display_name;
    }

    public Calendar getUpdatedDate() {
        return this.updated_date;
    }

    public void setUpdatedDate(Calendar updated_date) {
        this.updated_date = updated_date;
    }

    public String getPermissionTag() {
        return this.permission_tag;
    }

    public void setPermissionTag(String permission_tag) {
        this.permission_tag = permission_tag;
    }

    public String getPermissionTagDisplayName() {
        return this.permission_tag_display_name;
    }

    public void setPermissionTagDisplayName(String permission_tag_display_name) {
        this.permission_tag_display_name = permission_tag_display_name;
    }

    @PostLoad
    @PostUpdate
    public void computerPermissionTagDisplayName() {
        if (this.permission_tag != null) {
            this.permission_tag_display_name = CaseExceptionUtil.lookupKeyFromCaseBundleInDefaultLocale(this.permission_tag);
        }
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public Case getCase() {
        return this.caseInstance;
    }

    public void setCase(Case caseInstance) {
        this.caseInstance = caseInstance;
        if (caseInstance != null) {
            this.setCaseId(caseInstance.getCaseId());
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        prefix = prefix == null ? "\n" : "\n" + prefix;
        StringBuffer caseObjectAsAString = new StringBuffer();
        caseObjectAsAString.append(prefix + "\tId:" + this.getId());
        caseObjectAsAString.append(prefix + "\tCaseId:" + this.getCaseId());
        caseObjectAsAString.append(prefix + "\tObjectName:" + this.getObjectName());
        caseObjectAsAString.append(prefix + "\tObjectDisplayName:" + this.getObjectDisplayName());
        caseObjectAsAString.append(prefix + "\tObjectType:" + this.getObjectType());
        caseObjectAsAString.append(prefix + "\tPermissionTag:" + this.getPermissionTag());
        caseObjectAsAString.append(prefix + "\tUpdatedBy:" + this.getUpdatedBy());
        caseObjectAsAString.append(prefix + "\tUpdatedByDisplayName:" + this.getUpdatedByDisplayName());
        caseObjectAsAString.append(prefix + "\tUpdatedDate:" + this.getUpdatedDate());
        return caseObjectAsAString.toString();
    }
}

