/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CompletedCaseActivityList;
import oracle.bpm.casemgmt.persistence.model.UserActions;
import oracle.bpm.casemgmt.persistence.model.UserPermissions;

@DiscriminatorValue(value="CASE")
@Entity
@Table(name="CM_CASE_HEADER")
public class CaseHeader
extends CaseObject
implements Serializable {
    @Column(name="APPLICATION_NAME", length=200)
    private String applicationName;
    @Column(name="CASE_DEFINITION_ID", nullable=false, length=200)
    private String caseDefinitionId;
    @Column(name="CASE_DEFINITION_NAME", nullable=false, length=200)
    private String caseDefinitionName;
    @Column(name="CASE_NAMESPACE", nullable=false, length=200)
    private String caseNamespace;
    @Column(name="CASE_NUMBER", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="TABLE_GEN")
    @TableGenerator(name="TABLE_GEN", table="CM_SEQUENCE_TABLE", pkColumnName="SEQUENCE_NAME", valueColumnName="SEQUENCE_COUNT", pkColumnValue="CASE_NUMBER", allocationSize=1)
    private Long caseNumber;
    @Transient
    private String caseSummaryFormURI;
    @Column(name="CATEGORY", length=400)
    private String category;
    @Column(name="CATEGORY_DISPLAY_NAME", length=800)
    private String categoryDisplayName;
    @Transient
    private CompletedCaseActivityList completedCaseActivityList;
    @Column(name="COMPONENT_NAME", length=500)
    private String componentName;
    @Column(name="COMPOSITE_CREATED_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar compositeCreatedTime;
    @Column(name="COMPOSITE_DN", length=500)
    private String compositeDn;
    @Column(name="COMPOSITE_INSTANCE_ID", length=200)
    private String compositeInstanceId;
    @Column(name="COMPOSITE_NAME", length=200)
    private String compositeName;
    @Column(name="COMPOSITE_VERSION", length=200)
    private String compositeVersion;
    @Column(name="CONVERSATION_ID", length=200)
    private String conversationId;
    @Column(name="CREATED_BY", length=400)
    private String createdBy;
    @Column(name="CREATED_BY_DISPLAY_NAME", length=400)
    private String createdByDisplayName;
    @Column(name="CREATED_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar createdDate;
    @Column(name="DUE_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dueDate;
    @Column(length=200)
    private String ecid;
    @Column(name="ECM_FOLDER", length=2000)
    private String ecmFolder;
    @Column(name="END_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar endDate;
    @Column(name="EXPIRATION_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar expirationDate;
    @Column(name="IDENTIFICATION_KEY", length=100)
    private String identificationKey;
    @Column(name="INVOKED_COMPONENT", length=500)
    private String invokedComponent;
    @Column(name="OUTCOME", length=400)
    private String outcome;
    @Column(name="OUTCOME_DISPLAY_NAME", length=800)
    private String outcomeDisplayName;
    @Column(name="PARENT_COMPONENT_INSTANCE_ID", length=200)
    private String parentComponentInstanceId;
    @Column(name="PARENT_COMPONENT_INST_REF_ID", length=200)
    private String parentComponentInstRefId;
    private int priority;
    @Column(length=100)
    private String state;
    @Column(name="STATE_DISPLAY_NAME", length=400)
    private String stateDisplayName;
    @Column(name="TENANT_ID")
    private Long tenantId;
    @Column(length=500)
    private String title;
    @Transient
    private UserActions userActions;
    @Transient
    private UserPermissions userPermissions;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    public String getCaseNamespace() {
        return this.caseNamespace;
    }

    public void setCaseNamespace(String caseNamespace) {
        this.caseNamespace = caseNamespace;
    }

    public Long getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(Long caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getCompositeDn() {
        return this.compositeDn;
    }

    public void setCompositeDn(String compositeDn) {
        this.compositeDn = compositeDn;
    }

    public String getCompositeInstanceId() {
        return this.compositeInstanceId;
    }

    public void setCompositeInstanceId(String compositeInstanceId) {
        this.compositeInstanceId = compositeInstanceId;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public void setCompositeName(String compositeName) {
        this.compositeName = compositeName;
    }

    public String getCompositeVersion() {
        return this.compositeVersion;
    }

    public void setCompositeVersion(String compositeVersion) {
        this.compositeVersion = compositeVersion;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedByDisplayName() {
        return this.createdByDisplayName;
    }

    public void setCreatedByDisplayName(String createdByDisplayName) {
        this.createdByDisplayName = createdByDisplayName;
    }

    public Calendar getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Calendar createdDate) {
        this.createdDate = createdDate;
    }

    public Calendar getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Calendar dueDate) {
        this.dueDate = dueDate;
    }

    public String getEcid() {
        return this.ecid;
    }

    public void setEcid(String ecid) {
        this.ecid = ecid;
    }

    public String getEcmFolder() {
        return this.ecmFolder;
    }

    public void setEcmFolder(String ecmFolder) {
        this.ecmFolder = ecmFolder;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryDisplayName() {
        return this.categoryDisplayName;
    }

    public void setCategoryDisplayName(String categoryDisplayName) {
        this.categoryDisplayName = categoryDisplayName;
    }

    public String getIdentificationKey() {
        return this.identificationKey;
    }

    public void setIdentificationKey(String identificationKey) {
        this.identificationKey = identificationKey;
    }

    public String getInvokedComponent() {
        return this.invokedComponent;
    }

    public void setInvokedComponent(String invokedComponent) {
        this.invokedComponent = invokedComponent;
    }

    public String getParentComponentInstanceId() {
        return this.parentComponentInstanceId;
    }

    public void setParentComponentInstanceId(String parentComponentInstanceId) {
        this.parentComponentInstanceId = parentComponentInstanceId;
    }

    public String getParentComponentInstRefId() {
        return this.parentComponentInstRefId;
    }

    public void setParentComponentInstRefId(String parentComponentInstRefId) {
        this.parentComponentInstRefId = parentComponentInstRefId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateDisplayName() {
        return this.stateDisplayName;
    }

    public void setStateDisplayName(String stateDisplayName) {
        this.stateDisplayName = stateDisplayName;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCompositeCreatedTime(Calendar compositeCreatedTime) {
        this.compositeCreatedTime = compositeCreatedTime;
    }

    public Calendar getCompositeCreatedTime() {
        return this.compositeCreatedTime;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcomeDisplayName(String outcomeDisplayName) {
        this.outcomeDisplayName = outcomeDisplayName;
    }

    public String getOutcomeDisplayName() {
        return this.outcomeDisplayName;
    }

    public UserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    public void setUserPermissions(UserPermissions userPermissions) {
        this.userPermissions = userPermissions;
    }

    public UserActions getUserActions() {
        return this.userActions;
    }

    public void setUserActions(UserActions userActions) {
        this.userActions = userActions;
    }

    public String getCaseSummaryFormURI() {
        return this.caseSummaryFormURI;
    }

    public void setCaseSummaryFormURI(String caseSummaryFormURI) {
        this.caseSummaryFormURI = caseSummaryFormURI;
    }

    public CompletedCaseActivityList getCompletedCaseActivityList() {
        return this.completedCaseActivityList;
    }

    public void setCompletedCaseActivityList(CompletedCaseActivityList completedCaseActivityList) {
        this.completedCaseActivityList = completedCaseActivityList;
    }

    @Override
    public String toString(String prefix) {
        String caseHeaderPrefix = prefix == null ? "\n" : "\n" + prefix;
        StringBuffer caseHeaderAsAString = new StringBuffer(caseHeaderPrefix + "CaseHeader");
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseId:" + this.getCaseId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseNumber:" + this.getCaseNumber());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseName:" + this.getObjectName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseDisplayName:" + this.getObjectDisplayName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tTitle:" + this.getTitle());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tPriority:" + this.getPriority());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCreatedDate:" + this.getCreatedDate());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tEndDate:" + this.getEndDate());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tExpirationDate:" + this.getExpirationDate());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tState:" + this.getState());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCreatedBy:" + this.getCreatedBy());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCreatedByDisplayName:" + this.getCreatedByDisplayName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseDefinitionId:" + this.getCaseDefinitionId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseDefinitionName:" + this.getCaseDefinitionName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCaseNamespace:" + this.getCaseNamespace());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tIdentificationKey:" + this.getIdentificationKey());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCategory:" + this.getCategory());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCategoryDisplayName:" + this.getCategoryDisplayName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tApplicationName:" + this.getApplicationName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tComponentName:" + this.getComponentName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCompositeDN:" + this.getCompositeDn());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCompositeInstanceId:" + this.getCompositeInstanceId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCompositeName:" + this.getCompositeName());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCompositeVersion:" + this.getCompositeVersion());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tEcid:" + this.getEcid());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tParentComponentInstanceId:" + this.getParentComponentInstanceId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tParentComponentInstRefId:" + this.getParentComponentInstRefId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tInvokedComponent:" + this.getInvokedComponent());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tTenantId:" + this.getTenantId());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tCompositeCreatedTime:" + this.getCompositeCreatedTime());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tOutcome:" + this.getOutcome());
        caseHeaderAsAString.append(caseHeaderPrefix + "\tOutcomeDisplayName:" + this.getOutcomeDisplayName());
        caseHeaderAsAString.append(super.toString(prefix));
        return caseHeaderAsAString.toString();
    }
}

