/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.util.Calendar;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.metadata.event.model.TDocumentEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.metadata.event.model.TLifecycleEvent;
import oracle.bpm.casemgmt.metadata.event.model.TMilestoneEvent;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.PropertyBag;
import oracle.bpm.casemgmt.task.model.TaskInfo;
import oracle.bpm.casemgmt.util.TaskQueryUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

@DiscriminatorValue(value="EVENT")
@Entity
@NamedQueries(value={@NamedQuery(name="CaseEvent.findAll", query="select o from CaseEvent o"), @NamedQuery(name="CaseEvent.findByCaseId", query="select o from CaseEvent o where o.case_id= :case_id"), @NamedQuery(name="CaseEvent.deleteAll", query="delete from CaseEvent")})
@Table(name="CM_CASE_EVENT")
public class CaseEvent
extends CaseObject
implements Cloneable {
    @Enumerated(value=EnumType.STRING)
    private TActivityEvent activity_event;
    private String activity_id;
    private String activity_name;
    private String activity_type;
    @Transient
    private String caseName;
    @JoinColumn(name="COMMENT_ID", nullable=true, insertable=true, updatable=true)
    @OneToOne(targetEntity=Comment.class, fetch=FetchType.EAGER)
    private Comment comment;
    @Transient
    private String commentEventComment;
    @Transient
    private boolean commentShared = true;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar completed_date;
    private String data_name;
    @Enumerated(value=EnumType.STRING)
    private TDocumentEvent document_event;
    private String document_id;
    private String document_name;
    private String document_version;
    @Enumerated(value=EnumType.STRING)
    private TEventType event_type;
    @Transient
    private String identificationKey;
    @Enumerated(value=EnumType.STRING)
    private TLifecycleEvent lifecycle_event;
    private String lifecycle_state;
    private String milestone;
    @Enumerated(value=EnumType.STRING)
    private TMilestoneEvent milestone_event;
    @OneToMany(mappedBy="caseEvent", cascade={CascadeType.PERSIST})
    private Collection<PropertyBag> propertyBagCollection;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar started_date;
    @Transient
    private TaskInfo taskInfo;
    private String user_defined_event;

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void setTaskInfo(IBPMContext context) {
        String rootTaskId = this.getActivityId();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_EVENT, Severity.DEBUG, "setTaskInfo(): activity_name: " + this.activity_name + ", activityId: " + rootTaskId + ", activity_type: " + this.activity_type + ", contextUser: " + (context != null ? context.getUser() : "nullContext"));
        if ("HWF".equals(this.activity_type) && context != null && rootTaskId != null) {
            this.taskInfo = TaskQueryUtil.getTaskAssignees(context, rootTaskId, this.activity_type);
        }
    }

    public TActivityEvent getActivityEvent() {
        return this.activity_event;
    }

    public void setActivityEvent(TActivityEvent activity_event) {
        this.activity_event = activity_event;
    }

    public String getActivityId() {
        return this.activity_id;
    }

    public void setActivityId(String activity_id) {
        this.activity_id = activity_id;
    }

    public String getActivityName() {
        return this.activity_name;
    }

    public void setActivityName(String activity_name) {
        this.activity_name = activity_name;
    }

    public String getActivityType() {
        return this.activity_type;
    }

    public void setActivityType(String activity_type) {
        this.activity_type = activity_type;
    }

    public Calendar getStartedDate() {
        return this.started_date;
    }

    public void setStartedDate(Calendar started_date) {
        this.started_date = started_date;
    }

    public Calendar getCompletedDate() {
        return this.completed_date;
    }

    public void setCompletedDate(Calendar completed_date) {
        this.completed_date = completed_date;
    }

    public String getEventId() {
        return this.getId();
    }

    public void setEventId(String event_id) {
        this.setId(event_id);
    }

    public TEventType getEventType() {
        return this.event_type;
    }

    public void setEventType(TEventType event_type) {
        this.event_type = event_type;
    }

    public TLifecycleEvent getLifecycleEvent() {
        return this.lifecycle_event;
    }

    public void setLifecycleEvent(TLifecycleEvent lifecycle_event) {
        this.lifecycle_event = lifecycle_event;
    }

    public String getLifecycleState() {
        return this.lifecycle_state;
    }

    public void setLifecycleState(String lifecycle_state) {
        this.lifecycle_state = lifecycle_state;
    }

    public Collection<PropertyBag> getPropertyBagCollection() {
        return this.propertyBagCollection;
    }

    public void setPropertyBagCollection(Collection<PropertyBag> propertyBagCollection) {
        this.propertyBagCollection = propertyBagCollection;
    }

    public PropertyBag addPropertyBag(PropertyBag propertyBag) {
        this.getPropertyBagCollection().add(propertyBag);
        propertyBag.setCaseEvent(this);
        return propertyBag;
    }

    public PropertyBag removePropertyBag(PropertyBag propertyBag) {
        this.getPropertyBagCollection().remove(propertyBag);
        propertyBag.setCaseEvent(null);
        return propertyBag;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setCommentEventComment(String commentEventComment) {
        this.commentEventComment = commentEventComment;
    }

    public String getCommentEventComment() {
        return this.commentEventComment;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public TMilestoneEvent getMilestoneEvent() {
        return this.milestone_event;
    }

    public void setMilestoneEvent(TMilestoneEvent milestone_event) {
        this.milestone_event = milestone_event;
    }

    public TDocumentEvent getDocumentEvent() {
        return this.document_event;
    }

    public void setDocumentEvent(TDocumentEvent document_event) {
        this.document_event = document_event;
    }

    public String getDocumentId() {
        return this.document_id;
    }

    public void setDocumentId(String document_id) {
        this.document_id = document_id;
    }

    public String getDocumentName() {
        return this.document_name;
    }

    public void setDocumentName(String document_name) {
        this.document_name = document_name;
    }

    public String getDocumentVersion() {
        return this.document_version;
    }

    public void setDocumentVersion(String document_version) {
        this.document_version = document_version;
    }

    public String getDataName() {
        return this.data_name;
    }

    public void setDataName(String data_name) {
        this.data_name = data_name;
    }

    public String getUserDefinedEvent() {
        return this.user_defined_event;
    }

    public void setUserDefinedEvent(String user_defined_event) {
        this.user_defined_event = user_defined_event;
    }

    public String getActivityDefinitionId() {
        return this.getObjectName();
    }

    public String getActivityCorrelationId() {
        return this.document_id;
    }

    public boolean isCommentShared() {
        return this.commentShared;
    }

    public void setCommentShared(boolean commentShared) {
        this.commentShared = commentShared;
    }

    public void setIdentificationKey(String identificationKey) {
        this.identificationKey = identificationKey;
    }

    public String getIdentificationKey() {
        return this.identificationKey;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public String getCaseName() {
        return this.caseName;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("eventType: " + (Object)((Object)this.event_type));
        sb.append(", identificationKey: " + this.identificationKey);
        sb.append(", caseName: " + this.caseName);
        sb.append(", comment: " + this.comment);
        switch (this.event_type) {
            case ACTIVITY_EVENT: {
                sb.append(", activity_event: " + this.activity_event.value());
                sb.append(", activity_id: " + this.activity_id);
                sb.append(", activity_name: " + this.activity_name);
                sb.append(", activity_type: " + this.activity_type);
                if (this.taskInfo == null) break;
                sb.append(", " + this.taskInfo.toString());
                break;
            }
            case COMMENT_EVENT: {
                break;
            }
            case DOCUMENT_EVENT: {
                sb.append(", document_event: " + this.document_event.value());
                sb.append(", document_id: " + this.document_id);
                sb.append(", document_name: " + this.document_name);
                sb.append(", document_version: " + this.document_version);
                break;
            }
            case LIFECYCLE_EVENT: {
                sb.append(", lifecycle_event: " + this.lifecycle_event.value());
                sb.append(", lifecycle_state: " + this.lifecycle_state);
                break;
            }
            case MILESTONE_EVENT: {
                sb.append(", milestone: " + this.milestone);
                sb.append(", milestone_event: " + (Object)((Object)this.milestone_event));
                break;
            }
            case USER_DEFINED_EVENT: {
                sb.append(", user_defined_event: " + this.user_defined_event);
                break;
            }
            case DATA_UPLOAD_EVENT: {
                sb.append(", data_upload_event: " + this.data_name);
                break;
            }
        }
        return sb + ", " + super.toString();
    }

    public CaseEvent clone() throws CloneNotSupportedException {
        return (CaseEvent)super.clone();
    }
}

