/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseDataHandler
implements DomHandler<String, StreamResult> {
    private static final String CASENS = " xmlns:casens=\"http://xmlns.oracle.com/bpm/case\" ";
    private static final String DATA_START_TAG = "<casens:data";
    private static final String DATA_END_TAG = "</casens:data";
    private static final String XML_CLOSING_TAG = ">";
    private static Pattern patern = Pattern.compile("(\\s*<\\s*/\\s*([0-9A-Za-z]+):data\\s*>)$");

    public StreamResult createUnmarshaller(ValidationEventHandler errorHandler) {
        return new StreamResult(new StringWriter());
    }

    public String getElement(StreamResult streamResult) {
        int beginIndex;
        String xml = streamResult.getWriter().toString();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "[CaseDataHandler] xml:" + xml);
        if (xml == null || xml.trim().length() == 0) {
            return "";
        }
        if (xml != null && xml.startsWith("<?xml ")) {
            int index = xml.indexOf(XML_CLOSING_TAG);
            xml = xml.substring(index + 1);
        }
        if ((beginIndex = xml.indexOf(XML_CLOSING_TAG)) == -1) {
            return xml;
        }
        ++beginIndex;
        String[] result = patern.split(xml);
        if (result.length == 1) {
            String withoutEndTag = result[0];
            String extractedXml = withoutEndTag.substring(beginIndex);
            CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "[CaseDataHandler] extractedXml:" + extractedXml);
            return extractedXml;
        }
        return xml;
    }

    public Source marshal(String data, ValidationEventHandler errorHandler) {
        try {
            if (data == null) {
                data = "";
            }
            CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, "[CaseDataHandler] data:" + data);
            String xml = "<casens:data xmlns:casens=\"http://xmlns.oracle.com/bpm/case\" >" + data.trim() + DATA_END_TAG + XML_CLOSING_TAG;
            StringReader xmlReader = new StringReader(xml);
            return new StreamSource(xmlReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

