/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.casemgmt.SimpleTypesEnum;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@DiscriminatorValue(value="DATA")
@Entity
@NamedQueries(value={@NamedQuery(name="CaseData.findAll", query="select caseData from CaseData caseData"), @NamedQuery(name="CaseData.findByCaseDataName", query="select caseData from CaseData caseData LEFT JOIN FETCH caseData.comment where caseData.object_name= :caseDataName and caseData.case_id = :case_id"), @NamedQuery(name="CaseData.findByCaseId", query="select caseData from CaseData caseData LEFT JOIN FETCH caseData.comment where caseData.case_id = :case_id order by caseData.object_name ASC")})
@Table(name="CM_CASE_DATA")
public class CaseData
extends CaseObject
implements Serializable {
    @Transient
    private String caseDataFormUrl;
    @Transient
    private SimpleTypesEnum caseDataType;
    @JoinColumn(name="COMMENT_ID", insertable=true, updatable=true, nullable=true)
    @OneToOne(targetEntity=Comment.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Comment comment;
    @Column(name="DATA", nullable=false, insertable=true, updatable=true)
    @Lob
    private String data;
    @Transient
    private boolean external = false;
    @Transient
    private boolean isSimpleType = false;
    @Transient
    private ICaseConstants.CaseDataState state = ICaseConstants.CaseDataState.NOT_FETCHED;
    public static final String caseDataName = "caseDataName";

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        if (this.data != null && this.data.startsWith("<?xml ")) {
            int PI_end_idx = this.data.indexOf(">");
            this.data = this.data.substring(PI_end_idx + 1);
        }
        return this.data;
    }

    public Document fetchDataAsDOM() {
        try {
            DocumentBuilder builder = XMLUtil.getDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(this.data));
            Document document = builder.parse(inputSource);
            Document dataDomXml = XMLUtil.getDocumentBuilder().newDocument();
            Node importedDataNode = dataDomXml.importNode(document.getFirstChild(), true);
            dataDomXml.appendChild(importedDataNode);
            return dataDomXml;
        }
        catch (Exception e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.ERRORS, this.getClass().getName(), "fetchDataAsDOM", e);
            return null;
        }
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    public void setSimpleType(boolean isSimpleType) {
        this.isSimpleType = isSimpleType;
    }

    public SimpleTypesEnum getCaseDataType() {
        return this.caseDataType;
    }

    public void setCaseDataType(SimpleTypesEnum caseDataType) {
        this.caseDataType = caseDataType;
    }

    public String getCaseDataFormUrl() {
        return this.caseDataFormUrl;
    }

    public void setCaseDataFormUrl(String caseDataFormUrl) {
        this.caseDataFormUrl = caseDataFormUrl;
    }

    public Object getSimpleTypeDataValue() {
        Object value = null;
        String dataValue = null;
        if (this.isSimpleType) {
            try {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, this.getClass().getName(), "getSimpleTypeDataValue", "data  = " + this.data);
                dataValue = XMLUtil.parseDocumentFromXMLString((String)this.data).getDocumentElement().getTextContent();
                CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, this.getClass().getName(), "getSimpleTypeDataValue", "dataValue  = " + this.data);
                if (dataValue != null && dataValue.trim().length() > 0) {
                    switch (this.caseDataType) {
                        case STRING: {
                            value = dataValue;
                            break;
                        }
                        case INT: {
                            value = Integer.getInteger(dataValue);
                            break;
                        }
                        case LONG: {
                            value = Long.valueOf(dataValue);
                            break;
                        }
                        case BOOLEAN: {
                            value = Boolean.valueOf(dataValue);
                            break;
                        }
                        case DECIMAL: {
                            value = BigDecimal.valueOf(Double.valueOf(dataValue));
                            break;
                        }
                        case DOUBLE: {
                            value = Double.valueOf(dataValue);
                            break;
                        }
                        case DATETIME: {
                            value = DatatypeConverter.parseDateTime((String)dataValue);
                            break;
                        }
                        case DURATION: {
                            value = DatatypeFactory.newInstance().newDuration(dataValue);
                            break;
                        }
                        case SHORT: {
                            value = Short.valueOf(dataValue);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.ERRORS, this.getClass().getName(), "getSimpleTypeDataValue", e);
            }
        }
        CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.DEBUG, this.getClass().getName(), "getSimpleTypeDataValue", "returning object  = " + value);
        return value;
    }

    @Override
    public String toString(String prefix) {
        String caseDataPrefix = prefix == null ? "\n" : "\n" + prefix;
        StringBuffer caseDataAsAString = new StringBuffer(caseDataPrefix + "CaseData");
        caseDataAsAString.append(caseDataPrefix + "\tExternal:" + this.getExternal());
        caseDataAsAString.append(caseDataPrefix + "\tState:" + (Object)((Object)this.getState()));
        caseDataAsAString.append(caseDataPrefix + "\tData:" + this.getData());
        caseDataAsAString.append(super.toString(prefix));
        if (this.getComment() != null) {
            caseDataAsAString.append(this.getComment().toString((prefix != null ? prefix : "") + "\t"));
        }
        return caseDataAsAString.toString();
    }

    public boolean getExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public ICaseConstants.CaseDataState getState() {
        return this.state;
    }

    public void setState(ICaseConstants.CaseDataState state) {
        this.state = state;
    }
}

