/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import oracle.bpm.casemgmt.Case.model.CaseTranslation;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseFabricHeaderProperty;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

@Entity
@NamedQueries(value={@NamedQuery(name="Case.findAll", query="select o from Case o JOIN FETCH o.caseHeader"), @NamedQuery(name="Case.findByCaseId", query="select o from Case o JOIN FETCH o.caseHeader where o.caseId= :caseId"), @NamedQuery(name="Case.findByCaseNumber", query="select o from Case o JOIN FETCH o.caseHeader where o.caseHeader.caseNumber= :caseNumber"), @NamedQuery(name="Case.findByIdentificationKey", query="select o from Case o JOIN FETCH o.caseHeader where o.caseHeader.identificationKey= :identificationKey"), @NamedQuery(name="Case.deleteAllCases", query="delete from Case cascade")})
@Table(name="CM_CASE")
public class Case
implements Serializable {
    @OneToMany(targetEntity=CaseData.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @OrderBy(value=" object_name ASC")
    protected List<CaseData> caseDataList;
    @OneToOne(targetEntity=CaseFabricHeaderProperty.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    protected CaseFabricHeaderProperty caseFabricHeaderProperty;
    @OneToMany(targetEntity=CaseMilestone.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @OrderBy(value=" object_name ASC")
    protected List<CaseMilestone> caseMilestones;
    @OneToMany(targetEntity=CaseStakeHolder.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @OrderBy(value=" object_name ASC")
    protected List<CaseStakeHolder> caseStakeHolders;
    @OneToMany(targetEntity=CaseTranslation.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    protected List<CaseTranslation> caseTranslations;
    @OneToMany(targetEntity=Comment.class, mappedBy="caseInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @OrderBy(value=" updated_date DSC")
    protected List<Comment> comments;
    @Transient
    private List<String> actions;
    @OneToOne(targetEntity=CaseHeader.class, mappedBy="caseInstance", fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private CaseHeader caseHeader;
    @Column(name="CASE_ID", nullable=false)
    @Id
    private String caseId;
    public static final String CASEID = "caseId";

    public Case() {
    }

    public Case(CaseHeader caseHeader) {
        this.caseHeader = caseHeader;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public CaseHeader getCaseHeader() {
        return this.caseHeader;
    }

    public void setCaseHeader(CaseHeader caseHeader) {
        this.caseHeader = caseHeader;
    }

    public void setCaseMilestones(List<CaseMilestone> caseMilestones) {
        this.caseMilestones = caseMilestones;
    }

    public List<CaseMilestone> getCaseMilestones() {
        return this.caseMilestones;
    }

    public void setCaseStakeHolders(List<CaseStakeHolder> caseStakeHolders) {
        this.caseStakeHolders = caseStakeHolders;
    }

    public List<CaseStakeHolder> getCaseStakeHolders() {
        return this.caseStakeHolders;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void addComment(Comment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<Comment>();
        }
        this.comments.add(comment);
    }

    public List<CaseData> getCaseData() {
        return this.caseDataList;
    }

    public void setCaseData(List<CaseData> caseData) {
        this.caseDataList = caseData;
    }

    public void setCaseFabricHeaderProperty(CaseFabricHeaderProperty caseFabricHeaderProperty) {
        this.caseFabricHeaderProperty = caseFabricHeaderProperty;
    }

    public CaseFabricHeaderProperty getCaseFabricHeaderProperty() {
        return this.caseFabricHeaderProperty;
    }

    public String toString() {
        try {
            StringBuffer caseAsAString = new StringBuffer("\nCase");
            caseAsAString.append("\n\tCaseId:" + this.getCaseId());
            if (this.getCaseHeader() != null) {
                caseAsAString.append(this.getCaseHeader().toString("\t"));
            } else {
                caseAsAString.append("\n\tCaseHeader is null");
            }
            if (this.getCaseFabricHeaderProperty() != null) {
                caseAsAString.append("\n\tCaseFabricHeaderProperty.CompositeCreatedTime:" + this.getCaseFabricHeaderProperty().getCompositeCreatedTime());
                if (this.getCaseFabricHeaderProperty().getProperties() == null) {
                    caseAsAString.append("\n\tCaseFabricHeaderProperty.Properties is NULL");
                } else {
                    String fabricHeaderProperties = new String(this.getCaseFabricHeaderProperty().getProperties());
                    caseAsAString.append("\n\tCaseFabricHeaderProperty.Properties has content");
                }
            } else {
                caseAsAString.append("\n\tCaseFabricHeaderProperty is NULL");
            }
            if (this.getCaseMilestones() != null && !this.getCaseMilestones().isEmpty()) {
                for (CaseMilestone caseMilestone : this.getCaseMilestones()) {
                    if (caseMilestone == null) continue;
                    caseAsAString.append(caseMilestone.toString("\t"));
                }
            }
            if (this.getCaseStakeHolders() != null && !this.getCaseStakeHolders().isEmpty()) {
                for (CaseStakeHolder caseStakeHolder : this.getCaseStakeHolders()) {
                    if (caseStakeHolder == null) continue;
                    caseAsAString.append(caseStakeHolder.toString("\t"));
                }
            }
            if (this.getCaseData() != null && !this.getCaseData().isEmpty()) {
                for (CaseData caseData : this.getCaseData()) {
                    if (caseData == null) continue;
                    caseAsAString.append(caseData.toString("\t"));
                }
            }
            if (this.getComments() != null && !this.getComments().isEmpty()) {
                for (Comment comment : this.getComments()) {
                    if (comment == null) continue;
                    caseAsAString.append(comment.toString("\t"));
                }
            }
            return caseAsAString.toString();
        }
        catch (Exception e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_INSTANCE, Severity.ERRORS, this.getClass().getName(), "toString", e);
            return null;
        }
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }
}

