/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.common.exception;

import java.io.Serializable;
import java.util.Locale;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;

public abstract class AbstractCaseException
extends Exception
implements Serializable {
    private Object[] arguments;
    private int errorCode;
    private Locale locale;
    private String message;

    public AbstractCaseException(int errorCode, Object[] arguments) {
        this.errorCode = errorCode;
        this.arguments = arguments;
        this.message = new CaseExceptionUtil().getDisplayMessage(errorCode, arguments);
    }

    public AbstractCaseException(int errorCode, Object[] arguments, Throwable t) {
        super(t);
        this.errorCode = errorCode;
        this.arguments = arguments;
        this.message = new CaseExceptionUtil().getDisplayMessage(errorCode, arguments);
    }

    private AbstractCaseException(Throwable t) {
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        return buf.append("BPM-").append(this.getErrorCode()).append("\n\n").append(this.getMessage()).toString();
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void setMessage(String message) {
        this.message = message;
    }
}

