/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.client;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.NVPair;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseStreamService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseStreamServiceClient
implements ICaseStreamService {
    String serverURL = null;
    private static final String NEW_LINE = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String BOUNDARY = "---------------------------7d6110228101bc";
    private static final String CASEMANAGEMENT_SERVLET_URL = "/bpm/casemgmt/CaseManagementServlet";

    public CaseStreamServiceClient(String serverURL) {
        this.serverURL = serverURL;
    }

    @Override
    public InputStream downloadDocument(IBPMContext ctx, CaseIdentifier caseIdentifier, String fileName) throws CaseServiceException {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "download(): serverURL: " + this.serverURL);
        try {
            HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
            connection.removeModule(CookieModule.class);
            ArrayList headers = new ArrayList();
            NVPair[] nvHeader = new NVPair[]{new NVPair("Content-Type", "text/html; charset=utf-8"), new NVPair("Accept-Charset", "utf-8"), new NVPair("download", "true")};
            NVPair[] form_data = new NVPair[]{new NVPair("caseId", caseIdentifier.getCaseId()), new NVPair("doc", fileName), new NVPair("token", ctx.getToken())};
            HTTPResponse response = connection.Get(CASEMANAGEMENT_SERVLET_URL, form_data, nvHeader);
            return response.getInputStream();
        }
        catch (Exception e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean uploadDocument(IBPMContext ctx, CaseIdentifier caseIdentifier, String fileName, String mimeType, InputStream inputStream, String comments, String permissionTag) throws CaseServiceException {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "Uploading InputStream to server " + this.serverURL);
        try {
            String str;
            HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
            StringBuffer httpResponse = new StringBuffer();
            int statusCode = 0;
            connection.removeModule(CookieModule.class);
            ArrayList<NVPair> headers = new ArrayList<NVPair>();
            headers.add(new NVPair("Content-Type", "multipart/form-data; boundary=---------------------------7d6110228101bc; charset=utf-8"));
            headers.add(new NVPair("Accept-Charset", "utf-8"));
            NVPair[] nvHeader = headers.toArray(new NVPair[0]);
            HttpOutputStream out = new HttpOutputStream();
            HTTPResponse response = connection.Post("//bpm/casemgmt/CaseManagementServlet", out, nvHeader);
            DataOutputStream dos = new DataOutputStream((OutputStream)out);
            CaseStreamServiceClient.writeParameter("dummy", "dummy", dos, false);
            if (inputStream != null) {
                CaseStreamServiceClient.writeInputStream(fileName, mimeType, inputStream, dos);
                inputStream.close();
            }
            dos.flush();
            CaseStreamServiceClient.writeParameter("caseId", caseIdentifier.getCaseId(), dos, false);
            CaseStreamServiceClient.writeParameter("comments", comments, dos, false);
            CaseStreamServiceClient.writeParameter("permissionTag", permissionTag, dos, false);
            String parameterName = "uploadFile";
            String parameterValue = "";
            CaseStreamServiceClient.writeParameter(parameterName, parameterValue, dos, false);
            dos.flush();
            CaseStreamServiceClient.writeParameter("user", ctx.getUser(), dos, false);
            CaseStreamServiceClient.writeParameter("token", ctx.getToken(), dos, false);
            CaseStreamServiceClient.writeParameter("idctx", ctx.getIdentityContext(), dos, true);
            dos.close();
            BufferedReader inStream = new BufferedReader(new InputStreamReader(response.getInputStream(), "UTF-8"));
            while ((str = inStream.readLine()) != null) {
                if ((str = str.trim()).equals("")) continue;
                httpResponse.append(str);
            }
            inStream.close();
            statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 204) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): End of uploading InputStream to server ");
                return true;
            }
            throw new Exception(httpResponse.toString());
        }
        catch (CaseServiceException cse) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): " + cse.getMessage());
            throw cse;
        }
        catch (Exception e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public InputStream getDictionaryFromSandbox(IBPMContext ctx, String namespace) throws Exception {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "getDictionaryFromSandbox(): serverURL: " + this.serverURL);
        HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
        connection.removeModule(CookieModule.class);
        ArrayList headers = new ArrayList();
        NVPair[] nvHeader = new NVPair[]{new NVPair("Content-Type", "text/html; charset=utf-8"), new NVPair("Accept-Charset", "utf-8")};
        NVPair[] form_data = new NVPair[]{new NVPair("namespace", namespace), new NVPair("user", ctx.getUser()), new NVPair("idctx", ctx.getIdentityContext()), new NVPair("methodName", "getDictionaryFromSandbox"), new NVPair("component", "CM_RULE"), new NVPair("token", ctx.getToken())};
        HTTPResponse response = connection.Get(CASEMANAGEMENT_SERVLET_URL, form_data, nvHeader);
        return response.getInputStream();
    }

    public InputStream getActiveDictionary(IBPMContext ctx, String namespace) throws Exception {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "getActiveDictionary(): serverURL: " + this.serverURL);
        HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
        connection.removeModule(CookieModule.class);
        ArrayList headers = new ArrayList();
        NVPair[] nvHeader = new NVPair[3];
        nvHeader[0] = new NVPair("Content-Type", "text/html; charset=utf-8");
        nvHeader[1] = new NVPair("Accept-Charset", "utf-8");
        NVPair[] form_data = new NVPair[]{new NVPair("namespace", namespace), new NVPair("user", ctx.getUser()), new NVPair("idctx", ctx.getIdentityContext()), new NVPair("methodName", "getActiveDictionary"), new NVPair("component", "CM_RULE"), new NVPair("token", ctx.getToken())};
        HTTPResponse response = connection.Get(CASEMANAGEMENT_SERVLET_URL, form_data, nvHeader);
        return response.getInputStream();
    }

    public void saveDictionaryToSandbox(IBPMContext ctx, String namespace, InputStream dictionary, String comments) throws Exception {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "Uploading InputStream to server " + this.serverURL);
        HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
        StringBuffer httpResponse = new StringBuffer();
        int statusCode = 0;
        try {
            String str;
            connection.removeModule(CookieModule.class);
            ArrayList<NVPair> headers = new ArrayList<NVPair>();
            headers.add(new NVPair("Content-Type", "multipart/form-data; boundary=---------------------------7d6110228101bc; charset=utf-8"));
            headers.add(new NVPair("Accept-Charset", "utf-8"));
            NVPair[] nvHeader = headers.toArray(new NVPair[0]);
            HttpOutputStream out = new HttpOutputStream();
            HTTPResponse response = connection.Post("//bpm/casemgmt/CaseManagementServlet", out, nvHeader);
            DataOutputStream dos = new DataOutputStream((OutputStream)out);
            CaseStreamServiceClient.writeParameter("dummy", "dummy", dos, false);
            if (dictionary != null) {
                CaseStreamServiceClient.writeInputStream("dictionary", "text/xml", dictionary, dos);
                dictionary.close();
            }
            dos.flush();
            CaseStreamServiceClient.writeParameter("namespace", namespace, dos, false);
            CaseStreamServiceClient.writeParameter("comments", comments, dos, false);
            CaseStreamServiceClient.writeParameter("saveDictionaryToSandbox", "saveDictionaryToSandbox", dos, false);
            CaseStreamServiceClient.writeParameter("user", ctx.getUser(), dos, false);
            CaseStreamServiceClient.writeParameter("token", ctx.getToken(), dos, false);
            CaseStreamServiceClient.writeParameter("idctx", ctx.getIdentityContext(), dos, true);
            dos.flush();
            dos.close();
            BufferedReader inStream = new BufferedReader(new InputStreamReader(response.getInputStream(), "UTF-8"));
            while ((str = inStream.readLine()) != null) {
                if ((str = str.trim()).equals("")) continue;
                httpResponse.append(str);
            }
            inStream.close();
            statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 204) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): End of uploading InputStream to server ");
                return;
            }
            throw new Exception(httpResponse.toString());
        }
        catch (Exception exc) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "saveDictionaryToSandbox : " + exc.getMessage());
            throw exc;
        }
    }

    public void commitDictionary(IBPMContext ctx, String namespace, InputStream dictionary, String comments, boolean forceUpdate) throws Exception {
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "Uploading InputStream to server " + this.serverURL);
        HTTPConnection connection = new HTTPConnection(new URL(this.serverURL));
        StringBuffer httpResponse = new StringBuffer();
        int statusCode = 0;
        try {
            String str;
            connection.removeModule(CookieModule.class);
            ArrayList<NVPair> headers = new ArrayList<NVPair>();
            headers.add(new NVPair("Content-Type", "multipart/form-data; boundary=---------------------------7d6110228101bc; charset=utf-8"));
            headers.add(new NVPair("Accept-Charset", "utf-8"));
            NVPair[] nvHeader = headers.toArray(new NVPair[0]);
            HttpOutputStream out = new HttpOutputStream();
            HTTPResponse response = connection.Post("//bpm/casemgmt/CaseManagementServlet", out, nvHeader);
            DataOutputStream dos = new DataOutputStream((OutputStream)out);
            CaseStreamServiceClient.writeParameter("dummy", "dummy", dos, false);
            if (dictionary != null) {
                CaseStreamServiceClient.writeInputStream("dictionary", "text/xml", dictionary, dos);
                dictionary.close();
            }
            dos.flush();
            CaseStreamServiceClient.writeParameter("namespace", namespace, dos, false);
            CaseStreamServiceClient.writeParameter("comments", comments, dos, false);
            CaseStreamServiceClient.writeParameter("forceUpdate", String.valueOf(forceUpdate), dos, false);
            CaseStreamServiceClient.writeParameter("commitDictionary", "commitDictionary", dos, false);
            CaseStreamServiceClient.writeParameter("user", ctx.getUser(), dos, false);
            CaseStreamServiceClient.writeParameter("token", ctx.getToken(), dos, false);
            CaseStreamServiceClient.writeParameter("idctx", ctx.getIdentityContext(), dos, true);
            dos.flush();
            dos.close();
            BufferedReader inStream = new BufferedReader(new InputStreamReader(response.getInputStream(), "UTF-8"));
            while ((str = inStream.readLine()) != null) {
                if ((str = str.trim()).equals("")) continue;
                httpResponse.append(str);
            }
            inStream.close();
            statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 204) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "upload(): End of uploading InputStream to server ");
                return;
            }
            throw new Exception(httpResponse.toString());
        }
        catch (Exception exc) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "saveDictionaryToSandbox : " + exc.getMessage());
            throw exc;
        }
    }

    private static void writeInputStream(String fileName, String contentType, InputStream inputStream, DataOutputStream dos) throws Exception {
        int maxBufferSize = 0x100000;
        int minBufferSize = 8192;
        dos.writeBytes("-----------------------------7d6110228101bc\r\n");
        dos.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"");
        dos.writeUTF(fileName);
        dos.writeBytes("\"\r\nContent-Type: " + contentType + NEW_LINE);
        dos.writeBytes(NEW_LINE);
        int bytesAvailable = inputStream.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        bufferSize = Math.max(bufferSize, minBufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = inputStream.read(buffer, 0, bufferSize);
        int bufferSizeCounter = 0;
        while (bytesRead > 0) {
            dos.write(buffer, 0, bytesRead);
            bufferSizeCounter += bytesRead;
            bytesRead = inputStream.read(buffer, 0, bufferSize);
        }
        dos.writeBytes(NEW_LINE);
    }

    private static void writeParameter(String paramName, String value, DataOutputStream dos, boolean isLast) throws Exception {
        if (paramName != null && value != null) {
            dos.writeBytes("-----------------------------7d6110228101bc\r\n");
            dos.writeBytes("Content-Disposition: form-data; name=\"" + paramName + "\"" + NEW_LINE);
            dos.writeBytes(NEW_LINE);
            dos.writeBytes(value + NEW_LINE);
            if (isLast) {
                dos.writeBytes("-----------------------------7d6110228101bc--\r\n");
            }
        }
    }
}

