/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.casemgmt.caserule.model.CaseRule;
import oracle.bpm.casemgmt.caserule.model.CaseRuleEditPK;

@Entity
@IdClass(value=CaseRuleEditPK.class)
@NamedQueries(value={@NamedQuery(name="CaseRuleEdit.findAll", query="select o from CaseRuleEdit o"), @NamedQuery(name="CaseRuleEdit.findByUser", query="select o from CaseRuleEdit o where o.lockedBy = :lockedBy and o.namespace = :namespace"), @NamedQuery(name="CaseRuleEdit.deleteAll", query="delete from CaseRuleEdit")})
@Table(name="CM_RULE_EDIT")
public class CaseRuleEdit
implements Serializable {
    @JoinColumns(value={@JoinColumn(name="RULE_NAMESPACE", referencedColumnName="RULE_NAMESPACE"), @JoinColumn(name="RULE_VERSION", referencedColumnName="RULE_VERSION")})
    @ManyToOne
    private CaseRule caseRule;
    @Column(name="RULE_COMMENTS", length=2000)
    private String comments;
    @Column(name="RULE_DICTIONARY", nullable=false)
    private byte[] dictionary;
    @Column(name="LOCKED_BY", nullable=false, length=400)
    @Id
    private String lockedBy;
    @Column(name="RULE_NAMESPACE", nullable=false, length=2000, insertable=false, updatable=false)
    @Id
    private String namespace;
    @Column(name="TENANT_ID", length=64)
    private String tenantId;
    @Column(name="RULE_VERSION", nullable=false, insertable=false, updatable=false)
    @Id
    private Long version;

    public CaseRuleEdit() {
    }

    public CaseRuleEdit(String comments, String lockedBy, CaseRule caseRule, String tenantId) {
        this.comments = comments;
        this.lockedBy = lockedBy;
        this.caseRule = caseRule;
        this.tenantId = tenantId;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public byte[] getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(byte[] dictionary) {
        this.dictionary = dictionary;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public CaseRule getCaseRule() {
        return this.caseRule;
    }

    public void setCaseRule(CaseRule caseRule) {
        this.caseRule = caseRule;
        if (caseRule != null) {
            this.version = caseRule.getVersion();
            this.namespace = caseRule.getNamespace();
        }
    }
}

