/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.casemetadata.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInCaseDefinition;
import oracle.bpm.casemgmt.casemetadata.model.CaseMilestoneDefinition;

@Entity
@NamedQueries(value={@NamedQuery(name="CaseDefinition.findAll", query="select o from CaseDefinition o"), @NamedQuery(name="CaseDefinition.deleteAll", query="delete from CaseDefinition"), @NamedQuery(name="CaseDefinition.findByName", query="select o from CaseDefinition o where o.name IN :name"), @NamedQuery(name="CaseDefinition.findById", query="select o from CaseDefinition o where o.definitionId IN :definitionId"), @NamedQuery(name="CaseDefinition.findByNamespace", query="select o from CaseDefinition o where o.namespace IN :namespace"), @NamedQuery(name="CaseDefinition.findByCategory", query="select o from CaseDefinition o where o.category IN :categoryName")})
@Table(name="CM_CASE_DEFINITION")
public class CaseDefinition
implements Serializable {
    @Column(name="APPLICATION_NAME", length=200)
    private String applicationName;
    @OneToMany(mappedBy="caseDefinition")
    private List<CaseActivityInCaseDefinition> caseActivityInCaseDefinitionList;
    @OneToMany(mappedBy="caseDefinition", cascade={CascadeType.ALL})
    private List<CaseMilestoneDefinition> caseMilestoneDefinitionList;
    @Column(name="CATEGORY", length=400)
    private String category;
    @Column(name="COMPONENT_NAME", length=200)
    private String componentName;
    @Column(name="COMPOSITE_DN", length=500)
    private String compositeDn;
    @Column(name="COMPOSITE_NAME", length=200)
    private String compositeName;
    @Column(name="COMPOSITE_VERSION", length=10)
    private String compositeVersion;
    @Column(name="DEFINITION_ID", nullable=false, length=400)
    @Id
    private String definitionId;
    @Column(length=1000)
    private String description;
    @Column(nullable=false, length=2000)
    private String name;
    @Column(length=2000)
    private String namespace;
    @Column(length=500)
    private String title;

    public CaseDefinition() {
    }

    public CaseDefinition(String applicationName, String category, String componentName, String compositeDn, String compositeName, String compositeVersion, String definitionId, String description, String name, String namespace, String title) {
        this.applicationName = applicationName;
        this.category = category;
        this.componentName = componentName;
        this.compositeDn = compositeDn;
        this.compositeName = compositeName;
        this.compositeVersion = compositeVersion;
        this.definitionId = definitionId;
        this.description = description;
        this.name = name;
        this.namespace = namespace;
        this.title = title;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getCompositeDn() {
        return this.compositeDn;
    }

    public void setCompositeDn(String compositeDn) {
        this.compositeDn = compositeDn;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public void setCompositeName(String compositeName) {
        this.compositeName = compositeName;
    }

    public String getCompositeVersion() {
        return this.compositeVersion;
    }

    public void setCompositeVersion(String compositeVersion) {
        this.compositeVersion = compositeVersion;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<CaseActivityInCaseDefinition> getCaseActivityInCaseDefinitionList() {
        return this.caseActivityInCaseDefinitionList;
    }

    public List<CaseMilestoneDefinition> getCaseMilestoneDefinitionList() {
        return this.caseMilestoneDefinitionList;
    }

    public void setCaseMilestoneDefinitionList(List<CaseMilestoneDefinition> caseMilestoneDefinitionList) {
        this.caseMilestoneDefinitionList = caseMilestoneDefinitionList;
    }

    public CaseMilestoneDefinition addCaseMilestoneDefinition(CaseMilestoneDefinition caseMilestoneDefinition) {
        this.getCaseMilestoneDefinitionList().add(caseMilestoneDefinition);
        caseMilestoneDefinition.setCaseDefinition(this);
        return caseMilestoneDefinition;
    }

    public CaseMilestoneDefinition removeCaseMilestoneDefinition(CaseMilestoneDefinition caseMilestoneDefinition) {
        this.getCaseMilestoneDefinitionList().remove(caseMilestoneDefinition);
        caseMilestoneDefinition.setCaseDefinition(null);
        return caseMilestoneDefinition;
    }
}

