/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt;

import java.io.Serializable;

public class CaseIdentifier
implements Serializable {
    private String caseId;
    private final CaseIdentifierType caseIdentifierType;
    private final Long caseNumber;
    private final String identificationKey;

    public CaseIdentifier(String caseId, Long caseNumber, String identificationKey) {
        if (caseId != null) {
            this.caseIdentifierType = CaseIdentifierType.CASEID;
        } else if (caseNumber != null) {
            this.caseIdentifierType = CaseIdentifierType.CASENUMBER;
        } else if (identificationKey != null) {
            this.caseIdentifierType = CaseIdentifierType.IDENTIFICATIONKEY;
        } else {
            throw new IllegalArgumentException("Case identifier requires at least one valid argument");
        }
        this.caseId = caseId;
        this.caseNumber = caseNumber;
        this.identificationKey = identificationKey;
    }

    public static CaseIdentifier getCaseIdentifierBasedOnCaseId(String caseId) {
        return new CaseIdentifier(caseId, 0L, null);
    }

    public static CaseIdentifier getCaseIdentifierBasedOnIdentificationKey(String identificationKey) {
        return new CaseIdentifier(null, 0L, identificationKey);
    }

    public static CaseIdentifier getCaseIdentifierBasedOnCaseNumber(Long caseNumber) {
        return new CaseIdentifier(null, caseNumber, null);
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public Long getCaseNumber() {
        return this.caseNumber;
    }

    public String getIdentificationKey() {
        return this.identificationKey;
    }

    public CaseIdentifierType getCaseIdentifierType() {
        return this.caseIdentifierType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.caseId != null) {
            sb.append("{");
            sb.append("caseId:");
            sb.append(this.caseId);
            sb.append("}");
        } else if (this.caseNumber != null) {
            sb.append("{");
            sb.append("caseNumber:");
            sb.append(this.caseNumber);
            sb.append("}");
        } else if (this.identificationKey != null) {
            sb.append("{");
            sb.append("identificationKey:");
            sb.append(this.identificationKey);
            sb.append("}");
        }
        return sb.toString();
    }

    public static enum CaseIdentifierType {
        CASEID,
        CASENUMBER,
        IDENTIFICATIONKEY;

    }
}

