/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt;

import javax.persistence.DiscriminatorValue;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.CaseServiceLocator;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

@DiscriminatorValue(value="DOCUMENT")
public class CaseDocumentObject
extends CaseObject {
    private String docComment;
    private long docSize;
    private String docStoreType;
    private String docVersion;
    private String folder;
    private String permissionTagAttributeName;

    public static String getFolder(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        Case caseInstance = CaseServiceLocator.getCaseService().getCase(context, caseIdentifier, null);
        String doc_folder = caseInstance.getCaseHeader().getEcmFolder();
        CaseLogger.log(LoggerComponent.COMPONENT_CM_DOCUMENT, Severity.DEBUG, "caseId: " + caseIdentifier.getCaseId() + ", doc_folder: " + doc_folder);
        return doc_folder;
    }

    public static String getDocumentPath(IBPMContext context, CaseIdentifier caseIdentifier, String docName) throws CaseServiceException {
        return CaseDocumentObject.getFolder(context, caseIdentifier) + "/" + docName;
    }

    public String getDocumentPath(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        return CaseDocumentObject.getDocumentPath(context, caseIdentifier, this.getObjectName());
    }

    public String getDocStoreType() {
        return this.docStoreType;
    }

    public void setDocStoreType(String docStoreType) {
        this.docStoreType = docStoreType;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getDocVersion() {
        return this.docVersion;
    }

    public void setDocVersion(String docVersion) {
        this.docVersion = docVersion;
    }

    public long getDocSize() {
        return this.docSize;
    }

    public void setDocSize(long docSize) {
        this.docSize = docSize;
    }

    public String getDocComment() {
        return this.docComment;
    }

    public void setDocComment(String docComment) {
        this.docComment = docComment;
    }

    public String getPermissionTagAttributeName() {
        return this.permissionTagAttributeName;
    }

    public void setPermissionTagAttributeName(String permissionTagAttributeName) {
        this.permissionTagAttributeName = permissionTagAttributeName;
    }

    @Override
    public String toString() {
        return "[CaseDocumentObject] docStoreType: " + this.docStoreType + ", folder:" + this.folder + ", docVersion:" + this.docVersion + ", docSize:" + this.docSize + ", docComment:" + this.docComment + ", CaseManagementPermissionTag name: " + this.permissionTagAttributeName + ", [CaseObject]:" + super.toString();
    }
}

