/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import fuego.parser.CommonASTWithHiddenTokens;
import fuego.parser.Token;
import fuego.parser.collections.AST;

public class ASTNode
extends CommonASTWithHiddenTokens
implements Cloneable {
    private short column = 0;
    private short length = 0;
    private short line = 0;
    private int offset = -1;

    public void setColumn(int column) {
        this.column = (short)column;
    }

    public int getColumn() {
        return this.column;
    }

    public final void setLength(int length) {
        this.length = (short)length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLine(int line) {
        this.line = (short)line;
    }

    public int getLine() {
        return this.line;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public final void copyHiddenTokens(ASTNode n) {
        this.hiddenBefore = n.getHiddenBefore();
        this.hiddenAfter = n.getHiddenAfter();
    }

    public final void copyPositionFrom(ASTNode t) {
        if (t != null) {
            this.setLine(t.getLine());
            this.setColumn(t.getColumn());
            this.setLength(t.getLength());
            this.setOffset(t.getOffset());
        }
    }

    public void initialize(Token tok) {
        super.initialize(tok);
        String text = tok.getText();
        this.setLine(tok.getLine());
        this.setColumn(tok.getColumn());
        this.setText(text);
        this.setType(tok.getType());
    }

    public void initialize(AST t) {
        this.initialize((ASTNode)t);
    }

    public void initialize(ASTNode node) {
        if (node != null) {
            this.setLine(node.getLine());
            this.setColumn(node.getColumn());
            this.setOffset(node.getOffset());
            this.setLength(node.getLength());
            this.setText(node.getText());
        }
    }

    public void initialize(int t, String txt) {
        this.setText(txt);
        this.setType(t);
    }

    public final void moveHiddenTokensFrom(ASTNode n) {
        this.copyHiddenTokens(n);
        n.hiddenBefore = null;
        n.hiddenAfter = null;
    }

    public String toString() {
        return this.getText();
    }

    public final String toStringList() {
        return this.toStringList(false, 0);
    }

    protected boolean splitToPrint() {
        return false;
    }

    private String toStringList(boolean splitLines, int level) {
        int indx;
        String current;
        StringBuilder result = new StringBuilder("");
        if (splitLines) {
            result.append('\n');
            for (int i = 0; i < level; ++i) {
                result.append("    ");
            }
        }
        if ((current = this.toString()).length() == 0 && (indx = (current = this.getClass().getName()).lastIndexOf(46)) != -1) {
            current = current.substring(indx + 1);
        }
        if (this.down == null) {
            result.append(current);
        } else {
            boolean split = this.splitToPrint();
            int newLevel = split ? level + 1 : level;
            result.append('(');
            result.append(current).append(' ');
            ASTNode node = (ASTNode)this.down;
            while (node != null) {
                result.append(node.toStringList(split, newLevel));
                if (node.right != null) {
                    result.append(' ');
                }
                node = (ASTNode)node.right;
            }
            result.append(')');
        }
        return result.toString();
    }
}

