/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;

public class TypeRenderer {
    protected String arrayDeclarationEnd = "]";
    protected String arrayDeclarationStart = "[";
    protected String declarationSymbol = ":";
    protected String escapeSymbol = "@";
    protected String orderedSymbol = "ordered";
    protected String parameterEnd = ")";
    protected String parameterStart = "(";
    protected Set<? extends CharSequence> tokens;
    private static Map<String, TypeRenderer> renderers = Collections.synchronizedMap(new HashMap());
    public static final int FULLY_QUALIFIED_NAMES = 2;
    public static final int NON_QUALIFIED_NAMES = 4;
    public static final int QUALIFIED_IF_NEEDED = 8;
    public static final int DO_NOT_GENERATE_PRECISION = 16;
    public static final int DO_NOT_ESCAPE = 32;
    private static final int DEFAULT_FLAGS = 8;
    private static final String[] hiddenModules = new String[]{"Fuego.Internal"};

    public TypeRenderer() {
        this(null);
    }

    public TypeRenderer(Set<? extends CharSequence> tokens) {
        this.tokens = tokens;
    }

    public static TypeRenderer getInstance(String language) {
        return renderers.get(language);
    }

    public static void register(String language, TypeRenderer renderer) {
        renderers.put(language, renderer);
    }

    public String render(TypeRef type) {
        return this.render(type, null, 8);
    }

    public String render(TypeRef type, int flags) {
        return this.render(type, null, flags);
    }

    public String render(TypeRef type, TypeDescription context) {
        return this.render(type, context, 8);
    }

    public String render(TypeRef type, TypeDescription context, int flags) {
        StringBuilder buffer = new StringBuilder();
        this.render(type, context, buffer, flags);
        return buffer.toString();
    }

    public void render(TypeRef type, TypeDescription context, StringBuilder buffer) {
        this.renderType(type, context, buffer, 8);
    }

    public void render(TypeRef type, TypeDescription context, StringBuilder buffer, int flags) {
        this.renderType(type, context, buffer, flags);
    }

    public void render(MethodTypeDescription member, TypeDescription context, StringBuilder buffer, int flags) {
        buffer.append(member.getName());
        this.renderArguments(member, context, buffer, flags);
        this.renderResult(member, context, buffer, flags);
    }

    public void render(AttributeTypeDescription attribute, TypeDescription context, StringBuilder buffer, int flags) {
        this.appendIdentifier(attribute.getName(), buffer, flags);
        buffer.append(" : ");
        this.render(attribute.getTypeRef(), context, buffer, flags);
    }

    public void render(TransformTypeDescription transform, TypeDescription context, StringBuilder buffer, int flags) {
        StringBuilder text = new StringBuilder();
        int scount = transform.getSourceCount();
        if (scount > 1) {
            text.append('(');
        }
        for (int i = 0; i < scount; ++i) {
            this.render(transform.getSource(i), context, buffer, flags);
            if (i + 1 >= scount) continue;
            text.append(", ");
        }
        if (scount > 1) {
            text.append(')');
        }
        text.append(" -> ");
        this.render(transform.getTarget(), context, buffer, flags);
    }

    public void renderArguments(MethodTypeDescription member, TypeDescription context, StringBuilder buffer) {
        this.renderArguments(member, context, buffer, 8);
    }

    public void renderArguments(MethodTypeDescription member, TypeDescription context, StringBuilder buffer, int flags) {
        int argc = member.getArgumentCount();
        if (argc > 0) {
            buffer.append('(');
            for (int i = 0; i < argc; ++i) {
                Argument arg = member.getArgument(i);
                this.renderArgument(arg, context, buffer, flags);
                if (i + 1 >= argc) continue;
                buffer.append(", ");
            }
            buffer.append(')');
        }
    }

    public void renderObjectType(TypeRef type, TypeDescription context, StringBuilder buffer) {
        this.renderObjectType(type, context, buffer, 8);
    }

    public void renderObjectType(TypeRef type, TypeDescription context, StringBuilder buffer, int flags) {
        String name = type.getName();
        if (this.isUnqualifiedNames(flags)) {
            this.appendIdentifier(name, buffer, flags);
        } else if (this.isQualifiedIfNeeded(flags)) {
            String result = name;
            String[] parts = null;
            int qualificationCount = 0;
            while (this.isAmbiguous(result, type, context)) {
                ++qualificationCount;
                if (parts == null) {
                    String text = type.getText();
                    parts = Str.split(text, '.', false);
                }
                if (qualificationCount >= parts.length - 1) {
                    result = type.getText();
                    break;
                }
                result = "";
                for (int i = 0; i < qualificationCount; ++i) {
                    result = result + parts[i].concat(".");
                }
                result = result + name;
            }
            if (qualificationCount == 0) {
                this.appendIdentifier(result, buffer, flags);
            } else {
                this.appendQualifiedText(result, buffer, flags);
            }
        } else {
            String text = type.getText();
            this.appendQualifiedText(text, buffer, flags);
        }
        TypeRef[] parameters = type.get().getTypeParameters();
        if (parameters != null && parameters.length > 0) {
            buffer.append(this.parameterStart);
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                this.renderType(parameters[i], context, buffer, flags);
            }
            buffer.append(this.parameterEnd);
        }
    }

    public void renderType(TypeRef type, TypeDescription context, StringBuilder buffer, int flags) {
        int kind = this.getKind(type);
        switch (kind) {
            case 12: 
            case 13: {
                this.renderArrayType(type.get(), context, buffer, flags);
                break;
            }
            case 16: {
                this.renderIterator(type.get(), context, buffer, flags);
                break;
            }
            case -1: {
                buffer.append(type.get().getName());
                break;
            }
            case 11: 
            case 17: {
                this.renderObjectType(type, context, buffer, flags);
                break;
            }
            case 14: {
                this.render(type.get().asMethod(), context, buffer, flags);
                break;
            }
            case 18: {
                this.render(type.get().asAttribute(), context, buffer, flags);
                break;
            }
            case 20: {
                this.render((TransformTypeDescription)type.get(), context, buffer, flags);
                break;
            }
            default: {
                if (Kind.isPredefined(kind)) {
                    this.renderBuiltInType(type.get(), buffer, flags);
                    break;
                }
                buffer.append(type.getText());
            }
        }
        this.replaceHiddenModuleReferences(buffer);
    }

    protected void renderArgModifiers(Argument arg, StringBuilder buffer) {
        if (arg.isOptional()) {
            buffer.append("optional ");
        }
        if (arg.isIn() && arg.isOut()) {
            buffer.append("inout ");
        } else if (arg.isOut()) {
            buffer.append("out ");
        }
    }

    protected void renderArgName(Argument arg, StringBuilder buffer, int flags) {
        String name = arg.getName();
        if (name == null) {
            name = "";
        }
        this.appendIdentifier(name, buffer, flags);
    }

    protected void renderArgument(Argument arg, TypeDescription context, StringBuilder buffer, int flags) {
        this.renderArgModifiers(arg, buffer);
        MethodTypeDescription member = arg.getParent();
        if (member == null || !member.isTransformation()) {
            this.renderArgName(arg, buffer, flags);
            buffer.append(" ");
            buffer.append(this.declarationSymbol);
            buffer.append(" ");
        }
        this.render(arg.getTypeRef(), context, buffer, flags);
    }

    protected void renderArrayType(TypeDescription type, TypeDescription context, StringBuilder buffer, int flags) {
        this.renderType(type.getElementTypeRef(), context, buffer, flags);
        buffer.append(this.arrayDeclarationStart);
        if (type.getKind() == 13) {
            if (type.isOrdered()) {
                buffer.append(this.orderedSymbol);
                buffer.append(' ');
            }
            this.renderType(type.getIndexTypeRef(), context, buffer, flags);
        }
        buffer.append(this.arrayDeclarationEnd);
    }

    protected void renderBuiltInType(TypeDescription type, StringBuilder buffer, int flags) {
        int kind = type.getKind();
        int length = type.getLength();
        int scale = type.getScale();
        buffer.append(type.getName());
        if ((flags & 0x10) == 0) {
            if (length != -1 && scale > -1) {
                buffer.append(this.parameterStart);
                buffer.append(length);
                buffer.append(", ");
                buffer.append(scale);
                buffer.append(this.parameterEnd);
            } else if (kind != 6 && kind != 8 && scale > -1) {
                buffer.append(this.parameterStart);
                buffer.append(scale);
                buffer.append(this.parameterEnd);
            } else if (length != -1 && (kind == 5 || kind == 2 && length != 32 || kind == 4 && length != 64)) {
                buffer.append(this.parameterStart);
                buffer.append(length);
                buffer.append(this.parameterEnd);
            }
        }
    }

    protected void renderBuiltInTypeName(TypeDescription type, StringBuilder buffer, int flags) {
        buffer.append(type.getName());
    }

    private boolean isAmbiguous(String name, TypeRef type, TypeDescription context) {
        ComponentCatalog catalog = context != null ? context.getCatalog() : null;
        boolean ambiguous = true;
        if (catalog != null && !"Instance".equals(name)) {
            try {
                TypeRef result = catalog.find(name, context);
                if (result != null && result.getText().equals(type.getText())) {
                    ambiguous = false;
                }
            }
            catch (AmbiguousTypeNameException ignore) {
                // empty catch block
            }
        }
        return ambiguous;
    }

    private int getKind(TypeRef ref) {
        int kind = 11;
        if (ref instanceof TypeDescription) {
            TypeDescription type = ref.get();
            kind = type.getKind();
        }
        return kind;
    }

    private boolean isQualifiedIfNeeded(int flags) {
        return (flags & 8) != 0;
    }

    private boolean isUnqualifiedNames(int flags) {
        return (flags & 4) != 0;
    }

    private void appendIdentifier(String id, StringBuilder buffer, int flags) {
        if (this.escapeSymbols(flags) && this.tokens != null && this.tokens.contains(id)) {
            buffer.append(this.escapeSymbol);
        }
        buffer.append(id);
    }

    private boolean escapeSymbols(int flags) {
        return (flags & 0x20) == 0;
    }

    private void appendQualifiedText(String text, StringBuilder buffer, int flags) {
        String[] parts = Str.split(text, '.', false);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i != 0) {
                buffer.append(".");
                buffer.append(part);
                continue;
            }
            this.appendIdentifier(part, buffer, flags);
        }
    }

    private void renderIterator(TypeDescription type, TypeDescription context, StringBuilder buffer, int flags) {
        buffer.append("Iterator");
        buffer.append(this.parameterStart);
        this.renderType(type.getElementTypeRef(), context, buffer, flags);
        buffer.append(this.parameterEnd);
    }

    private void renderResult(MethodTypeDescription member, TypeDescription context, StringBuilder buffer, int flags) {
        TypeRef retType = member.getResultArgument().getTypeRef();
        if (this.getKind(retType) != 0 && !member.isConstructor()) {
            buffer.append(" : ");
            this.render(retType, context, buffer, flags);
        }
    }

    private void replaceHiddenModuleReferences(StringBuilder buffer) {
        for (String hiddenmodule : hiddenModules) {
            int index = buffer.indexOf(hiddenmodule);
            while (index != -1) {
                buffer.replace(index, index + hiddenmodule.length() + 1, "");
                index = buffer.indexOf(hiddenmodule);
            }
        }
    }
}

