/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.msg;

import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TMsg;

public class CompilerMsg
extends MsgBundle {
    private static final TMsg INNER_TYPE_INHERITANCE = CompilerMsg.tmsg("Type '%0' inherits from type '%1' which is an inner type of '%2'.");
    private static final TMsg ABSTRACT_MUST_BE_EMPTY = CompilerMsg.tmsg("Abstract member '%0' cannot be implemented.");
    private static final TMsg AMBIGUOUSCALL = CompilerMsg.tmsg("Ambiguous call. These methods can be invoked: %0. Method %1 will be used");
    private static final TMsg AMBIGUOUSCOL = CompilerMsg.tmsg("Ambiguous column name: '%0'. Full qualification required.");
    private static final TMsg AMBIGUOUSNAME = CompilerMsg.tmsg("Component '%0' is imported and can be referenced from the following modules: '%1'. Fully qualify the component with the module you want to use.");
    private static final TMsg ARGNUMBER = CompilerMsg.tmsg("Illegal number of arguments. Cannot find a function or procedure '%0' for component '%1'. The closest match is '%2'.");
    private static final TMsg AUTODECL = CompilerMsg.tmsg("Local variable '%0' is not declared.");
    private static final TMsg BADARG = CompilerMsg.tmsg("Invalid value for argument '%0'. Type '%1' is not compatible with '%2'. Bad Argument in method '%3'.");
    private static final TMsg BADINDEX = CompilerMsg.tmsg("Invalid index type: '%0'. This is not compatible with '%1'.");
    private static final TMsg BREAKPOINT = CompilerMsg.tmsg("Breakpoint: '%0'.");
    private static final TMsg CANNOT_BE_CACHED_PR_TYPE = CompilerMsg.tmsg("Member '%0' cannot be cached since the output argument '%2' of type '%1' is not predefined.");
    private static final TMsg CANNOT_BE_CACHED_STATIC = CompilerMsg.tmsg("Member '%0' cannot be cached since it is not static.");
    private static final TMsg CANNOT_BE_NOT_NULL = CompilerMsg.tmsg("Member '%0' cannot be 'not null' since type '%1' has not been assigned a default value.");
    private static final TMsg CANNOT_CALL_CONSTR = CompilerMsg.tmsg("The constructor for inner type '%0' is private and cannot be invoked from '%1'. The constructor should be called from either '%2' or '%0'.");
    private static final TMsg CANNOT_DECLARE_MODULE = CompilerMsg.tmsg("Module '%0' cannot be declared.");
    private static final TMsg CANNOT_OVERRIDE = CompilerMsg.tmsg("Method '%0' cannot overload a method with the same signature in '%1'. The method should return %2.");
    private static final TMsg OVERRIDING_DEFAULT_PK = CompilerMsg.tmsg("The component '%0' overrides method '%1'. The behavior of primary key attributes might be inconsistent.");
    private static final TMsg CANNOT_REDEFINE_READ_ACCESS = CompilerMsg.tmsg("Cannot redefine read access for write-only attribute '%0'.");
    private static final TMsg CANNOT_REDEFINE_WRITE_ACCESS = CompilerMsg.tmsg("Cannot redefine write access for read-only attribute '%0'.");
    private static final TMsg CANTCONV = CompilerMsg.tmsg("Cannot convert from '%0' to '%1'.");
    private static final TMsg CANTEXTEND = CompilerMsg.tmsg("Cannot extend '%0' since it is not an indexed array.");
    private static final TMsg CANTEXTENDM = CompilerMsg.tmsg("Cannot extend '%0' since '%1' is a read-only member. ");
    private static final TMsg CONSTERR = CompilerMsg.tmsg("Cannot assign a value to the constant member '%0'.");
    private static final TMsg CYCLIC_INHERITANCE = CompilerMsg.tmsg("Cyclic inheritance %0.");
    private static final TMsg DEPRECATED_MEMBER = CompilerMsg.tmsg("The member '%0' of '%1' is deprecated.");
    private static final TMsg DEPRECATED_MEMBER_DETAIL = CompilerMsg.tmsg("Member '%0' is deprecated.");
    private static final TMsg DUPLICATED_ARG = CompilerMsg.tmsg("Duplicated argument '%1' for function or procedure '%0'.");
    private static final TMsg DUPLICATED_COLUMN = CompilerMsg.tmsg("The SQL statement contains references to column '%0' from more than one table. You should replace the '*' wildcard and explicitly reference these table columns in the list of columns to be retrieved by the select statement.");
    private static final TMsg DUPLICATED_DECL = CompilerMsg.tmsg("Duplicated local variable '%0' declaration. ");
    private static final TMsg DUPLICATED_POSITION = CompilerMsg.tmsg("Duplicated position '%0' in '%1' and '%2'.");
    private static final TMsg DUPLICATED_TRANSFORM = CompilerMsg.tmsg("Transformation '%0' has the same source and target arguments as '%1' in library '%2'.");
    private static final TMsg DUPLICATEDCOL = CompilerMsg.tmsg("Duplicated column name: '%0'.");
    private static final TMsg DUPLICATEDEXCEPTION = CompilerMsg.tmsg("Duplicated exception block: '%0'.");
    private static final TMsg ENTERPRISE_ONLY = CompilerMsg.tmsg("Member '%0' of '%1' will not work in a J2EE deployment environment.");
    private static final TMsg EXPFOUND = CompilerMsg.tmsg("Expecting %0 but %1 was found.");
    private static final TMsg EXPRFOUND = CompilerMsg.tmsg("Expecting %0..%1 but %2 was found.");
    private static final TMsg EXPSFOUND = CompilerMsg.tmsg("Expecting one of %0 but %1 was found.");
    private static final TMsg INCOMPAT = CompilerMsg.tmsg("Cannot apply a '%0' to '%1' and '%2'.");
    private static final TMsg INTERROR = CompilerMsg.tmsg("Internal error found. This should be reported to Oracle Support. Include the following information. Error: '%0'. Node: '%1'.");
    private static final TMsg INV_MEMBER_TYPE = CompilerMsg.tmsg("Invalid type '%0' for member '%1'.");
    private static final TMsg INV_PARAM_COUNT = CompilerMsg.tmsg("Invalid number of parameters for '%0'.");
    private static final TMsg INV_PARAM_VALUE = CompilerMsg.tmsg("Invalid value '%0' for argument '%1'.");
    private static final TMsg INVALID_ABSTRACT_MEMBER = CompilerMsg.tmsg("Abstract member '%0' is contained by type '%1' which is not abstract.");
    private static final TMsg INVALID_INDEX = CompilerMsg.tmsg("Array index out of bounds. You tried to access element '%1' when the array's length is: '%0'.");
    private static final TMsg INVALID_NAME = CompilerMsg.tmsg("'%0' is not a valid name.");
    private static final TMsg INVALID_NESTED_NAME = CompilerMsg.tmsg("Nested type name '%0' is not valid since it is already contained by another type with this same name.");
    private static final TMsg INVALID_SIGNATURE = CompilerMsg.tmsg("Invalid signature '%0' for member '%1' of type '%2'.");
    private static final TMsg INVALID_TX_ARG = CompilerMsg.tmsg("Transformation '%2' has an invalid modifier '%0' for argument '%1'. This transformation is contained in library '%3'.");
    private static final TMsg INVALID_TX_ARG_NAME = CompilerMsg.tmsg("Invalid argument name '%0'. The argument has the same name as the target object of transformation '%1' contained in library '%2'.");
    private static final TMsg INVALIDCOLUMN = CompilerMsg.tmsg("Invalid column name: '%0'.");
    private static final TMsg INVALIDFUNCTION = CompilerMsg.tmsg("Invalid function: '%0'.");
    private static final TMsg INVALIDVALUE = CompilerMsg.tmsg("'%0' is not a valid value of '%1'.");
    private static final TMsg INVARGUMENT = CompilerMsg.tmsg("'%1' is an invalid argument of the function or procedure '%0'.");
    private static final TMsg INVARGUMENT_H = CompilerMsg.tmsg("'%1' is an invalid argument of the function or procedure '%0'. The closest match for argument '%1' is '%2'.");
    private static final TMsg INVASSIG = CompilerMsg.tmsg("Cannot assign '%0' to '%1'.");
    private static final TMsg INVCALCATTR = CompilerMsg.tmsg("Attribute '%0' cannot have a 'calculate' expression since it has been marked as 'external'");
    private static final TMsg INVCHAR = CompilerMsg.tmsg("Invalid character '%0'.");
    private static final TMsg INVFUNASSIG = CompilerMsg.tmsg("Cannot assign a '%0' to a function.");
    private static final TMsg INVLABEL = CompilerMsg.tmsg("Invalid label: '%0'.");
    private static final TMsg INVLANGUAGE = CompilerMsg.tmsg("Invalid language: '%0'.");
    private static final TMsg INVMEMBER = CompilerMsg.tmsg("'%0' is not a member of '%1'.");
    private static final TMsg INVMEMBER_H = CompilerMsg.tmsg("'%0' is not a member of '%1'. The closest match for '%1' is '%2'.");
    private static final TMsg INVNUMBER = CompilerMsg.tmsg("Invalid number format: %0.");
    private static final TMsg INVOPERAND = CompilerMsg.tmsg("Cannot apply '%0' to '%1'.");
    private static final TMsg INVOPTION = CompilerMsg.tmsg("Invalid option: '%0'.");
    private static final TMsg INVREGEXP = CompilerMsg.tmsg("Invalid regular expression: '%0'.");
    private static final TMsg INVSTATICUSE = CompilerMsg.tmsg("'%0' cannot be used in a static method.");
    private static final TMsg INVTIME = CompilerMsg.tmsg("'%0' is not valid date format.");
    private static final TMsg INVTYPE = CompilerMsg.tmsg("Invalid type: '%0'.");
    private static final TMsg INVVARTYPE = CompilerMsg.tmsg("Cannot resolve type '%0' for variable '%1' since %2");
    private static final TMsg INVVVARRAY = CompilerMsg.tmsg("Type '%0' for the valid values list is not compatible with attribute '%1' of type '%2'.");
    private static final TMsg INVVVMAP = CompilerMsg.tmsg("Index type '%0' of the associative array is not compatible with attribute '%1' of type '%2'.");
    private static final TMsg IOERROR = CompilerMsg.tmsg("Input Output Error: '%0'.");
    private static final TMsg M_METHOD = CompilerMsg.tmsg("'%0' is a method and not an attribute of '%1'.");
    private static final TMsg M_METHODNOTOBJ = CompilerMsg.tmsg("'%0' is a method and not an object.");
    private static final TMsg M_NOTMETHOD = CompilerMsg.tmsg("'%0' is not a method of '%1'.");
    private static final TMsg M_NOTSTATIC = CompilerMsg.tmsg("'%0' is not a static member of '%1'.");
    private static final TMsg M_READONLY = CompilerMsg.tmsg("'%0' of '%1' does not have write access.");
    private static final TMsg M_WRONLY = CompilerMsg.tmsg("'%0' of '%1' does not have read access.");
    private static final TMsg MALFORMED_TYPE = CompilerMsg.tmsg("Invalid type '%0'. Reason: '%1'.");
    private static final TMsg MEMBER_NOT_IMPLEMENTED = CompilerMsg.tmsg("Member '%0', inheriting type '%1' is not implemented in '%2'.");
    private static final TMsg MISSING_EXTERNAL_RESOURCE = CompilerMsg.tmsg("External Resource '%0' is missing and it is being referenced in '%1'.");
    private static final TMsg MISSING_CLASSES = CompilerMsg.tmsg("An error has occurred during code generation. One or more classes referenced by '%0' are missing. Check that the following classes are present: %1.");
    private static final TMsg MISSING_MAPPING_EXPR = CompilerMsg.tmsg("The expression for target attribute '%0' of transformation '%1' is missing.");
    private static final TMsg MISSING_PK = CompilerMsg.tmsg("No primary key found for type: '%0'. A primary key needs to be defined for this type so that it can be used in comparison expressions.");
    private static final TMsg MISSING_POSITION = CompilerMsg.tmsg("Missing position for attribute '%0'.");
    private static final TMsg MISSING_SOURCES = CompilerMsg.tmsg("Transformation '%0' of the %(BPM_OBJECT) '%1' does not have any source defined.");
    private static final TMsg MISSINGRETURN = CompilerMsg.tmsg("This function should contain a return statement with an expression of type: '%0'.");
    private static final TMsg MIXEDTABLES = CompilerMsg.tmsg("'%0' does not belong to the same module as the previous tables.");
    private static final TMsg N_INARG = CompilerMsg.tmsg("The argument '%0' of the method '%1' is not an input argument.");
    private static final TMsg N_OUTARG = CompilerMsg.tmsg("The argument '%0' of the method '%1' is not an output argument.");
    private static final TMsg N_STATICARG = CompilerMsg.tmsg("Argument '%0' of the static method '%1' is not a static argument.");
    private static final TMsg NAMEMISMATCH = CompilerMsg.tmsg("Component '%0' ends with the name '%1'.");
    private static final TMsg NONBOOLEAN = CompilerMsg.tmsg("'%0' is not a boolean value.");
    private static final TMsg NONLITERAL = CompilerMsg.tmsg("'%0' is not a literal value.");
    private static final TMsg NONNUM = CompilerMsg.tmsg("'%0' is not a numeric value.");
    private static final TMsg NOSUCHCOMPONENT = CompilerMsg.tmsg("Component '%0' was not found.");
    private static final TMsg NOSUCHMODULE = CompilerMsg.tmsg("Module '%0' was not found.");
    private static final TMsg NOT_FO = CompilerMsg.tmsg("'%0' is not a BPM Object.");
    private static final TMsg NOT_NULL_FOR_PRIMITIVE_TYPE = CompilerMsg.tmsg("'Not null' cannot be applied to attribute '%0' with a primitive type.");
    private static final TMsg NOTANARRAY = CompilerMsg.tmsg("Type '%0' is not an array but '%1'.");
    private static final TMsg NOTANOBJECT = CompilerMsg.tmsg("'%0' is not an object.");
    private static final TMsg NOTAPPOPTION = CompilerMsg.tmsg("'%0' cannot be applied to '%1'.");
    private static final TMsg NOTCLONEABLE = CompilerMsg.tmsg("'%0' cannot be cloned.");
    private static final TMsg NOTEXP = CompilerMsg.tmsg("Nothing was expected but '%0' was received.");
    private static final TMsg NOTFUN = CompilerMsg.tmsg("'%0' is not a function.");
    private static final TMsg NOTFUN_BUT_PROC = CompilerMsg.tmsg("'%0' is a procedure of '%1' and not a function. ");
    private static final TMsg NOTINITIALIZED = CompilerMsg.tmsg("'%0' must be explicitly initialized before being used since it does not have a default initialization.");
    private static final TMsg NOTINSTANTIABLE = CompilerMsg.tmsg("'%0' must be explicitly instantiated before being used since it does not have a default initialization. ");
    private static final TMsg CANNOT_INSTANTIATE_ABSTRACT = CompilerMsg.tmsg("Cannot instantiate '%0' because it's abstract.");
    private static final TMsg NOTRANSF = CompilerMsg.tmsg("There is not a transformation from '%0' to '%1' in the library '%2'.");
    private static final TMsg NOTREXP = CompilerMsg.tmsg("Found %2, when the expected value should be in the range %0..%1.");
    private static final TMsg NOTSEXP = CompilerMsg.tmsg("Found %1, when the expected value did not have to be one of %0.");
    private static final TMsg NOTTABLE = CompilerMsg.tmsg("'%0' is not a table.");
    private static final TMsg NOTTHROWABLE = CompilerMsg.tmsg("'%0' is not a throwable object.");
    private static final TMsg NULL_PRIMITIVE = CompilerMsg.tmsg("Primitive types (%0) cannot be assigned a null value. The expression will default to 'false'.");
    private static final TMsg NULL_REFERENCE = CompilerMsg.tmsg("Null reference found in '%0'. The expected type was '%1'.");
    private static final TMsg OPTION_NO_VALUE = CompilerMsg.tmsg("Option '%0' does not accept any value.");
    private static final TMsg OPTION_REQ_VALUE = CompilerMsg.tmsg("Option '%0' requires a value.");
    private static final TMsg OTHER = CompilerMsg.tmsg("%0");
    private static final TMsg PK_NOT_ATOMIC = CompilerMsg.tmsg("Invalid type '%0' for primary key '%1'. The type must be atomic.");
    private static final TMsg REPLACED_MEMBER = CompilerMsg.tmsg("Member '%0' of '%1' is deprecated. It has been replaced by '%2'.");
    private static final TMsg RT_CONVERSION_FAILED = CompilerMsg.tmsg("The conversion from '%0' to '%1' has failed. Reason: '%2'.");
    private static final TMsg RUNTIMECOMP = CompilerMsg.tmsg("Error compiling method '%0' of component '%1'. Reason: '%2'");
    private static final TMsg SILLY_ASSIGN = CompilerMsg.tmsg("A variable '%0' cannot be assigned to itself. In some cases, the problem is resolved by fully qualifying the variable names. ");
    private static final TMsg SILLY_OP = CompilerMsg.tmsg("Both operands of the comparison expression '%0' are referencing the same variable '%1'. In some cases, the problem is resolved by fully qualifying one of the comparison operands. ");
    private static final TMsg STACKOVERFLOW = CompilerMsg.tmsg("Stack overflow executing %0.");
    private static final TMsg TABLENOTFOUND = CompilerMsg.tmsg("Table '%0' was not found.");
    private static final TMsg UNBOUNDED_PARAM = CompilerMsg.tmsg("No value has been assigned to parameter '%0'.");
    private static final TMsg UNCOMPLETED_CONSTRUCTION = CompilerMsg.tmsg("%0 is expected.\n");
    private static final TMsg UNDEFINED_VIRTUAL_ATTR = CompilerMsg.tmsg("Virtual attribute '%0' does not have a read or write implementation.");
    private static final TMsg UNDEFVAR = CompilerMsg.tmsg("Undefined variable '%0'.");
    private static final TMsg UNEXTOKEN = CompilerMsg.tmsg("Unexpected '%0'.");
    private static final TMsg UNREACHABLE = CompilerMsg.tmsg("Unreachable statement: '%0'.");
    private static final TMsg UNUSED_VARIABLE = CompilerMsg.tmsg("Variable '%0' declared in '%1' is never used.");
    private static final TMsg VALUEOUTOFRANGE = CompilerMsg.tmsg("Value '%0' of type '%1' must be within the range '%2' to '%3'.");
    private static final TMsg ARRAY_OF = CompilerMsg.tmsg("Array of %0");
    private static final TMsg ASSOC_ARRAY = CompilerMsg.tmsg("Associative array from %0 to %1");
    public static Msg BPM_OBJECT = CompilerMsg.msg("%(BPM_OBJECT)");
    public static Msg FULL_SYNTAX = CompilerMsg.msg("full syntax");
    public static Msg DEPRECATED_EXCEPTION_CONSTRUCTION = CompilerMsg.msg("This construction is no longer supported.");
    public static final Msg MISSINGINDEX = CompilerMsg.msg("The array index is missing.");
    public static final Msg NOT_SUPPORTED = CompilerMsg.msg("This construction is not supported.");
    public static final Msg NULL_REFERENCE_NO_ARGS = CompilerMsg.msg("Null reference.");
    public static final Msg OUTARGLVALUE = CompilerMsg.msg("A variable in the left of an assignment should be used to assign the value of an output argument.");
    public static final Msg RETRY_STEP = CompilerMsg.msg("Retry Step.");
    public static final Msg RETURNNOTALLOWED = CompilerMsg.msg("Return statements can only be used in functions.");
    public static final Msg SQLNOTALLOWED = CompilerMsg.msg("SQL statements can only be used in functions or procedures that run on the server side.");
    private static final TMsg INVALID_LVALUE = CompilerMsg.tmsg("A value cannot be assigned to the expression '%0'.");
    public static final Msg SQL_IN_ARRAY = CompilerMsg.msg("Only literal arrays are allowed in SQL 'in' clauses.");
    public static final Msg SYNTAX = CompilerMsg.msg("Syntax error.");
    public static final Msg TOOFEWCOLS = CompilerMsg.msg("Missing columns.");
    public static final Msg TOOFEWVALUES = CompilerMsg.msg("Missing values.");
    public static final Msg TOOMANYCOLS = CompilerMsg.msg("Too many columns");
    public static final Msg TOOMANYVALUES = CompilerMsg.msg("Too many values");
    public static final Msg DIVIDE_BY_ZERO = CompilerMsg.msg("Division by zero.");
    public static final Msg SUPER_NOT_SUPPORTED = CompilerMsg.msg("The use of 'super' is deprecated, it may cause errors at publication time. 'super' should be replaced with the class name of the parent class.");
    public static final Msg DUPLICATE_CASE_EXPR = CompilerMsg.msg("Duplicated case expression.");
    public static final Msg EXPARRAYVALUE = CompilerMsg.msg("An array value was expected. However, a map value was received.");
    public static final Msg EXPMAPVALUE = CompilerMsg.msg("A map value was expected. However, an array value was received.");
    public static final Msg EXPRESSION_AS_STATEMENT = CompilerMsg.msg("Cannot use an expression as a statement.");
    public static final Msg IGNORE_STEP = CompilerMsg.msg("Skip Step.");
    public static final Msg INCOMPATOPTIONS = CompilerMsg.msg("'required' and 'read-only' are non compatible options.");
    public static final Msg INC_DEC_NOT_SUPPORTED = CompilerMsg.msg("The increment and decrement operands are valid expressions.");
    public static final Msg INFLOOP = CompilerMsg.msg("Infinite loop");
    public static final Msg INTERACTIVE_WITHOUT_RELAY = CompilerMsg.msg("Projects deployed to a process execution engine running on a J2EE container can only run client side component when invoked within a screenflow. It is mandatory that any existing client side component outside screenflows (task method implementation, BPM Object methods, etc) are migrated to a screenflow implementation to enforce proper project compilation and execution at runtime.");
    public static final Msg INTERRUPTION = CompilerMsg.msg("CIL interrupted.");
    public static final Msg INVALIDEXIT = CompilerMsg.msg("'exit' cannot be used to exit from a function. A 'return' statement should be used.");
    public static final Msg INVAUTODECL = CompilerMsg.msg("Cannot autodeclare a 'null' variable.");
    public static final Msg INVAUTODECLARR = CompilerMsg.msg("Cannot autodeclare an array without a type.");
    public static final Msg INVRVALUE = CompilerMsg.msg("Invalid 'relay to' argument. The parameters must exactly match an argument name.");
    public static final Msg INVTOIFLOCAL = CompilerMsg.msg("Illegal use of the 'relay to' in a local component.");
    public static final Msg CANNOT_OPTIMIZE_WHERE_CLAUSE = CompilerMsg.msg("Where clause cannot be optimized. Consider simplifying the expression.");
    public static final Msg COMPONENT = CompilerMsg.msg("component");
    public static final Msg CONDITION = CompilerMsg.msg("condition");
    public static final Msg END_OF_EXPRESSION = CompilerMsg.msg("end of expression");
    public static final Msg END_OF_METHOD = CompilerMsg.msg("end of method");
    public static final Msg EXPRESSION = CompilerMsg.msg("expression");
    public static final Msg IDENTIFIER = CompilerMsg.msg("Identifier");
    private static final TMsg J2EE_ONLY = CompilerMsg.tmsg("Member '%0' of '%1' will only work in J2EE deployment environments.");
    public static final Msg MESSAGE = CompilerMsg.msg("message");
    public static final Msg METHOD = CompilerMsg.msg("method");
    public static final Msg TABLE = CompilerMsg.msg("table");
    public static final Msg TITLE = CompilerMsg.msg("title");
    public static final Msg RULE_ADD_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_AND_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_ARG = CompilerMsg.msg("argument");
    public static final Msg RULE_ARGS = CompilerMsg.msg("arguments");
    public static final Msg RULE_ARG_LIST = CompilerMsg.msg("argument list");
    public static final Msg RULE_ARG_MODE = CompilerMsg.msg("argument mode");
    public static final Msg RULE_ARG_NAME = CompilerMsg.msg("argument name");
    public static final Msg RULE_ARG_TARGET = CompilerMsg.msg("rule_arg_target");
    public static final Msg RULE_ARG_TYPE = CompilerMsg.msg("argument type");
    public static final Msg RULE_ARRAY_ELEMENT = CompilerMsg.msg("array element");
    public static final Msg RULE_ARRAY_ELEMENTS = CompilerMsg.msg("array elements");
    public static final Msg RULE_ARRAY_EXPR = CompilerMsg.msg("array expression");
    public static final Msg RULE_ARRAY_SPEC = CompilerMsg.msg("array specification");
    public static final Msg RULE_ASSIGNMENT = CompilerMsg.msg("assignment");
    public static final Msg RULE_SIMPLE_ASSIGNMENT = CompilerMsg.msg("assignment");
    public static final Msg RULE_REF_ASSIGNMENT = CompilerMsg.msg("assignment");
    public static final Msg RULE_ASSIGNMENT_EXPRESSION = CompilerMsg.msg("assignment expression");
    public static final Msg RULE_BASIC_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_BASIC_REFERENCE = CompilerMsg.msg("expression");
    public static final Msg RULE_BLOCK = CompilerMsg.msg("block");
    public static final Msg RULE_BLOCK_OR_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_BUILT_IN_TYPE = CompilerMsg.msg("built-in type");
    public static final Msg RULE_CALL_STATEMENT = CompilerMsg.msg("call statement");
    public static final Msg RULE_CASES = CompilerMsg.msg("cases");
    public static final Msg RULE_CASE_CLAUSE = CompilerMsg.msg("case clause");
    public static final Msg RULE_CASE_CLAUSES = CompilerMsg.msg("case clauses");
    public static final Msg RULE_CASE_ELSE_STATEMENT = CompilerMsg.msg("case statement");
    public static final Msg RULE_CASE_EXPR = CompilerMsg.msg("case expression");
    public static final Msg RULE_CASE_STATEMENT = CompilerMsg.msg("case statement");
    public static final Msg RULE_CASE_STATEMENTS = CompilerMsg.msg("case statements");
    public static final Msg RULE_CAST_EXPR = CompilerMsg.msg("cast expression");
    public static final Msg RULE_CAST_TARGET = CompilerMsg.msg("cast target");
    public static final Msg RULE_CATCH_STATEMENT = CompilerMsg.msg("catch statement");
    public static final Msg RULE_BLOCK_OR_STATEMENT_BODY = CompilerMsg.msg("body of block or statement");
    public static final Msg RULE_END_NAMED_BLOCK = CompilerMsg.msg("end of named block");
    public static final Msg RULE_CATCH_STATEMENTS = CompilerMsg.msg("catch statements");
    public static final Msg RULE_CLASSIC_INVOCATION = CompilerMsg.msg("invocation");
    public static final Msg RULE_CONCAT_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_CONDITIONAL_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_CONSTANT = CompilerMsg.msg("constant");
    public static final Msg RULE_DECLARATION = CompilerMsg.msg("declaration");
    public static final Msg RULE_DECLARATIONS = CompilerMsg.msg("declarations");
    public static final Msg RULE_DEREF_PRIMARY = CompilerMsg.msg("expression");
    public static final Msg RULE_DIM_STATEMENT = CompilerMsg.msg("dim statement");
    public static final Msg RULE_DISPLAY_STATEMENT = CompilerMsg.msg("display statement");
    public static final Msg RULE_DO_LOOP_STATEMENT = CompilerMsg.msg("do loop statement");
    public static final Msg RULE_ELSEIF = CompilerMsg.msg("elseif");
    public static final Msg RULE_EMPTY_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_END_STATEMENT = CompilerMsg.msg("end statement");
    public static final Msg RULE_ENUM_LABELS = CompilerMsg.msg("labels");
    public static final Msg RULE_EQUALITY_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_ERASE_STATEMENT = CompilerMsg.msg("erase statement");
    public static final Msg RULE_ERROR_CLAUSE = CompilerMsg.msg("error clause");
    public static final Msg RULE_ERROR_STATEMENT = CompilerMsg.msg("error statement");
    public static final Msg RULE_EXCEPTIONS = CompilerMsg.msg("exceptions");
    public static final Msg RULE_EXIT_STATEMENT = CompilerMsg.msg("exit statement");
    public static final Msg RULE_EXPRESSION = CompilerMsg.msg("expression");
    public static final Msg RULE_EXPRESSION_LIST = CompilerMsg.msg("expression list");
    public static final Msg RULE_FIELD = CompilerMsg.msg("field");
    public static final Msg RULE_FIELDS = CompilerMsg.msg("fields");
    public static final Msg RULE_FIELD_ARRAY = CompilerMsg.msg("array");
    public static final Msg RULE_FIELD_OPTION = CompilerMsg.msg("field option");
    public static final Msg RULE_FIELD_OPTIONS = CompilerMsg.msg("field options");
    public static final Msg RULE_FINALLY_STATEMENT = CompilerMsg.msg("finally statement");
    public static final Msg RULE_FOREACH_STATEMENT = CompilerMsg.msg("for each statement");
    public static final Msg RULE_FORMAL_ARG = CompilerMsg.msg("formal argument");
    public static final Msg RULE_FORMAL_ARGS = CompilerMsg.msg("formal arguments");
    public static final Msg RULE_FOR_COND = CompilerMsg.msg("condition");
    public static final Msg RULE_FOR_INIT = CompilerMsg.msg("initialization");
    public static final Msg RULE_FOR_STATEMENT = CompilerMsg.msg("for statement");
    public static final Msg RULE_FUNCTION = CompilerMsg.msg("function");
    public static final Msg RULE_GET_TYPE_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_GOTO_STATEMENT = CompilerMsg.msg("go to statement");
    public static final Msg RULE_HANDLER_STATEMENT = CompilerMsg.msg("handler statement");
    public static final Msg RULE_ID = CompilerMsg.msg("identifier");
    public static final Msg RULE_ID_OR_NUMBER = CompilerMsg.msg("identifier or number");
    public static final Msg RULE_IF_STATEMENT = CompilerMsg.msg("conditional statement");
    public static final Msg RULE_INOUT_MODE = CompilerMsg.msg("in out mode");
    public static final Msg RULE_INPUT_STATEMENT = CompilerMsg.msg("input statement");
    public static final Msg RULE_INT_DIV_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_IN_ARG = CompilerMsg.msg("input argument");
    public static final Msg RULE_IN_ARGS = CompilerMsg.msg("input arguments");
    public static final Msg RULE_IN_MODE = CompilerMsg.msg("input argument mode");
    public static final Msg RULE_KEYWORD = CompilerMsg.msg("keyword");
    public static final Msg RULE_LABELED_STATEMENT = CompilerMsg.msg("labeled statement");
    public static final Msg RULE_LANG_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_LOGIC_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_LOG_STATEMENT = CompilerMsg.msg("log statement");
    public static final Msg RULE_LOOP_VARIABLE = CompilerMsg.msg("loop variable");
    public static final Msg RULE_METHOD = CompilerMsg.msg("method");
    public static final Msg RULE_METHOD_BODY = CompilerMsg.msg("method body");
    public static final Msg RULE_METHOD_CALL = CompilerMsg.msg("method call");
    public static final Msg RULE_METHOD_CALL_2 = CompilerMsg.msg("method call");
    public static final Msg RULE_METHOD_INVOCATION = CompilerMsg.msg("method invocation");
    public static final Msg RULE_MOD_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_MULTI_DECLARATION = CompilerMsg.msg("declaration");
    public static final Msg RULE_MULT_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_NAMED_EXPRESSION = CompilerMsg.msg("named expression");
    public static final Msg RULE_NAMED_EXPR_LIST = CompilerMsg.msg("named expression list");
    public static final Msg RULE_NEW_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_NOT_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_OLD_DECLARATION = CompilerMsg.msg("declaration");
    public static final Msg RULE_OLD_LANG_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_OLD_STATEMENTS = CompilerMsg.msg("statements");
    public static final Msg RULE_OLD_SWITCH_STATEMENT = CompilerMsg.msg("multi-path conditional statement");
    public static final Msg RULE_ONE_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_ON_ERROR_STATEMENT = CompilerMsg.msg("on error statement");
    public static final Msg RULE_ON_STATEMENT = CompilerMsg.msg("exception handling statement");
    public static final Msg RULE_ON_STATEMENTS = CompilerMsg.msg("exception handling statements");
    public static final Msg RULE_OR_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_OUT_ARG = CompilerMsg.msg("output argument");
    public static final Msg RULE_OUT_ARGS = CompilerMsg.msg("output arguments");
    public static final Msg RULE_OUT_MODE = CompilerMsg.msg("output mode");
    public static final Msg RULE_POST_FIX_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_POSTFIX = CompilerMsg.msg("expression");
    public static final Msg RULE_PRIMARY = CompilerMsg.msg("expression");
    public static final Msg RULE_PRIMARY_REF = CompilerMsg.msg("expression");
    public static final Msg RULE_PRIMITIVE_CAST = CompilerMsg.msg("primitive cast");
    public static final Msg RULE_PROCEDURE = CompilerMsg.msg("procedure");
    public static final Msg RULE_QNAME = CompilerMsg.msg("qualified name");
    public static final Msg RULE_RAISE_STATEMENT = CompilerMsg.msg("raise statement");
    public static final Msg RULE_REDIM_CLAUSE = CompilerMsg.msg("redim clause");
    public static final Msg RULE_REDIM_STATEMENT = CompilerMsg.msg("redim statement");
    public static final Msg RULE_REFERENCE = CompilerMsg.msg("reference");
    public static final Msg RULE_RELATIONAL_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_RELAY = CompilerMsg.msg("relay");
    public static final Msg RULE_RELAY_HEADER = CompilerMsg.msg("relay");
    public static final Msg RULE_RELAY_INPUT = CompilerMsg.msg("input");
    public static final Msg RULE_RELAY_INPUT_ARG = CompilerMsg.msg("argument");
    public static final Msg RULE_RESULT_TYPE = CompilerMsg.msg("result type");
    public static final Msg RULE_RESUME_STATEMENT = CompilerMsg.msg("resume statement");
    public static final Msg RULE_RETURN_STATEMENT = CompilerMsg.msg("return statement");
    public static final Msg RULE_SCOPED_BLOCK = CompilerMsg.msg("block");
    public static final Msg RULE_SELECT_STATEMENT = CompilerMsg.msg("select statement");
    public static final Msg RULE_SET_OR_RANGE = CompilerMsg.msg("collection or range");
    public static final Msg RULE_SIMPLE_TYPE = CompilerMsg.msg("simple type");
    public static final Msg RULE_SINGLE_TYPE = CompilerMsg.msg("type");
    public static final Msg RULE_STATEMENTS = CompilerMsg.msg("statements");
    public static final Msg RULE_STATEMENTS_UNTIL_BREAK = CompilerMsg.msg("statements");
    public static final Msg RULE_STOP_STATEMENT = CompilerMsg.msg("stop statement");
    public static final Msg RULE_SWITCH_BODY = CompilerMsg.msg("statements");
    public static final Msg RULE_SWITCH_CASE = CompilerMsg.msg("case");
    public static final Msg RULE_SWITCH_CASES = CompilerMsg.msg("cases");
    public static final Msg RULE_SWITCH_DEFAULT = CompilerMsg.msg("default");
    public static final Msg RULE_SWITCH_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_SYNC_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_THROW_ARGUMENTS = CompilerMsg.msg("arguments");
    public static final Msg RULE_THROW_STATEMENT = CompilerMsg.msg("throw statement");
    public static final Msg RULE_TRANSFORMATION = CompilerMsg.msg("transformation");
    public static final Msg RULE_TRY_BLOCK = CompilerMsg.msg("block");
    public static final Msg RULE_TRY_STATEMENT = CompilerMsg.msg("statement");
    public static final Msg RULE_TYPE_NAME = CompilerMsg.msg("type name");
    public static final Msg RULE_TYPE_OF_EXPR = CompilerMsg.msg("type of expression");
    public static final Msg RULE_TYPE_PARAMETERS = CompilerMsg.msg("type parameters");
    public static final Msg RULE_TYPE_SPEC = CompilerMsg.msg("type specification");
    public static final Msg RULE_UNARY_EXPR = CompilerMsg.msg("expression");
    public static final Msg RULE_UNNAMED_BLOCK = CompilerMsg.msg("block");
    public static final Msg RULE_VALUE = CompilerMsg.msg("value");
    public static final Msg RULE_VAR_DECLARATION = CompilerMsg.msg("variable declaration");
    public static final Msg RULE_WHILE_STATEMENT = CompilerMsg.msg("while statement");
    public static final Msg RULE_WITH_STATEMENT = CompilerMsg.msg("with statement");

    public static Msg INNER_TYPE_INHERITANCE(String culprit, String innerType, String outerType) {
        return INNER_TYPE_INHERITANCE.args(culprit, innerType, outerType);
    }

    public static Msg CANNOT_INSTANTIATE_ABSTRACT(String abstractType) {
        return CANNOT_INSTANTIATE_ABSTRACT.args(abstractType);
    }

    public static Msg ABSTRACT_MUST_BE_EMPTY(String _arg0) {
        return ABSTRACT_MUST_BE_EMPTY.args(_arg0);
    }

    public static Msg INVALID_LVALUE(String lvalue) {
        return INVALID_LVALUE.args(lvalue);
    }

    public static Msg AMBIGUOUSCALL(String _arg0, String _arg1) {
        return AMBIGUOUSCALL.args(_arg0, _arg1);
    }

    public static Msg AMBIGUOUSCOL(String _arg0) {
        return AMBIGUOUSCOL.args(_arg0);
    }

    public static Msg AMBIGUOUSNAME(String _arg0, String _arg1) {
        return AMBIGUOUSNAME.args(_arg0, _arg1);
    }

    public static Msg ARGNUMBER(String _arg0, String _arg1, String _arg2) {
        return ARGNUMBER.args(_arg0, _arg1, _arg2);
    }

    public static Msg AUTODECL(String _arg0) {
        return AUTODECL.args(_arg0);
    }

    public static Msg BADARG(String _arg0, String _arg1, String _arg2, String _arg3) {
        return BADARG.args(_arg0, _arg1, _arg2, _arg3);
    }

    public static Msg BADINDEX(String _arg0, String _arg1) {
        return BADINDEX.args(_arg0, _arg1);
    }

    public static Msg BREAKPOINT(String _arg0) {
        return BREAKPOINT.args(_arg0);
    }

    public static Msg CANNOT_BE_CACHED_PR_TYPE(String _arg0, String _arg1, String _arg2) {
        return CANNOT_BE_CACHED_PR_TYPE.args(_arg0, _arg1, _arg2);
    }

    public static Msg CANNOT_BE_CACHED_STATIC(String _arg0) {
        return CANNOT_BE_CACHED_STATIC.args(_arg0);
    }

    public static Msg CANNOT_BE_NOT_NULL(String _arg0, String _arg1) {
        return CANNOT_BE_NOT_NULL.args(_arg0, _arg1);
    }

    public static Msg CANNOT_CALL_CONSTR(String _arg0, String _arg1, String _arg2) {
        return CANNOT_CALL_CONSTR.args(_arg0, _arg1, _arg2);
    }

    public static Msg CANNOT_DECLARE_MODULE(String _arg0) {
        return CANNOT_DECLARE_MODULE.args(_arg0);
    }

    public static Msg CANNOT_OVERRIDE(String _arg0, String _arg1, String _arg2) {
        return CANNOT_OVERRIDE.args(_arg0, _arg1, _arg2);
    }

    public static Msg OVERRIDING_DEFAULT_PK(String component, String method) {
        return OVERRIDING_DEFAULT_PK.args(component, method);
    }

    public static Msg CANNOT_REDEFINE_READ_ACCESS(String _arg0) {
        return CANNOT_REDEFINE_READ_ACCESS.args(_arg0);
    }

    public static Msg CANNOT_REDEFINE_WRITE_ACCESS(String _arg0) {
        return CANNOT_REDEFINE_WRITE_ACCESS.args(_arg0);
    }

    public static Msg CANTCONV(String _arg0, String _arg1) {
        return CANTCONV.args(_arg0, _arg1);
    }

    public static Msg CANTEXTEND(String _arg0) {
        return CANTEXTEND.args(_arg0);
    }

    public static Msg CANTEXTENDM(String _arg0, String _arg1) {
        return CANTEXTENDM.args(_arg0, _arg1);
    }

    public static Msg CONSTERR(String _arg0) {
        return CONSTERR.args(_arg0);
    }

    public static Msg CYCLIC_INHERITANCE(String _arg0) {
        return CYCLIC_INHERITANCE.args(_arg0);
    }

    public static Msg DEPRECATED_MEMBER(String _arg0, String _arg1) {
        return DEPRECATED_MEMBER.args(_arg0, _arg1);
    }

    public static Msg DEPRECATED_MEMBER_DETAIL(String _arg0) {
        return DEPRECATED_MEMBER_DETAIL.args(_arg0);
    }

    public static Msg DUPLICATED_ARG(String _arg0, String _arg1) {
        return DUPLICATED_ARG.args(_arg0, _arg1);
    }

    public static Msg DUPLICATED_COLUMN(String _arg0) {
        return DUPLICATED_COLUMN.args(_arg0);
    }

    public static Msg DUPLICATED_DECL(String _arg0) {
        return DUPLICATED_DECL.args(_arg0);
    }

    public static Msg DUPLICATED_POSITION(String _arg0, String _arg1, String _arg2) {
        return DUPLICATED_POSITION.args(_arg0, _arg1, _arg2);
    }

    public static Msg DUPLICATED_TRANSFORM(String _arg0, String _arg1, String _arg2) {
        return DUPLICATED_TRANSFORM.args(_arg0, _arg1, _arg2);
    }

    public static Msg DUPLICATEDCOL(String _arg0) {
        return DUPLICATEDCOL.args(_arg0);
    }

    public static Msg DUPLICATEDEXCEPTION(String _arg0) {
        return DUPLICATEDEXCEPTION.args(_arg0);
    }

    public static Msg ENTERPRISE_ONLY(String _arg0, String _arg1) {
        return ENTERPRISE_ONLY.args(_arg0, _arg1);
    }

    public static Msg EXPFOUND(String _arg0, String _arg1) {
        return EXPFOUND.args(_arg0, _arg1);
    }

    public static Msg EXPRFOUND(String _arg0, String _arg1, String _arg2) {
        return EXPRFOUND.args(_arg0, _arg1, _arg2);
    }

    public static Msg EXPSFOUND(String _arg0, String _arg1) {
        return EXPSFOUND.args(_arg0, _arg1);
    }

    public static Msg INCOMPAT(String _arg0, String _arg1, String _arg2) {
        return INCOMPAT.args(_arg0, _arg1, _arg2);
    }

    public static Msg INTERROR(String _arg0, String _arg1) {
        return INTERROR.args(_arg0, _arg1);
    }

    public static Msg INV_MEMBER_TYPE(String _arg0, String _arg1) {
        return INV_MEMBER_TYPE.args(_arg0, _arg1);
    }

    public static void main(String[] args) {
        System.out.println(CompilerMsg.INTERROR("A", "B"));
    }

    public static Msg INV_PARAM_COUNT(String _arg0) {
        return INV_PARAM_COUNT.args(_arg0);
    }

    public static Msg INV_PARAM_VALUE(String _arg0, String _arg1) {
        return INV_PARAM_VALUE.args(_arg0, _arg1);
    }

    public static Msg INVALID_ABSTRACT_MEMBER(String _arg0, String _arg1) {
        return INVALID_ABSTRACT_MEMBER.args(_arg0, _arg1);
    }

    public static Msg INVALID_INDEX(String _arg0, String _arg1) {
        return INVALID_INDEX.args(_arg0, _arg1);
    }

    public static Msg INVALID_NAME(String _arg0) {
        return INVALID_NAME.args(_arg0);
    }

    public static Msg INVALID_NESTED_NAME(String _arg0) {
        return INVALID_NESTED_NAME.args(_arg0);
    }

    public static Msg INVALID_SIGNATURE(String _arg0, String _arg1, String _arg2) {
        return INVALID_SIGNATURE.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVALID_TX_ARG(String _arg0, String _arg1, String _arg2, String _arg3) {
        return INVALID_TX_ARG.args(_arg0, _arg1, _arg2, _arg3);
    }

    public static Msg INVALID_TX_ARG_NAME(String _arg0, String _arg1, String _arg2) {
        return INVALID_TX_ARG_NAME.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVALIDCOLUMN(String _arg0) {
        return INVALIDCOLUMN.args(_arg0);
    }

    public static Msg INVALIDFUNCTION(String _arg0) {
        return INVALIDFUNCTION.args(_arg0);
    }

    public static Msg INVALIDVALUE(String _arg0, String _arg1) {
        return INVALIDVALUE.args(_arg0, _arg1);
    }

    public static Msg INVARGUMENT(String _arg0, String _arg1) {
        return INVARGUMENT.args(_arg0, _arg1);
    }

    public static Msg INVARGUMENT_H(String _arg0, String _arg1, String _arg2) {
        return INVARGUMENT_H.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVASSIG(String _arg0, String _arg1) {
        return INVASSIG.args(_arg0, _arg1);
    }

    public static Msg INVCALCATTR(String attName) {
        return INVCALCATTR.args(attName);
    }

    public static Msg INVCHAR(String _arg0) {
        return INVCHAR.args(_arg0);
    }

    public static Msg INVFUNASSIG(String type) {
        return INVFUNASSIG.args(type);
    }

    public static Msg INVLABEL(String _arg0) {
        return INVLABEL.args(_arg0);
    }

    public static Msg INVLANGUAGE(String _arg0) {
        return INVLANGUAGE.args(_arg0);
    }

    public static Msg INVMEMBER(String _arg0, String _arg1) {
        return INVMEMBER.args(_arg0, _arg1);
    }

    public static Msg INVMEMBER_H(String _arg0, String _arg1, String _arg2) {
        return INVMEMBER_H.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVNUMBER(String _arg0) {
        return INVNUMBER.args(_arg0);
    }

    public static Msg INVOPERAND(String _arg0, String _arg1) {
        return INVOPERAND.args(_arg0, _arg1);
    }

    public static Msg INVOPTION(String _arg0) {
        return INVOPTION.args(_arg0);
    }

    public static Msg INVREGEXP(String _arg0) {
        return INVREGEXP.args(_arg0);
    }

    public static Msg INVSTATICUSE(String _arg0) {
        return INVSTATICUSE.args(_arg0);
    }

    public static Msg INVTIME(String _arg0) {
        return INVTIME.args(_arg0);
    }

    public static Msg INVTYPE(String _arg0) {
        return INVTYPE.args(_arg0);
    }

    public static Msg INVVARTYPE(String _arg0, String _arg1, String _arg2) {
        return INVVARTYPE.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVVVARRAY(String _arg0, String _arg1, String _arg2) {
        return INVVVARRAY.args(_arg0, _arg1, _arg2);
    }

    public static Msg INVVVMAP(String _arg0, String _arg1, String _arg2) {
        return INVVVMAP.args(_arg0, _arg1, _arg2);
    }

    public static Msg IOERROR(String _arg0) {
        return IOERROR.args(_arg0);
    }

    public static Msg J2EE_ONLY(String _arg0, String _arg1) {
        return J2EE_ONLY.args(_arg0, _arg1);
    }

    public static Msg M_METHOD(String _arg0, String _arg1) {
        return M_METHOD.args(_arg0, _arg1);
    }

    public static Msg M_METHODNOTOBJ(String _arg0) {
        return M_METHODNOTOBJ.args(_arg0);
    }

    public static Msg M_NOTMETHOD(String _arg0, String _arg1) {
        return M_NOTMETHOD.args(_arg0, _arg1);
    }

    public static Msg M_NOTSTATIC(String _arg0, String _arg1) {
        return M_NOTSTATIC.args(_arg0, _arg1);
    }

    public static Msg M_READONLY(String _arg0, String _arg1) {
        return M_READONLY.args(_arg0, _arg1);
    }

    public static Msg M_WRONLY(String _arg0, String _arg1) {
        return M_WRONLY.args(_arg0, _arg1);
    }

    public static Msg MALFORMED_TYPE(String _arg0, String _arg1) {
        return MALFORMED_TYPE.args(_arg0, _arg1);
    }

    public static Msg MEMBER_NOT_IMPLEMENTED(String _arg0, String _arg1, String _arg2) {
        return MEMBER_NOT_IMPLEMENTED.args(_arg0, _arg1, _arg2);
    }

    public static Msg MISSING_EXTERNAL_RESOURCE(String _arg0, String _arg1) {
        return MISSING_EXTERNAL_RESOURCE.args(_arg0, _arg1);
    }

    public static Msg MISSING_CLASSES(String _arg0, String _arg1) {
        return MISSING_CLASSES.args(_arg0, _arg1);
    }

    public static Msg MISSING_MAPPING_EXPR(String _arg0, String _arg1) {
        return MISSING_MAPPING_EXPR.args(_arg0, _arg1);
    }

    public static Msg MISSING_PK(String _arg0) {
        return MISSING_PK.args(_arg0);
    }

    public static Msg MISSING_POSITION(String _arg0) {
        return MISSING_POSITION.args(_arg0);
    }

    public static Msg MISSING_SOURCES(String _arg0, String _arg1) {
        return MISSING_SOURCES.args(_arg0, _arg1);
    }

    public static Msg MISSINGRETURN(String _arg0) {
        return MISSINGRETURN.args(_arg0);
    }

    public static Msg MIXEDTABLES(String _arg0) {
        return MIXEDTABLES.args(_arg0);
    }

    public static Msg N_INARG(String _arg0, String _arg1) {
        return N_INARG.args(_arg0, _arg1);
    }

    public static Msg N_OUTARG(String _arg0, String _arg1) {
        return N_OUTARG.args(_arg0, _arg1);
    }

    public static Msg N_STATICARG(String _arg0, String _arg1) {
        return N_STATICARG.args(_arg0, _arg1);
    }

    public static Msg NAMEMISMATCH(String _arg0, String _arg1) {
        return NAMEMISMATCH.args(_arg0, _arg1);
    }

    public static Msg NONBOOLEAN(String _arg0) {
        return NONBOOLEAN.args(_arg0);
    }

    public static Msg NONLITERAL(String _arg0) {
        return NONLITERAL.args(_arg0);
    }

    public static Msg NONNUM(String _arg0) {
        return NONNUM.args(_arg0);
    }

    public static Msg NOSUCHCOMPONENT(String _arg0) {
        return NOSUCHCOMPONENT.args(_arg0);
    }

    public static Msg NOSUCHMODULE(String _arg0) {
        return NOSUCHMODULE.args(_arg0);
    }

    public static Msg NOT_FO(String _arg0) {
        return NOT_FO.args(_arg0);
    }

    public static Msg NOT_NULL_FOR_PRIMITIVE_TYPE(String _arg0) {
        return NOT_NULL_FOR_PRIMITIVE_TYPE.args(_arg0);
    }

    public static Msg NOTANARRAY(String _arg0, String _arg1) {
        return NOTANARRAY.args(_arg0, _arg1);
    }

    public static Msg NOTANOBJECT(String _arg0) {
        return NOTANOBJECT.args(_arg0);
    }

    public static Msg NOTAPPOPTION(String _arg0, String _arg1) {
        return NOTAPPOPTION.args(_arg0, _arg1);
    }

    public static Msg NOTCLONEABLE(String _arg0) {
        return NOTCLONEABLE.args(_arg0);
    }

    public static Msg NOTEXP(String _arg0) {
        return NOTEXP.args(_arg0);
    }

    public static Msg NOTFUN(String _arg0) {
        return NOTFUN.args(_arg0);
    }

    public static Msg NOTFUN_BUT_PROC(String _arg0, String _arg1) {
        return NOTFUN_BUT_PROC.args(_arg0, _arg1);
    }

    public static Msg NOTINITIALIZED(String _arg0) {
        return NOTINITIALIZED.args(_arg0);
    }

    public static Msg NOTINSTANTIABLE(String _arg0) {
        return NOTINSTANTIABLE.args(_arg0);
    }

    public static Msg NOTRANSF(String _arg0, String _arg1, String _arg2) {
        return NOTRANSF.args(_arg0, _arg1, _arg2);
    }

    public static Msg NOTREXP(String _arg0, String _arg1, String _arg2) {
        return NOTREXP.args(_arg0, _arg1, _arg2);
    }

    public static Msg NOTSEXP(String _arg0, String _arg1) {
        return NOTSEXP.args(_arg0, _arg1);
    }

    public static Msg NOTTABLE(String _arg0) {
        return NOTTABLE.args(_arg0);
    }

    public static Msg NOTTHROWABLE(String _arg0) {
        return NOTTHROWABLE.args(_arg0);
    }

    public static Msg NULL_PRIMITIVE(String _arg0) {
        return NULL_PRIMITIVE.args(_arg0);
    }

    public static Msg NULL_REFERENCE(String _arg0, String _arg1) {
        return NULL_REFERENCE.args(_arg0, _arg1);
    }

    public static Msg OPTION_NO_VALUE(String _arg0) {
        return OPTION_NO_VALUE.args(_arg0);
    }

    public static Msg OPTION_REQ_VALUE(String _arg0) {
        return OPTION_REQ_VALUE.args(_arg0);
    }

    public static Msg OTHER(String _arg0) {
        return OTHER.args(_arg0);
    }

    public static Msg PK_NOT_ATOMIC(String _arg0, String _arg1) {
        return PK_NOT_ATOMIC.args(_arg0, _arg1);
    }

    public static Msg REPLACED_MEMBER(String _arg0, String _arg1, String _arg2) {
        return REPLACED_MEMBER.args(_arg0, _arg1, _arg2);
    }

    public static Msg RT_CONVERSION_FAILED(String _arg0, String _arg1, String _arg2) {
        return RT_CONVERSION_FAILED.args(_arg0, _arg1, _arg2);
    }

    public static Msg RUNTIMECOMP(String _arg0, String _arg1, String _arg2) {
        return RUNTIMECOMP.args(_arg0, _arg1, _arg2);
    }

    public static Msg SILLY_ASSIGN(String _arg0) {
        return SILLY_ASSIGN.args(_arg0);
    }

    public static Msg SILLY_OP(String _arg0, String _arg1) {
        return SILLY_OP.args(_arg0, _arg1);
    }

    public static Msg STACKOVERFLOW(String _arg0) {
        return STACKOVERFLOW.args(_arg0);
    }

    public static Msg TABLENOTFOUND(String _arg0) {
        return TABLENOTFOUND.args(_arg0);
    }

    public static Msg UNBOUNDED_PARAM(String _arg0) {
        return UNBOUNDED_PARAM.args(_arg0);
    }

    public static Msg UNCOMPLETED_CONSTRUCTION(String _arg0) {
        return UNCOMPLETED_CONSTRUCTION.args(_arg0);
    }

    public static Msg UNDEFINED_VIRTUAL_ATTR(String _arg0) {
        return UNDEFINED_VIRTUAL_ATTR.args(_arg0);
    }

    public static Msg UNDEFVAR(String _arg0) {
        return UNDEFVAR.args(_arg0);
    }

    public static Msg UNEXTOKEN(String _arg0) {
        return UNEXTOKEN.args(_arg0);
    }

    public static Msg UNREACHABLE(String _arg0) {
        return UNREACHABLE.args(_arg0);
    }

    public static Msg UNUSED_VARIABLE(String _arg0, String _arg1) {
        return UNUSED_VARIABLE.args(_arg0, _arg1);
    }

    public static Msg VALUEOUTOFRANGE(String _arg0, String _arg1, String _arg2, String _arg3) {
        return VALUEOUTOFRANGE.args(_arg0, _arg1, _arg2, _arg3);
    }

    public static Msg ARRAY_OF(String _arg0) {
        return ARRAY_OF.args(_arg0);
    }

    public static Msg ASSOC_ARRAY(String _arg0, String _arg1) {
        return ASSOC_ARRAY.args(_arg0, _arg1);
    }

    static {
        CompilerMsg.init(CompilerMsg.class);
    }
}

