/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.java;

import java.util.Set;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import org.jetbrains.annotations.NonNls;

public class JavaTypeRenderer
extends TypeRenderer {
    public JavaTypeRenderer(TokenNames names, Set<CharSequence> tokens) {
        super(tokens);
        this.arrayDeclarationStart = names.getArrayDeclarationStart();
        this.arrayDeclarationEnd = names.getArrayDeclarationEnd();
        this.parameterStart = names.getParameterStart();
        this.parameterEnd = names.getParameterEnd();
        this.orderedSymbol = names.getOrderedSymbol();
    }

    @Override
    protected void renderArgument(Argument arg, TypeDescription context, StringBuilder buffer, int flags) {
        this.renderArgModifiers(arg, buffer);
        this.render(arg.getTypeRef(), context, buffer, flags);
        buffer.append(' ');
        this.renderArgName(arg, buffer, flags);
    }

    @Override
    protected void renderBuiltInType(TypeDescription type, @NonNls StringBuilder buffer, int flags) {
        int len = type.getLength();
        boolean primitive = type.isPrimitive();
        switch (type.getKind()) {
            case 2: {
                if (len <= 8) {
                    buffer.append(primitive ? "byte" : "Byte");
                    break;
                }
                if (len <= 16) {
                    buffer.append(primitive ? "short" : "Short");
                    break;
                }
                if (len <= 32) {
                    buffer.append(primitive ? "int" : "Integer");
                    break;
                }
                buffer.append(primitive ? "long" : "Long");
                break;
            }
            case 4: {
                if (len <= 32) {
                    buffer.append(primitive ? "float" : "Float");
                    break;
                }
                buffer.append(primitive ? "double" : "Double");
                break;
            }
            case 1: {
                buffer.append(primitive ? "boolean" : "Boolean");
                break;
            }
            case 0: {
                buffer.append("void");
                break;
            }
            case 5: {
                buffer.append(len == 1 ? "char" : "String" + (len == -1 ? "" : "<" + len + ">"));
                break;
            }
            default: {
                super.renderBuiltInType(type, buffer, flags);
            }
        }
    }
}

