/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.java;

import fuego.parser.RecognitionException;
import fuego.parser.SemanticException;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.IncDecOperator;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.langs.java.JavaCILBaseParser;
import oracle.bpm.compiler.langs.visualbasic.VisualBasicCILParser;
import oracle.bpm.compiler.msg.CompilerMsg;

public final class JavaCILParser
extends JavaCILBaseParser {
    public JavaCILParser(TokenStream lexer) {
        super(lexer);
        this.setSqlExitTokens(new int[]{140, 146});
    }

    @Override
    public void args() throws RecognitionException, TokenStreamException {
        super.args();
        this.result = Function.createArgs(this.result, null);
    }

    @Override
    public void assignmentExpression() throws RecognitionException, TokenStreamException {
        super.assignmentExpression();
        Node op1 = this.result.getOp1();
        if (this.result instanceof Assignment && op1 instanceof Deref) {
            this.result.setOperands(op1.getOp1(), this.result.getOp2());
        }
    }

    @Override
    public void emptyStatement() throws RecognitionException, TokenStreamException {
        super.emptyStatement();
        this.result = this.betweenStatement(null, null);
    }

    @Override
    public void fields() throws RecognitionException, TokenStreamException {
        super.fields();
        this.result = VisualBasicCILParser.processInputFields(this.result);
    }

    public void oneStatement() throws RecognitionException, TokenStreamException {
        super.statement();
        if (!(this.result instanceof Block)) {
            this.result = new Block((AST)this.result);
        }
    }

    @Override
    public void relay() throws RecognitionException, TokenStreamException {
        super.relay();
        this.result = VisualBasicCILParser.processRelayToArgs(this.result);
    }

    @Override
    public void scopedBlock() throws RecognitionException, TokenStreamException {
        super.scopedBlock();
        if (this.result instanceof DoBlock) {
            Node children = this.result.getFirst();
            this.result.setFirst(new Block());
            this.result.addChild((AST)new Block((AST)children));
            this.result.addChild((AST)new Block());
        }
    }

    @Override
    public void statement() throws RecognitionException, TokenStreamException {
        Node before = this.betweenStatement(null, null);
        super.statement();
        this.result = this.betweenStatement(this.result, null);
        if (before != null) {
            before.getLast().setNext(this.result);
            this.result = before;
        }
    }

    @Override
    public void value() throws RecognitionException, TokenStreamException {
        super.value();
        this.result.setParenthesis(true);
    }

    @Override
    void checkValidExpressionStatement(Node exp) throws SemanticException {
        if (exp instanceof Assignment || exp instanceof SetElement || exp instanceof SetMember || exp instanceof IncDecOperator || exp instanceof Function || exp instanceof MemberReference && exp.getOp2() instanceof Completion) {
            return;
        }
        throw new SemanticException(CompilerMsg.EXPRESSION_AS_STATEMENT.getString(), null, exp.getLine(), exp.getColumn());
    }
}

