/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.java;

import fuego.lexer.FuegoLexerInputStream;
import fuego.lexer.LexerConfigurator;
import fuego.parser.TokenStreamException;
import oracle.bpm.compiler.SqlReservedWords;
import oracle.bpm.compiler.langs.fuego.Fuego2CILLexerConfigurator;

public class JavaCILLexerConfigurator
extends LexerConfigurator {
    private static final String[] reservedWords = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized", "@true", "@false", "@null", "enum", "foreach", "ordered", "use", "where", "like", "is", "in", "end", "display", "input", "out", "inout", "relay", "logMessage", "to"};
    private static final String[] multiCharTokens = new String[]{"ADD:+", "SUB:-", "MUL:*", "DIV:/", "REM:%", "AMP:&", "AND:&&", "OR:||", "NOT:!", "EQ:=", "EQEQ:==", "NE:!=", "GT:>", "GE:>=", "LT:<", "LE:<=", "QUESTION:?", "COLON::", "DOT:.", "RANGE:..", "SEMICOLON:;", "COMMA:,", "LPAREN:(", "RPAREN:)", "LBRACK:[", "RBRACK:]", "LBRACE:{", "RBRACE:}", "INC:++", "DEC:--"};

    public JavaCILLexerConfigurator() {
        super("1");
    }

    public boolean isStringDelimiter(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        boolean result = false;
        if (c == '\"') {
            result = true;
        } else if (c == '\'') {
            char c2 = lexer.read();
            char c3 = lexer.read();
            if (c2 == '\\') {
                c3 = lexer.read();
                lexer.unread();
            }
            if (c3 == '\'' && c2 != '\'') {
                result = true;
            }
            lexer.unread();
            lexer.unread();
        }
        return result;
    }

    public String getLanguageName() {
        return "Java";
    }

    protected String[][] getMultiCharTokensArrays(int state) {
        switch (state) {
            case 1: {
                return new String[][]{multiCharTokens, {"CAT:||", "NE:<>", "LBRACE:{"}};
            }
        }
        return new String[][]{multiCharTokens, {"OR:||"}};
    }

    protected String[][] getReservedWordsArrays(int state) {
        switch (state) {
            case 1: {
                return new String[][]{Fuego2CILLexerConfigurator.getReservedWords(), SqlReservedWords.getReservedWords()};
            }
        }
        return new String[][]{reservedWords};
    }
}

