/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.fuego;

import fuego.lexer.LexerConfigurator;
import fuego.parser.TokenStream;
import oracle.bpm.compiler.AbstractCILParser;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.FuegoParser;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.langs.fuego.Fuego1CILLexerConfigurator;
import oracle.bpm.compiler.langs.fuego.Fuego1CILParser;
import oracle.bpm.compiler.langs.fuego.Fuego2CILLexerConfigurator;
import oracle.bpm.compiler.langs.fuego.FuegoCILParser;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.compiler.langs.fuego.FuegoCodeStyle;
import oracle.bpm.compiler.type.TypeRenderer;

public class FuegoLanguageSpec
extends LanguageSpec {
    public FuegoLanguageSpec(int version) {
        super(version, "do,then", "(,),[,],do,end,then,end,then,elseif", "),]");
    }

    @Override
    public String getLabel() {
        return "PBL";
    }

    @Override
    public boolean isOldTypePrecedenceEnabled() {
        return this.getVersion() == 1;
    }

    @Override
    public boolean isReadOnly() {
        return this.getVersion() < 2;
    }

    @Override
    public boolean isFuego() {
        return true;
    }

    @Override
    public boolean isFuego1() {
        return this.getVersion() == 1;
    }

    @Override
    public CodeStyle createCodeStyle() {
        return new FuegoCodeStyle();
    }

    @Override
    public LexerConfigurator createLexerConfigurator() {
        switch (this.getVersion()) {
            case 1: {
                return new Fuego1CILLexerConfigurator();
            }
            case 2: {
                return new Fuego2CILLexerConfigurator();
            }
        }
        throw new IllegalArgumentException("Invalid version: " + this.getVersion());
    }

    @Override
    public SourceGenerator createSourceGenerator() {
        assert (!this.isReadOnly()) : this.getId() + " is a read only skin";
        return new FuegoCILSourceGenerator(this);
    }

    @Override
    protected FuegoParser createParser(TokenStream lexer) {
        AbstractCILParser result = null;
        int version = this.getVersion();
        switch (version) {
            case 1: {
                result = new Fuego1CILParser(lexer);
                break;
            }
            case 2: {
                result = new FuegoCILParser(lexer);
                break;
            }
            default: {
                assert (false) : "Invalid version '" + version + "' for language '" + this.getName() + '\'';
                break;
            }
        }
        return result;
    }

    @Override
    protected TokenNames createTokenNames() {
        TokenNames tokenNames = super.createTokenNames();
        tokenNames.setSqlSeparator(";\n");
        return tokenNames;
    }

    @Override
    protected TypeRenderer createTypeRenderer() {
        return new TypeRenderer(this.getLexerConfigurator().getReservedWords(0).keySet());
    }

    static {
        FuegoLanguageSpec.register(new FuegoLanguageSpec(1));
        FuegoLanguageSpec.register(new FuegoLanguageSpec(2));
    }
}

