/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.fuego;

import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.BaseCILSourceGenerator;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.While;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.Argument;

public class FuegoCILSourceGenerator
extends BaseCILSourceGenerator
implements SourceGenerator {
    public FuegoCILSourceGenerator() throws InvalidLanguageException {
        this(LanguageSpec.getLanguageSpec("Fuego"));
    }

    public FuegoCILSourceGenerator(LanguageSpec langSpec) {
        super(langSpec);
    }

    @Override
    public void generate(Arg arg) {
        this.generateArgument(arg, false);
    }

    @Override
    public void setOptions(String options) {
        super.setOptions(options);
        if (options.indexOf(118) != -1) {
            this.codeStyle.setInvocationStyle((byte)0);
        } else if (options.indexOf(109) != -1) {
            this.codeStyle.setInvocationStyle((byte)1);
        } else if (options.indexOf(102) != -1) {
            this.codeStyle.setInvocationStyle((byte)2);
        }
    }

    @Override
    public void generate(MemberReference ref, Node object, Node member) {
        if (object instanceof Cast) {
            Cast cast = (Cast)object;
            cast.setParenthesis(false);
            cast.setFuntionalSyntax(true);
        }
        super.generate(ref, object, member);
    }

    @Override
    public void generate(While whileNode, Node predicate, Node body) {
        Node result;
        String language;
        LanguageSpec currentLanguage = whileNode.getCurrentLanguage();
        String string = language = currentLanguage != null ? currentLanguage.getName() : null;
        if ("Java".equals(language) && (result = whileNode.rewriteAsFor()) != whileNode) {
            result.generate(this);
            return;
        }
        super.generate(whileNode, predicate, body);
    }

    @Override
    public void generate(Cast cast) {
        String language;
        LanguageSpec currentLanguage = cast.getCurrentLanguage();
        String string = language = currentLanguage != null ? currentLanguage.getName() : null;
        if (!"Fuego".equals(language)) {
            cast.setFuntionalSyntax(true);
        }
        super.generate(cast);
    }

    @Override
    public void generate(Assignment assignment, Node target, Node value) {
        Invoke invoke;
        MethodTypeDescription member;
        Argument result;
        String resultName;
        While nextWhile;
        Node next;
        String language;
        LanguageSpec currentLanguage = assignment.getCurrentLanguage();
        String string = language = currentLanguage != null ? currentLanguage.getName() : null;
        if ("Java".equals(language) && (next = assignment.getNext()) instanceof While && (nextWhile = (While)next).rewriteAsFor(true) == null) {
            return;
        }
        if (value instanceof Invoke && (resultName = (result = (member = (invoke = (Invoke)value).getMemberType()).getResultArgument()).getName()) != null && !resultName.equals("return")) {
            target.setNext(null);
            Arg arg = new Arg(result, target, -1, 2L, false);
            invoke.getOutputArgs().addOutArgument(arg);
            invoke.setStatement(true);
            invoke.setParent(assignment.getParent());
            invoke.generate(this);
            assignment = null;
        }
        if (assignment != null) {
            if (assignment.isStatement()) {
                super.generate(assignment, target, value);
            } else {
                this.pw.print("do (");
                super.generate(assignment, target, value);
                this.pw.print(")");
            }
        }
    }

    @Override
    public void generate(Invoke invoke, Node object, Args inArgs, Args outArgs, String memberName) {
        int kind = object.getKind();
        if (memberName.equals("delete") && (kind == 12 || kind == 13)) {
            this.print("delete");
            this.print(" ");
            object.generate(this);
            this.print("[");
            Arg index = (Arg)inArgs.getFirst();
            index.getValue().generate(this);
            this.println("]");
            return;
        }
        if (this.codeStyle.getInvocationStyle() == 1) {
            super.generate(invoke, object, inArgs, outArgs, memberName);
        } else {
            Invoke targetInvoke;
            boolean function = this.checkIfFunction(invoke, outArgs);
            boolean argVerbose = false;
            boolean reference = object instanceof Deref || object instanceof Identifier.This || object instanceof Const || object instanceof MemberReference || object instanceof ArrayReference || object instanceof MappedArrayReference;
            boolean hasInArgs = FuegoCILSourceGenerator.hasArgs(inArgs);
            boolean hasOutArgs = FuegoCILSourceGenerator.hasArgs(outArgs);
            if (!function && this.codeStyle.getInvocationStyle() == 0 && invoke.isStatement() && reference) {
                this.generateSeparatorBefore(invoke);
                this.print(memberName + " ");
                object.generate(this);
                argVerbose = true;
            } else {
                MethodTypeDescription member = invoke.getMemberType();
                if (member.isConstructor()) {
                    this.generateConstructorName(invoke, member);
                } else {
                    if (member.isStatic()) {
                        object.generate(this);
                        this.print(".");
                    }
                    this.printIdentifier(memberName);
                }
                this.print("(");
                if (!(member.isStatic() || member.isConstructor() || object.isSynthetic())) {
                    object.generate(this);
                    if (hasInArgs || hasOutArgs) {
                        this.print(", ");
                    }
                }
            }
            if (argVerbose) {
                this.generateVerbose(inArgs, true);
            } else {
                this.generate(inArgs);
            }
            if (hasOutArgs) {
                if (hasInArgs && !argVerbose) {
                    this.print(", ");
                }
                if (argVerbose) {
                    this.generateVerbose(outArgs, false);
                } else {
                    this.generate(outArgs);
                }
            }
            if ((targetInvoke = invoke.getTargetInvoke()) != null) {
                this.generateRelayTo(targetInvoke);
            }
            if (!argVerbose) {
                this.print(")");
            }
            if (invoke.isStatement()) {
                this.generateStatementSeparator(invoke);
                this.generateSeparatorAfter(invoke);
            }
        }
    }

    @Override
    public void generate(JavaFor javaFor) {
        Node parent = javaFor.getParent();
        LabeledStatement labeled = (LabeledStatement)(parent instanceof LabeledStatement ? parent : null);
        if (javaFor.isArrayIterator()) {
            Node decl = javaFor.getInit().getFirst();
            String index = decl.getSymbol().getName();
            MemberAccess arrayLength = (MemberAccess)javaFor.getCond().getOp2();
            Node array = arrayLength.getObject();
            if (labeled != null) {
                this.generateLabel(labeled);
            }
            this.print("for ");
            this.printIdentifier(index);
            this.print(" in ");
            this.generateExpr(array, Boolean.FALSE);
            this.println(" do");
            this.indent();
            javaFor.getBody().generate(this);
            this.unindent();
            this.println("end");
        } else {
            this.generateSeparatorBefore(javaFor);
            Node first = javaFor.getInit().getFirst();
            if (first instanceof Declaration) {
                this.println("do");
                this.indent();
                first.generate(this);
            } else if (first instanceof Assignment) {
                for (Assignment assig = (Assignment)first; assig != null; assig = (Assignment)assig.getNext()) {
                    Node var = assig.getOp1();
                    Node expr = assig.getOp2();
                    this.printIdentifier(var.getSymbol().getName());
                    this.printSpaceDelimited(this.getNames().getAssignmentOperator());
                    this.generateExpr(expr);
                    this.generateStatementSeparator(assig);
                }
            }
            if (labeled != null) {
                this.generateLabel(labeled);
            }
            this.print("while ");
            this.generateExpr(javaFor.getCond(), Boolean.FALSE);
            this.println(" do");
            this.indent();
            javaFor.getBody().generate(this);
            javaFor.getReinit().generate(this);
            this.unindent();
            this.println("end");
            if (first instanceof Declaration) {
                this.unindent();
                this.println("end");
            }
        }
    }

    @Override
    public void generate(Not not, Node op) {
        if (op instanceof In) {
            op.generate(this);
        } else {
            super.generate(not, op);
        }
    }

    @Override
    public void generate(In in, Node expr, Node range) {
        boolean negated = in.getParent() instanceof Not;
        this.generateExpr(expr);
        if (negated) {
            this.printSpace();
            this.print(this.getNames().getLogicNot());
        }
        this.printSpaceDelimited(this.getNames().getInSymbol());
        range.generate(this);
    }

    @Override
    protected void generateArgsForInteractiveStm(Args inargs, Args outargs) {
        if (FuegoCILSourceGenerator.hasArgs(inargs)) {
            this.generateVerbose(inargs, true);
        }
        if (FuegoCILSourceGenerator.hasArgs(outargs)) {
            this.generateVerbose(outargs, false);
        }
    }

    @Override
    protected void generateArgsForRelayTo(Args args) {
        this.generateVerbose(args, true);
    }

    @Override
    protected void generateSqlStatementSeparator(Node statement) {
        this.println(";");
    }

    @Override
    protected boolean writeAsFunction(MethodTypeDescription member) {
        String resultName = member.getResultArgument().getName();
        boolean hasReturnName = resultName != null && !resultName.equals("return");
        return !hasReturnName;
    }

    private void generateVerbose(Args args, boolean in) {
        if (!args.hasChildren()) {
            return;
        }
        boolean first = true;
        for (Arg arg = (Arg)args.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
            if (arg.isSynthetic()) continue;
            if (first) {
                this.println();
                this.indent();
                this.print(in ? "using " : "returning ");
                this.pw.fixIndentation();
                first = false;
            } else {
                this.println(", ");
            }
            boolean breakAllowed = this.pw.allowBreak(false);
            this.generateVerbose(arg, "=");
            this.pw.allowBreak(breakAllowed);
        }
        if (!first) {
            this.pw.unfixIndentation();
            this.unindent();
        }
    }

    private void generateVerbose(Arg arg, String separator) {
        Arg targetArg;
        String name;
        Node value = arg.getValue();
        if (arg.isIn() && (name = arg.getArgument().getName()) != null && !name.equals("")) {
            this.printIdentifier(name);
            this.printSpaceDelimited(separator);
        }
        Arg arg2 = targetArg = value instanceof Arg ? (Arg)value : null;
        if (targetArg != null) {
            this.printIdentifier(targetArg.getArgument().getName());
        } else {
            if (value != null) {
                this.generateExpr(value);
            }
            if (arg.isOut()) {
                this.printSpaceDelimited(separator);
                this.printIdentifier(arg.getArgument().getName());
            }
        }
    }
}

