/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.lang.TypeDescription;

public class ValueReference {
    private String name;
    private TypeDescription type;
    private Object value;

    protected ValueReference() {
    }

    ValueReference(Object value, TypeDescription type) {
        this(value, type, null);
    }

    ValueReference(Object value, TypeDescription type, String name) {
        this.value = value;
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TypeDescription getType() {
        return this.type;
    }

    public Object get() {
        return this.value;
    }

    public void set(Object value) {
        this.value = value;
    }

    public String toString() {
        return FuegoCILSourceGenerator.generateCILForValue(this.get());
    }

    static class VariableReference
    extends ValueReference {
        private Symbol var;

        VariableReference(Symbol variable) {
            this.var = variable;
        }

        @Override
        public String getName() {
            return this.var.getName();
        }

        @Override
        public TypeDescription getType() {
            return this.var.getType();
        }

        @Override
        public Object get() {
            return this.var.getValue();
        }

        @Override
        public void set(Object value) {
            this.var.setValue(value);
        }
    }
}

