/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.resources.Msg;
import oracle.bpm.util.ProgressMonitor;

public class Utils {

    public static class SimpleProgressMonitor
    implements ProgressMonitor {
        private int last = -1;

        @Override
        public void error(Msg message) {
            System.err.println(message);
        }

        @Override
        public void info(Msg message) {
        }

        @Override
        public void info(int logLevel, Msg message) {
        }

        @Override
        public void phase(Msg message) {
            System.out.println("[" + message + "]");
        }

        @Override
        public void progress(int percent) {
            if (percent == -2 || percent == 100) {
                System.out.println("[DONE]");
                this.last = -1;
                return;
            }
            if (percent / 10 > this.last / 10) {
                this.last = percent;
                System.out.println(percent / 10 * 10 + "% completed");
            }
        }

        @Override
        public void warning(Msg message) {
        }
    }
}

