/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Update
extends SQLStatement {
    public Update(Token t) {
        super(t);
    }

    Update() {
    }

    @Override
    public String getText() {
        return "update";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    Node getTable() {
        return this.getOp1();
    }

    Node getValues() {
        return this.getOp2();
    }

    Node getWhere() {
        return this.getOp3();
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Tables table = this.checkTable(this.removeFirst());
        SetValues values = (SetValues)this.getFirst();
        Node where = values.getNext();
        values.checkType();
        this.collectParameters(values);
        if (where != null) {
            where = where.checkType();
            this.collectParameters(where);
            this.setOperands(table, values, where);
        } else {
            this.setOperands(table, values);
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        Node table = this.getFirst();
        Node values = table.getNext();
        Node where = values.getNext();
        query.append("UPDATE ");
        table.generateSQLCode(query);
        values.generateSQLCode(query);
        if (where != null) {
            query.append(" WHERE ");
            where.generateSQLCode(query);
        }
    }

    public static final class SetValues
    extends Node {
        public SetValues(Token t) {
            super(t);
            this.setParametric(false);
        }

        SetValues() {
            this((Token)null);
        }

        @Override
        public void generate(SourceGenerator cg) {
            cg.generate(this);
        }

        @Override
        Node checkType() throws TypeException {
            for (Node current = this.getFirst(); current != null; current = current.getNext()) {
                Node column = current.getFirst();
                Node expr = column.getNext();
                column = ((SqlColumnReference)column).checkType(true);
                TypeDescription columnType = column.getTypeDescription();
                expr = expr.checkType(columnType);
                current.setOperands(column, expr);
                if (columnType.isAssignableFrom(expr.getTypeDescription())) continue;
                throw new InvalidAssignmentException((Node)this, expr, column);
            }
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        @Override
        void generateSQLCode(StringBuffer query) {
            query.append(" SET ");
            SetValues.generateCommaDelimitedSQL(this.getFirst(), query);
        }
    }
}

