/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.util.FixOption;

public class UnusedVariableException
extends CompilerException {
    static final long serialVersionUID = -3731634897882494046L;
    static final long serialCheck = -8695534677270482993L;

    public UnusedVariableException(Declaration decl) {
        super(decl.getFirst());
        this.setOffset(-1);
        this.setKey(CompilerMsg.UNUSED_VARIABLE(decl.getName(), UnusedVariableException.text(this.getMember(), decl)));
        this.setFixOptions(new FixOption[]{new RemoveDeclaration(decl)});
    }

    static class RemoveDeclaration
    extends FixOption {
        Declaration decl;

        public RemoveDeclaration(Declaration decl) {
            super("Remove declaration");
            this.decl = decl;
        }

        @Override
        public void fix() throws CompilerException {
            if (this.decl != null) {
                this.decl.remove();
                this.decl = null;
            }
        }
    }
}

