/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.math.BigDecimal;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidOperandException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.filter.Operation;

public class UnaryArithmetic
extends Node {
    private boolean minus;

    UnaryArithmetic() {
    }

    UnaryArithmetic(Token token, boolean minus) {
        super(token);
        this.minus = minus;
    }

    @Override
    public String getText() {
        return this.getOperandName();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public boolean isMinus() {
        return this.minus;
    }

    String getOperandName() {
        return this.minus ? "-" : "+";
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation[] operand = new Operation[]{this.getFirst().getOperationTree()};
        return new Operation(17, "-", operand);
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        super.checkType();
        Node op = this.getFirst();
        TypeDescription td = op.getTypeDescription();
        if (!td.isNumber() && !td.isInterval()) {
            throw new InvalidOperandException((Node)this, this.getText(), td);
        }
        this.setTypeDescription(td);
        return this.isGeneratingSource() || !op.isConstant() ? this : (this.isMinus() ? op.negate().dettach() : op);
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (!this.checkParameter(sql)) {
            sql.append("( ");
            if (this.isMinus()) {
                sql.append("- ");
            }
            this.getFirst().generateSQLCode(sql);
            sql.append(" )");
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object result = this.getFirst().value(rm);
        if (this.isMinus()) {
            TypeDescription type = this.getTypeDescription();
            switch (this.getFirst().getKind()) {
                case 2: {
                    Number num = (Number)result;
                    result = IntConst.createValue(num != null ? num.longValue() : 0L, type);
                    break;
                }
                case 3: {
                    result = Decimal.negate((BigDecimal)result);
                    break;
                }
                case 4: {
                    Number num = (Number)result;
                    result = RealConst.createValue(num != null ? num.doubleValue() : 0.0, type);
                    break;
                }
                case 7: {
                    result = Interval.negate((Interval)result);
                }
            }
        }
        return result;
    }

    public static class UPlus
    extends UnaryArithmetic {
        public UPlus(Token t) {
            super(t, false);
        }
    }

    public static class UMinus
    extends UnaryArithmetic {
        public UMinus(Token t) {
            super(t, true);
        }
    }
}

